// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18202__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18202__auto__){
return or__18202__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18202__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__23486_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__23486_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__23491 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__23492 = null;
var count__23493 = (0);
var i__23494 = (0);
while(true){
if((i__23494 < count__23493)){
var n = cljs.core._nth.call(null,chunk__23492,i__23494);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23495 = seq__23491;
var G__23496 = chunk__23492;
var G__23497 = count__23493;
var G__23498 = (i__23494 + (1));
seq__23491 = G__23495;
chunk__23492 = G__23496;
count__23493 = G__23497;
i__23494 = G__23498;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23491);
if(temp__4425__auto__){
var seq__23491__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23491__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__23491__$1);
var G__23499 = cljs.core.chunk_rest.call(null,seq__23491__$1);
var G__23500 = c__19005__auto__;
var G__23501 = cljs.core.count.call(null,c__19005__auto__);
var G__23502 = (0);
seq__23491 = G__23499;
chunk__23492 = G__23500;
count__23493 = G__23501;
i__23494 = G__23502;
continue;
} else {
var n = cljs.core.first.call(null,seq__23491__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23503 = cljs.core.next.call(null,seq__23491__$1);
var G__23504 = null;
var G__23505 = (0);
var G__23506 = (0);
seq__23491 = G__23503;
chunk__23492 = G__23504;
count__23493 = G__23505;
i__23494 = G__23506;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__23545_23552 = cljs.core.seq.call(null,deps);
var chunk__23546_23553 = null;
var count__23547_23554 = (0);
var i__23548_23555 = (0);
while(true){
if((i__23548_23555 < count__23547_23554)){
var dep_23556 = cljs.core._nth.call(null,chunk__23546_23553,i__23548_23555);
topo_sort_helper_STAR_.call(null,dep_23556,(depth + (1)),state);

var G__23557 = seq__23545_23552;
var G__23558 = chunk__23546_23553;
var G__23559 = count__23547_23554;
var G__23560 = (i__23548_23555 + (1));
seq__23545_23552 = G__23557;
chunk__23546_23553 = G__23558;
count__23547_23554 = G__23559;
i__23548_23555 = G__23560;
continue;
} else {
var temp__4425__auto___23561 = cljs.core.seq.call(null,seq__23545_23552);
if(temp__4425__auto___23561){
var seq__23545_23562__$1 = temp__4425__auto___23561;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23545_23562__$1)){
var c__19005__auto___23563 = cljs.core.chunk_first.call(null,seq__23545_23562__$1);
var G__23564 = cljs.core.chunk_rest.call(null,seq__23545_23562__$1);
var G__23565 = c__19005__auto___23563;
var G__23566 = cljs.core.count.call(null,c__19005__auto___23563);
var G__23567 = (0);
seq__23545_23552 = G__23564;
chunk__23546_23553 = G__23565;
count__23547_23554 = G__23566;
i__23548_23555 = G__23567;
continue;
} else {
var dep_23568 = cljs.core.first.call(null,seq__23545_23562__$1);
topo_sort_helper_STAR_.call(null,dep_23568,(depth + (1)),state);

var G__23569 = cljs.core.next.call(null,seq__23545_23562__$1);
var G__23570 = null;
var G__23571 = (0);
var G__23572 = (0);
seq__23545_23552 = G__23569;
chunk__23546_23553 = G__23570;
count__23547_23554 = G__23571;
i__23548_23555 = G__23572;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__23549){
var vec__23551 = p__23549;
var x = cljs.core.nth.call(null,vec__23551,(0),null);
var xs = cljs.core.nthnext.call(null,vec__23551,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__23551,x,xs,get_deps__$1){
return (function (p1__23507_SHARP_){
return clojure.set.difference.call(null,p1__23507_SHARP_,x);
});})(vec__23551,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__23585 = cljs.core.seq.call(null,provides);
var chunk__23586 = null;
var count__23587 = (0);
var i__23588 = (0);
while(true){
if((i__23588 < count__23587)){
var prov = cljs.core._nth.call(null,chunk__23586,i__23588);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23589_23597 = cljs.core.seq.call(null,requires);
var chunk__23590_23598 = null;
var count__23591_23599 = (0);
var i__23592_23600 = (0);
while(true){
if((i__23592_23600 < count__23591_23599)){
var req_23601 = cljs.core._nth.call(null,chunk__23590_23598,i__23592_23600);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23601,prov);

var G__23602 = seq__23589_23597;
var G__23603 = chunk__23590_23598;
var G__23604 = count__23591_23599;
var G__23605 = (i__23592_23600 + (1));
seq__23589_23597 = G__23602;
chunk__23590_23598 = G__23603;
count__23591_23599 = G__23604;
i__23592_23600 = G__23605;
continue;
} else {
var temp__4425__auto___23606 = cljs.core.seq.call(null,seq__23589_23597);
if(temp__4425__auto___23606){
var seq__23589_23607__$1 = temp__4425__auto___23606;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23589_23607__$1)){
var c__19005__auto___23608 = cljs.core.chunk_first.call(null,seq__23589_23607__$1);
var G__23609 = cljs.core.chunk_rest.call(null,seq__23589_23607__$1);
var G__23610 = c__19005__auto___23608;
var G__23611 = cljs.core.count.call(null,c__19005__auto___23608);
var G__23612 = (0);
seq__23589_23597 = G__23609;
chunk__23590_23598 = G__23610;
count__23591_23599 = G__23611;
i__23592_23600 = G__23612;
continue;
} else {
var req_23613 = cljs.core.first.call(null,seq__23589_23607__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23613,prov);

var G__23614 = cljs.core.next.call(null,seq__23589_23607__$1);
var G__23615 = null;
var G__23616 = (0);
var G__23617 = (0);
seq__23589_23597 = G__23614;
chunk__23590_23598 = G__23615;
count__23591_23599 = G__23616;
i__23592_23600 = G__23617;
continue;
}
} else {
}
}
break;
}

var G__23618 = seq__23585;
var G__23619 = chunk__23586;
var G__23620 = count__23587;
var G__23621 = (i__23588 + (1));
seq__23585 = G__23618;
chunk__23586 = G__23619;
count__23587 = G__23620;
i__23588 = G__23621;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23585);
if(temp__4425__auto__){
var seq__23585__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23585__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__23585__$1);
var G__23622 = cljs.core.chunk_rest.call(null,seq__23585__$1);
var G__23623 = c__19005__auto__;
var G__23624 = cljs.core.count.call(null,c__19005__auto__);
var G__23625 = (0);
seq__23585 = G__23622;
chunk__23586 = G__23623;
count__23587 = G__23624;
i__23588 = G__23625;
continue;
} else {
var prov = cljs.core.first.call(null,seq__23585__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23593_23626 = cljs.core.seq.call(null,requires);
var chunk__23594_23627 = null;
var count__23595_23628 = (0);
var i__23596_23629 = (0);
while(true){
if((i__23596_23629 < count__23595_23628)){
var req_23630 = cljs.core._nth.call(null,chunk__23594_23627,i__23596_23629);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23630,prov);

var G__23631 = seq__23593_23626;
var G__23632 = chunk__23594_23627;
var G__23633 = count__23595_23628;
var G__23634 = (i__23596_23629 + (1));
seq__23593_23626 = G__23631;
chunk__23594_23627 = G__23632;
count__23595_23628 = G__23633;
i__23596_23629 = G__23634;
continue;
} else {
var temp__4425__auto___23635__$1 = cljs.core.seq.call(null,seq__23593_23626);
if(temp__4425__auto___23635__$1){
var seq__23593_23636__$1 = temp__4425__auto___23635__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23593_23636__$1)){
var c__19005__auto___23637 = cljs.core.chunk_first.call(null,seq__23593_23636__$1);
var G__23638 = cljs.core.chunk_rest.call(null,seq__23593_23636__$1);
var G__23639 = c__19005__auto___23637;
var G__23640 = cljs.core.count.call(null,c__19005__auto___23637);
var G__23641 = (0);
seq__23593_23626 = G__23638;
chunk__23594_23627 = G__23639;
count__23595_23628 = G__23640;
i__23596_23629 = G__23641;
continue;
} else {
var req_23642 = cljs.core.first.call(null,seq__23593_23636__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23642,prov);

var G__23643 = cljs.core.next.call(null,seq__23593_23636__$1);
var G__23644 = null;
var G__23645 = (0);
var G__23646 = (0);
seq__23593_23626 = G__23643;
chunk__23594_23627 = G__23644;
count__23595_23628 = G__23645;
i__23596_23629 = G__23646;
continue;
}
} else {
}
}
break;
}

var G__23647 = cljs.core.next.call(null,seq__23585__$1);
var G__23648 = null;
var G__23649 = (0);
var G__23650 = (0);
seq__23585 = G__23647;
chunk__23586 = G__23648;
count__23587 = G__23649;
i__23588 = G__23650;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__23655_23659 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__23656_23660 = null;
var count__23657_23661 = (0);
var i__23658_23662 = (0);
while(true){
if((i__23658_23662 < count__23657_23661)){
var ns_23663 = cljs.core._nth.call(null,chunk__23656_23660,i__23658_23662);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23663);

var G__23664 = seq__23655_23659;
var G__23665 = chunk__23656_23660;
var G__23666 = count__23657_23661;
var G__23667 = (i__23658_23662 + (1));
seq__23655_23659 = G__23664;
chunk__23656_23660 = G__23665;
count__23657_23661 = G__23666;
i__23658_23662 = G__23667;
continue;
} else {
var temp__4425__auto___23668 = cljs.core.seq.call(null,seq__23655_23659);
if(temp__4425__auto___23668){
var seq__23655_23669__$1 = temp__4425__auto___23668;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23655_23669__$1)){
var c__19005__auto___23670 = cljs.core.chunk_first.call(null,seq__23655_23669__$1);
var G__23671 = cljs.core.chunk_rest.call(null,seq__23655_23669__$1);
var G__23672 = c__19005__auto___23670;
var G__23673 = cljs.core.count.call(null,c__19005__auto___23670);
var G__23674 = (0);
seq__23655_23659 = G__23671;
chunk__23656_23660 = G__23672;
count__23657_23661 = G__23673;
i__23658_23662 = G__23674;
continue;
} else {
var ns_23675 = cljs.core.first.call(null,seq__23655_23669__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23675);

var G__23676 = cljs.core.next.call(null,seq__23655_23669__$1);
var G__23677 = null;
var G__23678 = (0);
var G__23679 = (0);
seq__23655_23659 = G__23676;
chunk__23656_23660 = G__23677;
count__23657_23661 = G__23678;
i__23658_23662 = G__23679;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18202__auto__ = goog.require__;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__23680__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__23680 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23681__i = 0, G__23681__a = new Array(arguments.length -  0);
while (G__23681__i < G__23681__a.length) {G__23681__a[G__23681__i] = arguments[G__23681__i + 0]; ++G__23681__i;}
  args = new cljs.core.IndexedSeq(G__23681__a,0);
} 
return G__23680__delegate.call(this,args);};
G__23680.cljs$lang$maxFixedArity = 0;
G__23680.cljs$lang$applyTo = (function (arglist__23682){
var args = cljs.core.seq(arglist__23682);
return G__23680__delegate(args);
});
G__23680.cljs$core$IFn$_invoke$arity$variadic = G__23680__delegate;
return G__23680;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__23684 = cljs.core._EQ_;
var expr__23685 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__23684.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__23685))){
var path_parts = ((function (pred__23684,expr__23685){
return (function (p1__23683_SHARP_){
return clojure.string.split.call(null,p1__23683_SHARP_,/[\/\\]/);
});})(pred__23684,expr__23685))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__23684,expr__23685){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e23687){if((e23687 instanceof Error)){
var e = e23687;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e23687;

}
}})());
});
;})(path_parts,sep,root,pred__23684,expr__23685))
} else {
if(cljs.core.truth_(pred__23684.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__23685))){
return ((function (pred__23684,expr__23685){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__23684,expr__23685){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__23684,expr__23685))
);

return deferred.addErrback(((function (deferred,pred__23684,expr__23685){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__23684,expr__23685))
);
});
;})(pred__23684,expr__23685))
} else {
return ((function (pred__23684,expr__23685){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__23684,expr__23685))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__23688,callback){
var map__23691 = p__23688;
var map__23691__$1 = ((((!((map__23691 == null)))?((((map__23691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23691):map__23691);
var file_msg = map__23691__$1;
var request_url = cljs.core.get.call(null,map__23691__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__23691,map__23691__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__23691,map__23691__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__){
return (function (state_23715){
var state_val_23716 = (state_23715[(1)]);
if((state_val_23716 === (7))){
var inst_23711 = (state_23715[(2)]);
var state_23715__$1 = state_23715;
var statearr_23717_23737 = state_23715__$1;
(statearr_23717_23737[(2)] = inst_23711);

(statearr_23717_23737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (1))){
var state_23715__$1 = state_23715;
var statearr_23718_23738 = state_23715__$1;
(statearr_23718_23738[(2)] = null);

(statearr_23718_23738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (4))){
var inst_23695 = (state_23715[(7)]);
var inst_23695__$1 = (state_23715[(2)]);
var state_23715__$1 = (function (){var statearr_23719 = state_23715;
(statearr_23719[(7)] = inst_23695__$1);

return statearr_23719;
})();
if(cljs.core.truth_(inst_23695__$1)){
var statearr_23720_23739 = state_23715__$1;
(statearr_23720_23739[(1)] = (5));

} else {
var statearr_23721_23740 = state_23715__$1;
(statearr_23721_23740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (6))){
var state_23715__$1 = state_23715;
var statearr_23722_23741 = state_23715__$1;
(statearr_23722_23741[(2)] = null);

(statearr_23722_23741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (3))){
var inst_23713 = (state_23715[(2)]);
var state_23715__$1 = state_23715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23715__$1,inst_23713);
} else {
if((state_val_23716 === (2))){
var state_23715__$1 = state_23715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23715__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_23716 === (11))){
var inst_23707 = (state_23715[(2)]);
var state_23715__$1 = (function (){var statearr_23723 = state_23715;
(statearr_23723[(8)] = inst_23707);

return statearr_23723;
})();
var statearr_23724_23742 = state_23715__$1;
(statearr_23724_23742[(2)] = null);

(statearr_23724_23742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (9))){
var inst_23699 = (state_23715[(9)]);
var inst_23701 = (state_23715[(10)]);
var inst_23703 = inst_23701.call(null,inst_23699);
var state_23715__$1 = state_23715;
var statearr_23725_23743 = state_23715__$1;
(statearr_23725_23743[(2)] = inst_23703);

(statearr_23725_23743[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (5))){
var inst_23695 = (state_23715[(7)]);
var inst_23697 = figwheel.client.file_reloading.blocking_load.call(null,inst_23695);
var state_23715__$1 = state_23715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23715__$1,(8),inst_23697);
} else {
if((state_val_23716 === (10))){
var inst_23699 = (state_23715[(9)]);
var inst_23705 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_23699);
var state_23715__$1 = state_23715;
var statearr_23726_23744 = state_23715__$1;
(statearr_23726_23744[(2)] = inst_23705);

(statearr_23726_23744[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23716 === (8))){
var inst_23695 = (state_23715[(7)]);
var inst_23701 = (state_23715[(10)]);
var inst_23699 = (state_23715[(2)]);
var inst_23700 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_23701__$1 = cljs.core.get.call(null,inst_23700,inst_23695);
var state_23715__$1 = (function (){var statearr_23727 = state_23715;
(statearr_23727[(9)] = inst_23699);

(statearr_23727[(10)] = inst_23701__$1);

return statearr_23727;
})();
if(cljs.core.truth_(inst_23701__$1)){
var statearr_23728_23745 = state_23715__$1;
(statearr_23728_23745[(1)] = (9));

} else {
var statearr_23729_23746 = state_23715__$1;
(statearr_23729_23746[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__))
;
return ((function (switch__20505__auto__,c__20617__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20506__auto__ = null;
var figwheel$client$file_reloading$state_machine__20506__auto____0 = (function (){
var statearr_23733 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23733[(0)] = figwheel$client$file_reloading$state_machine__20506__auto__);

(statearr_23733[(1)] = (1));

return statearr_23733;
});
var figwheel$client$file_reloading$state_machine__20506__auto____1 = (function (state_23715){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23734){if((e23734 instanceof Object)){
var ex__20509__auto__ = e23734;
var statearr_23735_23747 = state_23715;
(statearr_23735_23747[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23715);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23748 = state_23715;
state_23715 = G__23748;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20506__auto__ = function(state_23715){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20506__auto____1.call(this,state_23715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20506__auto____0;
figwheel$client$file_reloading$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20506__auto____1;
return figwheel$client$file_reloading$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__))
})();
var state__20619__auto__ = (function (){var statearr_23736 = f__20618__auto__.call(null);
(statearr_23736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_23736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__))
);

return c__20617__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__23749,callback){
var map__23752 = p__23749;
var map__23752__$1 = ((((!((map__23752 == null)))?((((map__23752.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23752.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23752):map__23752);
var file_msg = map__23752__$1;
var namespace = cljs.core.get.call(null,map__23752__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__23752,map__23752__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__23752,map__23752__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__23754){
var map__23757 = p__23754;
var map__23757__$1 = ((((!((map__23757 == null)))?((((map__23757.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23757.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23757):map__23757);
var file_msg = map__23757__$1;
var namespace = cljs.core.get.call(null,map__23757__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18190__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18190__auto__){
var or__18202__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
var or__18202__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18202__auto____$1)){
return or__18202__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18190__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__23759,callback){
var map__23762 = p__23759;
var map__23762__$1 = ((((!((map__23762 == null)))?((((map__23762.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23762.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23762):map__23762);
var file_msg = map__23762__$1;
var request_url = cljs.core.get.call(null,map__23762__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__23762__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20617__auto___23850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___23850,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___23850,out){
return (function (state_23832){
var state_val_23833 = (state_23832[(1)]);
if((state_val_23833 === (1))){
var inst_23810 = cljs.core.nth.call(null,files,(0),null);
var inst_23811 = cljs.core.nthnext.call(null,files,(1));
var inst_23812 = files;
var state_23832__$1 = (function (){var statearr_23834 = state_23832;
(statearr_23834[(7)] = inst_23810);

(statearr_23834[(8)] = inst_23812);

(statearr_23834[(9)] = inst_23811);

return statearr_23834;
})();
var statearr_23835_23851 = state_23832__$1;
(statearr_23835_23851[(2)] = null);

(statearr_23835_23851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23833 === (2))){
var inst_23815 = (state_23832[(10)]);
var inst_23812 = (state_23832[(8)]);
var inst_23815__$1 = cljs.core.nth.call(null,inst_23812,(0),null);
var inst_23816 = cljs.core.nthnext.call(null,inst_23812,(1));
var inst_23817 = (inst_23815__$1 == null);
var inst_23818 = cljs.core.not.call(null,inst_23817);
var state_23832__$1 = (function (){var statearr_23836 = state_23832;
(statearr_23836[(10)] = inst_23815__$1);

(statearr_23836[(11)] = inst_23816);

return statearr_23836;
})();
if(inst_23818){
var statearr_23837_23852 = state_23832__$1;
(statearr_23837_23852[(1)] = (4));

} else {
var statearr_23838_23853 = state_23832__$1;
(statearr_23838_23853[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23833 === (3))){
var inst_23830 = (state_23832[(2)]);
var state_23832__$1 = state_23832;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23832__$1,inst_23830);
} else {
if((state_val_23833 === (4))){
var inst_23815 = (state_23832[(10)]);
var inst_23820 = figwheel.client.file_reloading.reload_js_file.call(null,inst_23815);
var state_23832__$1 = state_23832;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23832__$1,(7),inst_23820);
} else {
if((state_val_23833 === (5))){
var inst_23826 = cljs.core.async.close_BANG_.call(null,out);
var state_23832__$1 = state_23832;
var statearr_23839_23854 = state_23832__$1;
(statearr_23839_23854[(2)] = inst_23826);

(statearr_23839_23854[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23833 === (6))){
var inst_23828 = (state_23832[(2)]);
var state_23832__$1 = state_23832;
var statearr_23840_23855 = state_23832__$1;
(statearr_23840_23855[(2)] = inst_23828);

(statearr_23840_23855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23833 === (7))){
var inst_23816 = (state_23832[(11)]);
var inst_23822 = (state_23832[(2)]);
var inst_23823 = cljs.core.async.put_BANG_.call(null,out,inst_23822);
var inst_23812 = inst_23816;
var state_23832__$1 = (function (){var statearr_23841 = state_23832;
(statearr_23841[(8)] = inst_23812);

(statearr_23841[(12)] = inst_23823);

return statearr_23841;
})();
var statearr_23842_23856 = state_23832__$1;
(statearr_23842_23856[(2)] = null);

(statearr_23842_23856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20617__auto___23850,out))
;
return ((function (switch__20505__auto__,c__20617__auto___23850,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____0 = (function (){
var statearr_23846 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23846[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__);

(statearr_23846[(1)] = (1));

return statearr_23846;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____1 = (function (state_23832){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23832);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23847){if((e23847 instanceof Object)){
var ex__20509__auto__ = e23847;
var statearr_23848_23857 = state_23832;
(statearr_23848_23857[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23832);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23847;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23858 = state_23832;
state_23832 = G__23858;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__ = function(state_23832){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____1.call(this,state_23832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___23850,out))
})();
var state__20619__auto__ = (function (){var statearr_23849 = f__20618__auto__.call(null);
(statearr_23849[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___23850);

return statearr_23849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___23850,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__23859,opts){
var map__23863 = p__23859;
var map__23863__$1 = ((((!((map__23863 == null)))?((((map__23863.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23863.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23863):map__23863);
var eval_body__$1 = cljs.core.get.call(null,map__23863__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__23863__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18190__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18190__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18190__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e23865){var e = e23865;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__23866_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23866_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__23871){
var vec__23872 = p__23871;
var k = cljs.core.nth.call(null,vec__23872,(0),null);
var v = cljs.core.nth.call(null,vec__23872,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__23873){
var vec__23874 = p__23873;
var k = cljs.core.nth.call(null,vec__23874,(0),null);
var v = cljs.core.nth.call(null,vec__23874,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__23878,p__23879){
var map__24126 = p__23878;
var map__24126__$1 = ((((!((map__24126 == null)))?((((map__24126.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24126.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24126):map__24126);
var opts = map__24126__$1;
var before_jsload = cljs.core.get.call(null,map__24126__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__24126__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__24126__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__24127 = p__23879;
var map__24127__$1 = ((((!((map__24127 == null)))?((((map__24127.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24127.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24127):map__24127);
var msg = map__24127__$1;
var files = cljs.core.get.call(null,map__24127__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__24127__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__24127__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_24280){
var state_val_24281 = (state_24280[(1)]);
if((state_val_24281 === (7))){
var inst_24142 = (state_24280[(7)]);
var inst_24144 = (state_24280[(8)]);
var inst_24141 = (state_24280[(9)]);
var inst_24143 = (state_24280[(10)]);
var inst_24149 = cljs.core._nth.call(null,inst_24142,inst_24144);
var inst_24150 = figwheel.client.file_reloading.eval_body.call(null,inst_24149,opts);
var inst_24151 = (inst_24144 + (1));
var tmp24282 = inst_24142;
var tmp24283 = inst_24141;
var tmp24284 = inst_24143;
var inst_24141__$1 = tmp24283;
var inst_24142__$1 = tmp24282;
var inst_24143__$1 = tmp24284;
var inst_24144__$1 = inst_24151;
var state_24280__$1 = (function (){var statearr_24285 = state_24280;
(statearr_24285[(7)] = inst_24142__$1);

(statearr_24285[(11)] = inst_24150);

(statearr_24285[(8)] = inst_24144__$1);

(statearr_24285[(9)] = inst_24141__$1);

(statearr_24285[(10)] = inst_24143__$1);

return statearr_24285;
})();
var statearr_24286_24372 = state_24280__$1;
(statearr_24286_24372[(2)] = null);

(statearr_24286_24372[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (20))){
var inst_24184 = (state_24280[(12)]);
var inst_24192 = figwheel.client.file_reloading.sort_files.call(null,inst_24184);
var state_24280__$1 = state_24280;
var statearr_24287_24373 = state_24280__$1;
(statearr_24287_24373[(2)] = inst_24192);

(statearr_24287_24373[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (27))){
var state_24280__$1 = state_24280;
var statearr_24288_24374 = state_24280__$1;
(statearr_24288_24374[(2)] = null);

(statearr_24288_24374[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (1))){
var inst_24133 = (state_24280[(13)]);
var inst_24130 = before_jsload.call(null,files);
var inst_24131 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_24132 = (function (){return ((function (inst_24133,inst_24130,inst_24131,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23875_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23875_SHARP_);
});
;})(inst_24133,inst_24130,inst_24131,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24133__$1 = cljs.core.filter.call(null,inst_24132,files);
var inst_24134 = cljs.core.not_empty.call(null,inst_24133__$1);
var state_24280__$1 = (function (){var statearr_24289 = state_24280;
(statearr_24289[(13)] = inst_24133__$1);

(statearr_24289[(14)] = inst_24131);

(statearr_24289[(15)] = inst_24130);

return statearr_24289;
})();
if(cljs.core.truth_(inst_24134)){
var statearr_24290_24375 = state_24280__$1;
(statearr_24290_24375[(1)] = (2));

} else {
var statearr_24291_24376 = state_24280__$1;
(statearr_24291_24376[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (24))){
var state_24280__$1 = state_24280;
var statearr_24292_24377 = state_24280__$1;
(statearr_24292_24377[(2)] = null);

(statearr_24292_24377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (39))){
var inst_24234 = (state_24280[(16)]);
var state_24280__$1 = state_24280;
var statearr_24293_24378 = state_24280__$1;
(statearr_24293_24378[(2)] = inst_24234);

(statearr_24293_24378[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (46))){
var inst_24275 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24294_24379 = state_24280__$1;
(statearr_24294_24379[(2)] = inst_24275);

(statearr_24294_24379[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (4))){
var inst_24178 = (state_24280[(2)]);
var inst_24179 = cljs.core.List.EMPTY;
var inst_24180 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_24179);
var inst_24181 = (function (){return ((function (inst_24178,inst_24179,inst_24180,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23876_SHARP_){
var and__18190__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23876_SHARP_);
if(cljs.core.truth_(and__18190__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23876_SHARP_));
} else {
return and__18190__auto__;
}
});
;})(inst_24178,inst_24179,inst_24180,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24182 = cljs.core.filter.call(null,inst_24181,files);
var inst_24183 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_24184 = cljs.core.concat.call(null,inst_24182,inst_24183);
var state_24280__$1 = (function (){var statearr_24295 = state_24280;
(statearr_24295[(12)] = inst_24184);

(statearr_24295[(17)] = inst_24180);

(statearr_24295[(18)] = inst_24178);

return statearr_24295;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_24296_24380 = state_24280__$1;
(statearr_24296_24380[(1)] = (16));

} else {
var statearr_24297_24381 = state_24280__$1;
(statearr_24297_24381[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (15))){
var inst_24168 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24298_24382 = state_24280__$1;
(statearr_24298_24382[(2)] = inst_24168);

(statearr_24298_24382[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (21))){
var inst_24194 = (state_24280[(19)]);
var inst_24194__$1 = (state_24280[(2)]);
var inst_24195 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_24194__$1);
var state_24280__$1 = (function (){var statearr_24299 = state_24280;
(statearr_24299[(19)] = inst_24194__$1);

return statearr_24299;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24280__$1,(22),inst_24195);
} else {
if((state_val_24281 === (31))){
var inst_24278 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24280__$1,inst_24278);
} else {
if((state_val_24281 === (32))){
var inst_24234 = (state_24280[(16)]);
var inst_24239 = inst_24234.cljs$lang$protocol_mask$partition0$;
var inst_24240 = (inst_24239 & (64));
var inst_24241 = inst_24234.cljs$core$ISeq$;
var inst_24242 = (inst_24240) || (inst_24241);
var state_24280__$1 = state_24280;
if(cljs.core.truth_(inst_24242)){
var statearr_24300_24383 = state_24280__$1;
(statearr_24300_24383[(1)] = (35));

} else {
var statearr_24301_24384 = state_24280__$1;
(statearr_24301_24384[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (40))){
var inst_24255 = (state_24280[(20)]);
var inst_24254 = (state_24280[(2)]);
var inst_24255__$1 = cljs.core.get.call(null,inst_24254,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_24256 = cljs.core.get.call(null,inst_24254,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_24257 = cljs.core.not_empty.call(null,inst_24255__$1);
var state_24280__$1 = (function (){var statearr_24302 = state_24280;
(statearr_24302[(20)] = inst_24255__$1);

(statearr_24302[(21)] = inst_24256);

return statearr_24302;
})();
if(cljs.core.truth_(inst_24257)){
var statearr_24303_24385 = state_24280__$1;
(statearr_24303_24385[(1)] = (41));

} else {
var statearr_24304_24386 = state_24280__$1;
(statearr_24304_24386[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (33))){
var state_24280__$1 = state_24280;
var statearr_24305_24387 = state_24280__$1;
(statearr_24305_24387[(2)] = false);

(statearr_24305_24387[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (13))){
var inst_24154 = (state_24280[(22)]);
var inst_24158 = cljs.core.chunk_first.call(null,inst_24154);
var inst_24159 = cljs.core.chunk_rest.call(null,inst_24154);
var inst_24160 = cljs.core.count.call(null,inst_24158);
var inst_24141 = inst_24159;
var inst_24142 = inst_24158;
var inst_24143 = inst_24160;
var inst_24144 = (0);
var state_24280__$1 = (function (){var statearr_24306 = state_24280;
(statearr_24306[(7)] = inst_24142);

(statearr_24306[(8)] = inst_24144);

(statearr_24306[(9)] = inst_24141);

(statearr_24306[(10)] = inst_24143);

return statearr_24306;
})();
var statearr_24307_24388 = state_24280__$1;
(statearr_24307_24388[(2)] = null);

(statearr_24307_24388[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (22))){
var inst_24202 = (state_24280[(23)]);
var inst_24194 = (state_24280[(19)]);
var inst_24198 = (state_24280[(24)]);
var inst_24197 = (state_24280[(25)]);
var inst_24197__$1 = (state_24280[(2)]);
var inst_24198__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24197__$1);
var inst_24199 = (function (){var all_files = inst_24194;
var res_SINGLEQUOTE_ = inst_24197__$1;
var res = inst_24198__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_24202,inst_24194,inst_24198,inst_24197,inst_24197__$1,inst_24198__$1,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23877_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__23877_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_24202,inst_24194,inst_24198,inst_24197,inst_24197__$1,inst_24198__$1,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24200 = cljs.core.filter.call(null,inst_24199,inst_24197__$1);
var inst_24201 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_24202__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24201);
var inst_24203 = cljs.core.not_empty.call(null,inst_24202__$1);
var state_24280__$1 = (function (){var statearr_24308 = state_24280;
(statearr_24308[(23)] = inst_24202__$1);

(statearr_24308[(26)] = inst_24200);

(statearr_24308[(24)] = inst_24198__$1);

(statearr_24308[(25)] = inst_24197__$1);

return statearr_24308;
})();
if(cljs.core.truth_(inst_24203)){
var statearr_24309_24389 = state_24280__$1;
(statearr_24309_24389[(1)] = (23));

} else {
var statearr_24310_24390 = state_24280__$1;
(statearr_24310_24390[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (36))){
var state_24280__$1 = state_24280;
var statearr_24311_24391 = state_24280__$1;
(statearr_24311_24391[(2)] = false);

(statearr_24311_24391[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (41))){
var inst_24255 = (state_24280[(20)]);
var inst_24259 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_24260 = cljs.core.map.call(null,inst_24259,inst_24255);
var inst_24261 = cljs.core.pr_str.call(null,inst_24260);
var inst_24262 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_24261)].join('');
var inst_24263 = figwheel.client.utils.log.call(null,inst_24262);
var state_24280__$1 = state_24280;
var statearr_24312_24392 = state_24280__$1;
(statearr_24312_24392[(2)] = inst_24263);

(statearr_24312_24392[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (43))){
var inst_24256 = (state_24280[(21)]);
var inst_24266 = (state_24280[(2)]);
var inst_24267 = cljs.core.not_empty.call(null,inst_24256);
var state_24280__$1 = (function (){var statearr_24313 = state_24280;
(statearr_24313[(27)] = inst_24266);

return statearr_24313;
})();
if(cljs.core.truth_(inst_24267)){
var statearr_24314_24393 = state_24280__$1;
(statearr_24314_24393[(1)] = (44));

} else {
var statearr_24315_24394 = state_24280__$1;
(statearr_24315_24394[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (29))){
var inst_24202 = (state_24280[(23)]);
var inst_24194 = (state_24280[(19)]);
var inst_24200 = (state_24280[(26)]);
var inst_24198 = (state_24280[(24)]);
var inst_24197 = (state_24280[(25)]);
var inst_24234 = (state_24280[(16)]);
var inst_24230 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_24233 = (function (){var all_files = inst_24194;
var res_SINGLEQUOTE_ = inst_24197;
var res = inst_24198;
var files_not_loaded = inst_24200;
var dependencies_that_loaded = inst_24202;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24234,inst_24230,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24232){
var map__24316 = p__24232;
var map__24316__$1 = ((((!((map__24316 == null)))?((((map__24316.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24316.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24316):map__24316);
var namespace = cljs.core.get.call(null,map__24316__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24234,inst_24230,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24234__$1 = cljs.core.group_by.call(null,inst_24233,inst_24200);
var inst_24236 = (inst_24234__$1 == null);
var inst_24237 = cljs.core.not.call(null,inst_24236);
var state_24280__$1 = (function (){var statearr_24318 = state_24280;
(statearr_24318[(16)] = inst_24234__$1);

(statearr_24318[(28)] = inst_24230);

return statearr_24318;
})();
if(inst_24237){
var statearr_24319_24395 = state_24280__$1;
(statearr_24319_24395[(1)] = (32));

} else {
var statearr_24320_24396 = state_24280__$1;
(statearr_24320_24396[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (44))){
var inst_24256 = (state_24280[(21)]);
var inst_24269 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24256);
var inst_24270 = cljs.core.pr_str.call(null,inst_24269);
var inst_24271 = [cljs.core.str("not required: "),cljs.core.str(inst_24270)].join('');
var inst_24272 = figwheel.client.utils.log.call(null,inst_24271);
var state_24280__$1 = state_24280;
var statearr_24321_24397 = state_24280__$1;
(statearr_24321_24397[(2)] = inst_24272);

(statearr_24321_24397[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (6))){
var inst_24175 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24322_24398 = state_24280__$1;
(statearr_24322_24398[(2)] = inst_24175);

(statearr_24322_24398[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (28))){
var inst_24200 = (state_24280[(26)]);
var inst_24227 = (state_24280[(2)]);
var inst_24228 = cljs.core.not_empty.call(null,inst_24200);
var state_24280__$1 = (function (){var statearr_24323 = state_24280;
(statearr_24323[(29)] = inst_24227);

return statearr_24323;
})();
if(cljs.core.truth_(inst_24228)){
var statearr_24324_24399 = state_24280__$1;
(statearr_24324_24399[(1)] = (29));

} else {
var statearr_24325_24400 = state_24280__$1;
(statearr_24325_24400[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (25))){
var inst_24198 = (state_24280[(24)]);
var inst_24214 = (state_24280[(2)]);
var inst_24215 = cljs.core.not_empty.call(null,inst_24198);
var state_24280__$1 = (function (){var statearr_24326 = state_24280;
(statearr_24326[(30)] = inst_24214);

return statearr_24326;
})();
if(cljs.core.truth_(inst_24215)){
var statearr_24327_24401 = state_24280__$1;
(statearr_24327_24401[(1)] = (26));

} else {
var statearr_24328_24402 = state_24280__$1;
(statearr_24328_24402[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (34))){
var inst_24249 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
if(cljs.core.truth_(inst_24249)){
var statearr_24329_24403 = state_24280__$1;
(statearr_24329_24403[(1)] = (38));

} else {
var statearr_24330_24404 = state_24280__$1;
(statearr_24330_24404[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (17))){
var state_24280__$1 = state_24280;
var statearr_24331_24405 = state_24280__$1;
(statearr_24331_24405[(2)] = recompile_dependents);

(statearr_24331_24405[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (3))){
var state_24280__$1 = state_24280;
var statearr_24332_24406 = state_24280__$1;
(statearr_24332_24406[(2)] = null);

(statearr_24332_24406[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (12))){
var inst_24171 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24333_24407 = state_24280__$1;
(statearr_24333_24407[(2)] = inst_24171);

(statearr_24333_24407[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (2))){
var inst_24133 = (state_24280[(13)]);
var inst_24140 = cljs.core.seq.call(null,inst_24133);
var inst_24141 = inst_24140;
var inst_24142 = null;
var inst_24143 = (0);
var inst_24144 = (0);
var state_24280__$1 = (function (){var statearr_24334 = state_24280;
(statearr_24334[(7)] = inst_24142);

(statearr_24334[(8)] = inst_24144);

(statearr_24334[(9)] = inst_24141);

(statearr_24334[(10)] = inst_24143);

return statearr_24334;
})();
var statearr_24335_24408 = state_24280__$1;
(statearr_24335_24408[(2)] = null);

(statearr_24335_24408[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (23))){
var inst_24202 = (state_24280[(23)]);
var inst_24194 = (state_24280[(19)]);
var inst_24200 = (state_24280[(26)]);
var inst_24198 = (state_24280[(24)]);
var inst_24197 = (state_24280[(25)]);
var inst_24205 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_24207 = (function (){var all_files = inst_24194;
var res_SINGLEQUOTE_ = inst_24197;
var res = inst_24198;
var files_not_loaded = inst_24200;
var dependencies_that_loaded = inst_24202;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24205,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24206){
var map__24336 = p__24206;
var map__24336__$1 = ((((!((map__24336 == null)))?((((map__24336.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24336.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24336):map__24336);
var request_url = cljs.core.get.call(null,map__24336__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24205,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24208 = cljs.core.reverse.call(null,inst_24202);
var inst_24209 = cljs.core.map.call(null,inst_24207,inst_24208);
var inst_24210 = cljs.core.pr_str.call(null,inst_24209);
var inst_24211 = figwheel.client.utils.log.call(null,inst_24210);
var state_24280__$1 = (function (){var statearr_24338 = state_24280;
(statearr_24338[(31)] = inst_24205);

return statearr_24338;
})();
var statearr_24339_24409 = state_24280__$1;
(statearr_24339_24409[(2)] = inst_24211);

(statearr_24339_24409[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (35))){
var state_24280__$1 = state_24280;
var statearr_24340_24410 = state_24280__$1;
(statearr_24340_24410[(2)] = true);

(statearr_24340_24410[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (19))){
var inst_24184 = (state_24280[(12)]);
var inst_24190 = figwheel.client.file_reloading.expand_files.call(null,inst_24184);
var state_24280__$1 = state_24280;
var statearr_24341_24411 = state_24280__$1;
(statearr_24341_24411[(2)] = inst_24190);

(statearr_24341_24411[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (11))){
var state_24280__$1 = state_24280;
var statearr_24342_24412 = state_24280__$1;
(statearr_24342_24412[(2)] = null);

(statearr_24342_24412[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (9))){
var inst_24173 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24343_24413 = state_24280__$1;
(statearr_24343_24413[(2)] = inst_24173);

(statearr_24343_24413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (5))){
var inst_24144 = (state_24280[(8)]);
var inst_24143 = (state_24280[(10)]);
var inst_24146 = (inst_24144 < inst_24143);
var inst_24147 = inst_24146;
var state_24280__$1 = state_24280;
if(cljs.core.truth_(inst_24147)){
var statearr_24344_24414 = state_24280__$1;
(statearr_24344_24414[(1)] = (7));

} else {
var statearr_24345_24415 = state_24280__$1;
(statearr_24345_24415[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (14))){
var inst_24154 = (state_24280[(22)]);
var inst_24163 = cljs.core.first.call(null,inst_24154);
var inst_24164 = figwheel.client.file_reloading.eval_body.call(null,inst_24163,opts);
var inst_24165 = cljs.core.next.call(null,inst_24154);
var inst_24141 = inst_24165;
var inst_24142 = null;
var inst_24143 = (0);
var inst_24144 = (0);
var state_24280__$1 = (function (){var statearr_24346 = state_24280;
(statearr_24346[(7)] = inst_24142);

(statearr_24346[(32)] = inst_24164);

(statearr_24346[(8)] = inst_24144);

(statearr_24346[(9)] = inst_24141);

(statearr_24346[(10)] = inst_24143);

return statearr_24346;
})();
var statearr_24347_24416 = state_24280__$1;
(statearr_24347_24416[(2)] = null);

(statearr_24347_24416[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (45))){
var state_24280__$1 = state_24280;
var statearr_24348_24417 = state_24280__$1;
(statearr_24348_24417[(2)] = null);

(statearr_24348_24417[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (26))){
var inst_24202 = (state_24280[(23)]);
var inst_24194 = (state_24280[(19)]);
var inst_24200 = (state_24280[(26)]);
var inst_24198 = (state_24280[(24)]);
var inst_24197 = (state_24280[(25)]);
var inst_24217 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_24219 = (function (){var all_files = inst_24194;
var res_SINGLEQUOTE_ = inst_24197;
var res = inst_24198;
var files_not_loaded = inst_24200;
var dependencies_that_loaded = inst_24202;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24217,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24218){
var map__24349 = p__24218;
var map__24349__$1 = ((((!((map__24349 == null)))?((((map__24349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24349):map__24349);
var namespace = cljs.core.get.call(null,map__24349__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__24349__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24217,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24220 = cljs.core.map.call(null,inst_24219,inst_24198);
var inst_24221 = cljs.core.pr_str.call(null,inst_24220);
var inst_24222 = figwheel.client.utils.log.call(null,inst_24221);
var inst_24223 = (function (){var all_files = inst_24194;
var res_SINGLEQUOTE_ = inst_24197;
var res = inst_24198;
var files_not_loaded = inst_24200;
var dependencies_that_loaded = inst_24202;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24217,inst_24219,inst_24220,inst_24221,inst_24222,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24202,inst_24194,inst_24200,inst_24198,inst_24197,inst_24217,inst_24219,inst_24220,inst_24221,inst_24222,state_val_24281,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24224 = setTimeout(inst_24223,(10));
var state_24280__$1 = (function (){var statearr_24351 = state_24280;
(statearr_24351[(33)] = inst_24217);

(statearr_24351[(34)] = inst_24222);

return statearr_24351;
})();
var statearr_24352_24418 = state_24280__$1;
(statearr_24352_24418[(2)] = inst_24224);

(statearr_24352_24418[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (16))){
var state_24280__$1 = state_24280;
var statearr_24353_24419 = state_24280__$1;
(statearr_24353_24419[(2)] = reload_dependents);

(statearr_24353_24419[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (38))){
var inst_24234 = (state_24280[(16)]);
var inst_24251 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24234);
var state_24280__$1 = state_24280;
var statearr_24354_24420 = state_24280__$1;
(statearr_24354_24420[(2)] = inst_24251);

(statearr_24354_24420[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (30))){
var state_24280__$1 = state_24280;
var statearr_24355_24421 = state_24280__$1;
(statearr_24355_24421[(2)] = null);

(statearr_24355_24421[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (10))){
var inst_24154 = (state_24280[(22)]);
var inst_24156 = cljs.core.chunked_seq_QMARK_.call(null,inst_24154);
var state_24280__$1 = state_24280;
if(inst_24156){
var statearr_24356_24422 = state_24280__$1;
(statearr_24356_24422[(1)] = (13));

} else {
var statearr_24357_24423 = state_24280__$1;
(statearr_24357_24423[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (18))){
var inst_24188 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
if(cljs.core.truth_(inst_24188)){
var statearr_24358_24424 = state_24280__$1;
(statearr_24358_24424[(1)] = (19));

} else {
var statearr_24359_24425 = state_24280__$1;
(statearr_24359_24425[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (42))){
var state_24280__$1 = state_24280;
var statearr_24360_24426 = state_24280__$1;
(statearr_24360_24426[(2)] = null);

(statearr_24360_24426[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (37))){
var inst_24246 = (state_24280[(2)]);
var state_24280__$1 = state_24280;
var statearr_24361_24427 = state_24280__$1;
(statearr_24361_24427[(2)] = inst_24246);

(statearr_24361_24427[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24281 === (8))){
var inst_24141 = (state_24280[(9)]);
var inst_24154 = (state_24280[(22)]);
var inst_24154__$1 = cljs.core.seq.call(null,inst_24141);
var state_24280__$1 = (function (){var statearr_24362 = state_24280;
(statearr_24362[(22)] = inst_24154__$1);

return statearr_24362;
})();
if(inst_24154__$1){
var statearr_24363_24428 = state_24280__$1;
(statearr_24363_24428[(1)] = (10));

} else {
var statearr_24364_24429 = state_24280__$1;
(statearr_24364_24429[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20505__auto__,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____0 = (function (){
var statearr_24368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24368[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__);

(statearr_24368[(1)] = (1));

return statearr_24368;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____1 = (function (state_24280){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_24280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e24369){if((e24369 instanceof Object)){
var ex__20509__auto__ = e24369;
var statearr_24370_24430 = state_24280;
(statearr_24370_24430[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24280);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24369;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24431 = state_24280;
state_24280 = G__24431;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__ = function(state_24280){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____1.call(this,state_24280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20619__auto__ = (function (){var statearr_24371 = f__20618__auto__.call(null);
(statearr_24371[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_24371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__,map__24126,map__24126__$1,opts,before_jsload,on_jsload,reload_dependents,map__24127,map__24127__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20617__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__24434,link){
var map__24437 = p__24434;
var map__24437__$1 = ((((!((map__24437 == null)))?((((map__24437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24437):map__24437);
var file = cljs.core.get.call(null,map__24437__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__24437,map__24437__$1,file){
return (function (p1__24432_SHARP_,p2__24433_SHARP_){
if(cljs.core._EQ_.call(null,p1__24432_SHARP_,p2__24433_SHARP_)){
return p1__24432_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__24437,map__24437__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__24443){
var map__24444 = p__24443;
var map__24444__$1 = ((((!((map__24444 == null)))?((((map__24444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24444):map__24444);
var match_length = cljs.core.get.call(null,map__24444__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__24444__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__24439_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__24439_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args24446 = [];
var len__19260__auto___24449 = arguments.length;
var i__19261__auto___24450 = (0);
while(true){
if((i__19261__auto___24450 < len__19260__auto___24449)){
args24446.push((arguments[i__19261__auto___24450]));

var G__24451 = (i__19261__auto___24450 + (1));
i__19261__auto___24450 = G__24451;
continue;
} else {
}
break;
}

var G__24448 = args24446.length;
switch (G__24448) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24446.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__24453_SHARP_,p2__24454_SHARP_){
return cljs.core.assoc.call(null,p1__24453_SHARP_,cljs.core.get.call(null,p2__24454_SHARP_,key),p2__24454_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__24455){
var map__24458 = p__24455;
var map__24458__$1 = ((((!((map__24458 == null)))?((((map__24458.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24458.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24458):map__24458);
var f_data = map__24458__$1;
var file = cljs.core.get.call(null,map__24458__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__24460,files_msg){
var map__24467 = p__24460;
var map__24467__$1 = ((((!((map__24467 == null)))?((((map__24467.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24467.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24467):map__24467);
var opts = map__24467__$1;
var on_cssload = cljs.core.get.call(null,map__24467__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__24469_24473 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__24470_24474 = null;
var count__24471_24475 = (0);
var i__24472_24476 = (0);
while(true){
if((i__24472_24476 < count__24471_24475)){
var f_24477 = cljs.core._nth.call(null,chunk__24470_24474,i__24472_24476);
figwheel.client.file_reloading.reload_css_file.call(null,f_24477);

var G__24478 = seq__24469_24473;
var G__24479 = chunk__24470_24474;
var G__24480 = count__24471_24475;
var G__24481 = (i__24472_24476 + (1));
seq__24469_24473 = G__24478;
chunk__24470_24474 = G__24479;
count__24471_24475 = G__24480;
i__24472_24476 = G__24481;
continue;
} else {
var temp__4425__auto___24482 = cljs.core.seq.call(null,seq__24469_24473);
if(temp__4425__auto___24482){
var seq__24469_24483__$1 = temp__4425__auto___24482;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24469_24483__$1)){
var c__19005__auto___24484 = cljs.core.chunk_first.call(null,seq__24469_24483__$1);
var G__24485 = cljs.core.chunk_rest.call(null,seq__24469_24483__$1);
var G__24486 = c__19005__auto___24484;
var G__24487 = cljs.core.count.call(null,c__19005__auto___24484);
var G__24488 = (0);
seq__24469_24473 = G__24485;
chunk__24470_24474 = G__24486;
count__24471_24475 = G__24487;
i__24472_24476 = G__24488;
continue;
} else {
var f_24489 = cljs.core.first.call(null,seq__24469_24483__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_24489);

var G__24490 = cljs.core.next.call(null,seq__24469_24483__$1);
var G__24491 = null;
var G__24492 = (0);
var G__24493 = (0);
seq__24469_24473 = G__24490;
chunk__24470_24474 = G__24491;
count__24471_24475 = G__24492;
i__24472_24476 = G__24493;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__24467,map__24467__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__24467,map__24467__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map