// Compiled by ClojureScript 1.7.228 {}
goog.provide('gadjett.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('gadjett.collections');
if(typeof gadjett.core.history !== 'undefined'){
} else {
gadjett.core.history = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof gadjett.core.settings !== 'undefined'){
} else {
gadjett.core.settings = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"max-function-calls","max-function-calls",-350003092),(50),new cljs.core.Keyword(null,"max-function-calls-with-args","max-function-calls-with-args",-2013983876),(10),new cljs.core.Keyword(null,"timeslot-function-calls-msec","timeslot-function-calls-msec",189712759),(1000),new cljs.core.Keyword(null,"compact-max-elements-in-seq","compact-max-elements-in-seq",418251211),(5),new cljs.core.Keyword(null,"compact-max-chars-in-str","compact-max-chars-in-str",240586724),(10)], null);
}
gadjett.core.settings_BANG_ = (function gadjett$core$settings_BANG_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___21840 = arguments.length;
var i__19261__auto___21841 = (0);
while(true){
if((i__19261__auto___21841 < len__19260__auto___21840)){
args__19267__auto__.push((arguments[i__19261__auto___21841]));

var G__21842 = (i__19261__auto___21841 + (1));
i__19261__auto___21841 = G__21842;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return gadjett.core.settings_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

gadjett.core.settings_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__21837){
var map__21838 = p__21837;
var map__21838__$1 = ((((!((map__21838 == null)))?((((map__21838.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21838.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21838):map__21838);
var args = map__21838__$1;
return gadjett.core.settings = cljs.core.merge.call(null,gadjett.core.settings,args);
});

gadjett.core.settings_BANG_.cljs$lang$maxFixedArity = (0);

gadjett.core.settings_BANG_.cljs$lang$applyTo = (function (seq21836){
return gadjett.core.settings_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21836));
});
if(typeof gadjett.core.chan_type !== 'undefined'){
} else {
gadjett.core.chan_type = cljs.core.type.call(null,cljs.core.async.chan.call(null));
}
gadjett.core.compact = (function gadjett$core$compact(var_args){
var args__19267__auto__ = [];
var len__19260__auto___21850 = arguments.length;
var i__19261__auto___21851 = (0);
while(true){
if((i__19261__auto___21851 < len__19260__auto___21850)){
args__19267__auto__.push((arguments[i__19261__auto___21851]));

var G__21852 = (i__19261__auto___21851 + (1));
i__19261__auto___21851 = G__21852;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((1) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((1)),(0))):null);
return gadjett.core.compact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19268__auto__);
});

gadjett.core.compact.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__21847){
var map__21848 = p__21847;
var map__21848__$1 = ((((!((map__21848 == null)))?((((map__21848.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21848.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21848):map__21848);
var args = map__21848__$1;
var max_elements_in_seq = cljs.core.get.call(null,map__21848__$1,new cljs.core.Keyword(null,"max-elements-in-seq","max-elements-in-seq",1093177159),new cljs.core.Keyword(null,"compact-max-elements-in-seq","compact-max-elements-in-seq",418251211).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings));
var max_chars_in_str = cljs.core.get.call(null,map__21848__$1,new cljs.core.Keyword(null,"max-chars-in-str","max-chars-in-str",-182482200),new cljs.core.Keyword(null,"compact-max-chars-in-str","compact-max-chars-in-str",240586724).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings));
if(cljs.core._EQ_.call(null,x,true)){
return x;
} else {
if(cljs.core._EQ_.call(null,x,false)){
return x;
} else {
if((x == null)){
return x;
} else {
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.subs.call(null,x,(0),max_chars_in_str);
} else {
if(cljs.core.map_QMARK_.call(null,x)){
return gadjett.collections.take_from_map.call(null,max_elements_in_seq,gadjett.collections.map_object.call(null,((function (map__21848,map__21848__$1,args,max_elements_in_seq,max_chars_in_str){
return (function (p1__21843_SHARP_){
return gadjett.core.compact.call(null,p1__21843_SHARP_,args);
});})(map__21848,map__21848__$1,args,max_elements_in_seq,max_chars_in_str))
,x));
} else {
if(cljs.core.seqable_QMARK_.call(null,x)){
return cljs.core.take.call(null,max_elements_in_seq,cljs.core.map.call(null,((function (map__21848,map__21848__$1,args,max_elements_in_seq,max_chars_in_str){
return (function (p1__21844_SHARP_){
return gadjett.core.compact.call(null,p1__21844_SHARP_,args);
});})(map__21848,map__21848__$1,args,max_elements_in_seq,max_chars_in_str))
,x));
} else {
if(cljs.core.array_QMARK_.call(null,x)){
return [cljs.core.str("***["),cljs.core.str(cljs.core.type.call(null,x)),cljs.core.str("]***")].join('');
} else {
if(cljs.core._EQ_.call(null,gadjett.core.chan_type,cljs.core.type.call(null,x))){
return "channel";
} else {
if(cljs.core._EQ_.call(null,Function,cljs.core.type.call(null,x))){
return "lambda()";
} else {
if((x instanceof Object)){
return [cljs.core.str("***["),cljs.core.str(cljs.core.type.call(null,x)),cljs.core.str("]***")].join('');
} else {
return [cljs.core.str("***["),cljs.core.str(cljs.core.type.call(null,x)),cljs.core.str("]***")].join('');

}
}
}
}
}
}
}
}
}
}
}
}
});

gadjett.core.compact.cljs$lang$maxFixedArity = (1);

gadjett.core.compact.cljs$lang$applyTo = (function (seq21845){
var G__21846 = cljs.core.first.call(null,seq21845);
var seq21845__$1 = cljs.core.next.call(null,seq21845);
return gadjett.core.compact.cljs$core$IFn$_invoke$arity$variadic(G__21846,seq21845__$1);
});
gadjett.core.add_event_and_filter = (function gadjett$core$add_event_and_filter(timestamp_msec,events){
var timeslot = new cljs.core.Keyword(null,"timeslot-function-calls-msec","timeslot-function-calls-msec",189712759).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings);
return cljs.core.cons.call(null,timestamp_msec,cljs.core.take_while.call(null,((function (timeslot){
return (function (p1__21853_SHARP_){
return (p1__21853_SHARP_ > (timestamp_msec - timeslot));
});})(timeslot))
,events));
});
gadjett.core.add_event = (function gadjett$core$add_event(history,func_name,timestamp_msec){
return cljs.core.update.call(null,history,func_name,cljs.core.partial.call(null,gadjett.core.add_event_and_filter,timestamp_msec));
});
gadjett.core.func_and_args = (function gadjett$core$func_and_args(func_name,args){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [func_name,gadjett.core.compact.call(null,args)], null);
});
gadjett.core.record_function_call = (function gadjett$core$record_function_call(func_name,args){
var func_and_args = gadjett.core.func_and_args.call(null,func_name,args);
cljs.core.swap_BANG_.call(null,gadjett.core.history,gadjett.core.add_event,func_name,(new Date()).valueOf());

cljs.core.swap_BANG_.call(null,gadjett.core.history,gadjett.core.add_event,func_and_args,(new Date()).valueOf());

return ((cljs.core.count.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),func_name)) <= new cljs.core.Keyword(null,"max-function-calls","max-function-calls",-350003092).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings))) && ((cljs.core.count.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),func_and_args)) <= new cljs.core.Keyword(null,"max-function-calls-with-args","max-function-calls-with-args",-2013983876).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings)));
});
/**
 * returns the history sorted by number of function calls
 */
gadjett.core.sort_history = (function gadjett$core$sort_history(hist){
return cljs.core.reverse.call(null,cljs.core.sort_by.call(null,cljs.core.comp.call(null,cljs.core.count,cljs.core.second),hist));
});
/**
 * returns the history as an array, sorted by number of function calls
 */
gadjett.core.the_history = (function gadjett$core$the_history(var_args){
var args21854 = [];
var len__19260__auto___21857 = arguments.length;
var i__19261__auto___21858 = (0);
while(true){
if((i__19261__auto___21858 < len__19260__auto___21857)){
args21854.push((arguments[i__19261__auto___21858]));

var G__21859 = (i__19261__auto___21858 + (1));
i__19261__auto___21858 = G__21859;
continue;
} else {
}
break;
}

var G__21856 = args21854.length;
switch (G__21856) {
case 1:
return gadjett.core.the_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return gadjett.core.the_history.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21854.length)].join('')));

}
});

gadjett.core.the_history.cljs$core$IFn$_invoke$arity$1 = (function (k){
return cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),k);
});

gadjett.core.the_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return gadjett.core.sort_history.call(null,cljs.core.deref.call(null,gadjett.core.history));
});

gadjett.core.the_history.cljs$lang$maxFixedArity = 1;
/**
 * returns a string with the key and the number of function calls that exceeded the max.
 */
gadjett.core.str_history_key = (function gadjett$core$str_history_key(func_name,args){
if((cljs.core.count.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),gadjett.core.func_and_args.call(null,func_name,args))) > new cljs.core.Keyword(null,"max-function-calls-with-args","max-function-calls-with-args",-2013983876).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings))){
return [cljs.core.str(new cljs.core.Keyword(null,"max-function-calls-with-args","max-function-calls-with-args",-2013983876).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings)),cljs.core.str(" times with this arguments: "),cljs.core.str(gadjett.core.compact.call(null,args)),cljs.core.str(".")].join('');
} else {
if((cljs.core.count.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),func_name)) > new cljs.core.Keyword(null,"max-function-calls","max-function-calls",-350003092).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings))){
return [cljs.core.str(new cljs.core.Keyword(null,"max-function-calls","max-function-calls",-350003092).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings)),cljs.core.str(" times with different arguments.")].join('');
} else {
return "no idea why we got there; probably a bug => write to viebel@gmail.com";

}
}
});
gadjett.core.function_call_err_msg = (function gadjett$core$function_call_err_msg(func_name,args){
return [cljs.core.str(func_name),cljs.core.str(" was called too much over the last "),cljs.core.str(new cljs.core.Keyword(null,"timeslot-function-calls-msec","timeslot-function-calls-msec",189712759).cljs$core$IFn$_invoke$arity$1(gadjett.core.settings)),cljs.core.str(" msec: "),cljs.core.str(gadjett.core.str_history_key.call(null,func_name,args))].join('');
});

//# sourceMappingURL=core.js.map