// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__28609){
var vec__28610 = p__28609;
var i = cljs.core.nth.call(null,vec__28610,(0),null);
var v = cljs.core.nth.call(null,vec__28610,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__28612 = seg;
var gcol = cljs.core.nth.call(null,vec__28612,(0),null);
var source = cljs.core.nth.call(null,vec__28612,(1),null);
var line = cljs.core.nth.call(null,vec__28612,(2),null);
var col = cljs.core.nth.call(null,vec__28612,(3),null);
var name = cljs.core.nth.call(null,vec__28612,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__4425__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__4425__auto__)){
var name__$1 = temp__4425__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__28615 = seg;
var gcol = cljs.core.nth.call(null,vec__28615,(0),null);
var source = cljs.core.nth.call(null,vec__28615,(1),null);
var line = cljs.core.nth.call(null,vec__28615,(2),null);
var col = cljs.core.nth.call(null,vec__28615,(3),null);
var name = cljs.core.nth.call(null,vec__28615,(4),null);
var vec__28616 = relseg;
var rgcol = cljs.core.nth.call(null,vec__28616,(0),null);
var rsource = cljs.core.nth.call(null,vec__28616,(1),null);
var rline = cljs.core.nth.call(null,vec__28616,(2),null);
var rcol = cljs.core.nth.call(null,vec__28616,(3),null);
var rname = cljs.core.nth.call(null,vec__28616,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__18275__auto__ = source;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__18275__auto__ = line;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__18275__auto__ = col;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__18275__auto__ = name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__28619 = segmap;
var map__28619__$1 = ((((!((map__28619 == null)))?((((map__28619.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28619.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28619):map__28619);
var gcol = cljs.core.get.call(null,map__28619__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__28619__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__28619__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__28619__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__28619__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,((function (map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,((function (map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,((function (map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.call(null,v,d__$1);
});})(map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});})(map__28619,map__28619__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var args28621 = [];
var len__19333__auto___28625 = arguments.length;
var i__19334__auto___28626 = (0);
while(true){
if((i__19334__auto___28626 < len__19333__auto___28625)){
args28621.push((arguments[i__19334__auto___28626]));

var G__28627 = (i__19334__auto___28626 + (1));
i__19334__auto___28626 = G__28627;
continue;
} else {
}
break;
}

var G__28623 = args28621.length;
switch (G__28623) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28621.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__28624 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__28629 = cljs.core.next.call(null,segs__$1);
var G__28630 = nrelseg;
var G__28631 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__28629;
relseg__$1 = G__28630;
result__$1 = G__28631;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__28624,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__28624,(1),null);
var G__28632 = (gline + (1));
var G__28633 = cljs.core.next.call(null,lines__$1);
var G__28634 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__28635 = result__$1;
gline = G__28632;
lines__$1 = G__28633;
relseg = G__28634;
result = G__28635;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;
/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__28639 = segmap;
var map__28639__$1 = ((((!((map__28639 == null)))?((((map__28639.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28639.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28639):map__28639);
var gcol = cljs.core.get.call(null,map__28639__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__28639__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__28639__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__28639__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__28639__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,((function (map__28639,map__28639__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,((function (map__28639,map__28639__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__28636_SHARP_){
return cljs.core.conj.call(null,p1__28636_SHARP_,d__$1);
});})(map__28639,map__28639__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__28639,map__28639__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var args28641 = [];
var len__19333__auto___28645 = arguments.length;
var i__19334__auto___28646 = (0);
while(true){
if((i__19334__auto___28646 < len__19333__auto___28645)){
args28641.push((arguments[i__19334__auto___28646]));

var G__28647 = (i__19334__auto___28646 + (1));
i__19334__auto___28646 = G__28647;
continue;
} else {
}
break;
}

var G__28643 = args28641.length;
switch (G__28643) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28641.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__28644 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__28649 = cljs.core.next.call(null,segs__$1);
var G__28650 = nrelseg;
var G__28651 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__28649;
relseg__$1 = G__28650;
result__$1 = G__28651;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__28644,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__28644,(1),null);
var G__28652 = (gline + (1));
var G__28653 = cljs.core.next.call(null,lines__$1);
var G__28654 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__28655 = result__$1;
gline = G__28652;
lines__$1 = G__28653;
relseg = G__28654;
result = G__28655;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;
/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,((function (relseg){
return (function (p__28662){
var vec__28663 = p__28662;
var _ = cljs.core.nth.call(null,vec__28663,(0),null);
var source = cljs.core.nth.call(null,vec__28663,(1),null);
var line = cljs.core.nth.call(null,vec__28663,(2),null);
var col = cljs.core.nth.call(null,vec__28663,(3),null);
var name = cljs.core.nth.call(null,vec__28663,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,((function (relseg){
return (function (cols__$1,p__28664){
var vec__28665 = p__28664;
var gcol = cljs.core.nth.call(null,vec__28665,(0),null);
var sidx = cljs.core.nth.call(null,vec__28665,(1),null);
var line = cljs.core.nth.call(null,vec__28665,(2),null);
var col = cljs.core.nth.call(null,vec__28665,(3),null);
var name = cljs.core.nth.call(null,vec__28665,(4),null);
var seg = vec__28665;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,((function (offset,vec__28665,gcol,sidx,line,col,name,seg,relseg){
return (function (p__28666){
var vec__28667 = p__28666;
var _ = cljs.core.nth.call(null,vec__28667,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__28667,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__28667,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__28667,(3),null);
var lname = cljs.core.nth.call(null,vec__28667,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__18275__auto__ = name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__28665,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__18275__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__4423__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__4423__auto__)){
var name = temp__4423__auto__;
var idx = (function (){var temp__4423__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__4423__auto____$1)){
var idx = temp__4423__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__28721 = cljs.core.seq.call(null,infos);
var chunk__28722 = null;
var count__28723 = (0);
var i__28724 = (0);
while(true){
if((i__28724 < count__28723)){
var info = cljs.core._nth.call(null,chunk__28722,i__28724);
var segv_28771 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_28772 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_28773 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_28772 > (lc_28773 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__28721,chunk__28722,count__28723,i__28724,segv_28771,gline_28772,lc_28773,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_28772 - (lc_28773 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_28771], null));
});})(seq__28721,chunk__28722,count__28723,i__28724,segv_28771,gline_28772,lc_28773,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__28721,chunk__28722,count__28723,i__28724,segv_28771,gline_28772,lc_28773,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_28772], null),cljs.core.conj,segv_28771);
});})(seq__28721,chunk__28722,count__28723,i__28724,segv_28771,gline_28772,lc_28773,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__28774 = seq__28721;
var G__28775 = chunk__28722;
var G__28776 = count__28723;
var G__28777 = (i__28724 + (1));
seq__28721 = G__28774;
chunk__28722 = G__28775;
count__28723 = G__28776;
i__28724 = G__28777;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__28721);
if(temp__4425__auto__){
var seq__28721__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28721__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__28721__$1);
var G__28778 = cljs.core.chunk_rest.call(null,seq__28721__$1);
var G__28779 = c__19078__auto__;
var G__28780 = cljs.core.count.call(null,c__19078__auto__);
var G__28781 = (0);
seq__28721 = G__28778;
chunk__28722 = G__28779;
count__28723 = G__28780;
i__28724 = G__28781;
continue;
} else {
var info = cljs.core.first.call(null,seq__28721__$1);
var segv_28782 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_28783 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_28784 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_28783 > (lc_28784 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__28721,chunk__28722,count__28723,i__28724,segv_28782,gline_28783,lc_28784,info,seq__28721__$1,temp__4425__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_28783 - (lc_28784 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_28782], null));
});})(seq__28721,chunk__28722,count__28723,i__28724,segv_28782,gline_28783,lc_28784,info,seq__28721__$1,temp__4425__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__28721,chunk__28722,count__28723,i__28724,segv_28782,gline_28783,lc_28784,info,seq__28721__$1,temp__4425__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_28783], null),cljs.core.conj,segv_28782);
});})(seq__28721,chunk__28722,count__28723,i__28724,segv_28782,gline_28783,lc_28784,info,seq__28721__$1,temp__4425__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__28785 = cljs.core.next.call(null,seq__28721__$1);
var G__28786 = null;
var G__28787 = (0);
var G__28788 = (0);
seq__28721 = G__28785;
chunk__28722 = G__28786;
count__28723 = G__28787;
i__28724 = G__28788;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__28725_28789 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__28726_28790 = null;
var count__28727_28791 = (0);
var i__28728_28792 = (0);
while(true){
if((i__28728_28792 < count__28727_28791)){
var vec__28729_28793 = cljs.core._nth.call(null,chunk__28726_28790,i__28728_28792);
var source_idx_28794 = cljs.core.nth.call(null,vec__28729_28793,(0),null);
var vec__28730_28795 = cljs.core.nth.call(null,vec__28729_28793,(1),null);
var __28796 = cljs.core.nth.call(null,vec__28730_28795,(0),null);
var lines_28797__$1 = cljs.core.nth.call(null,vec__28730_28795,(1),null);
var seq__28731_28798 = cljs.core.seq.call(null,lines_28797__$1);
var chunk__28732_28799 = null;
var count__28733_28800 = (0);
var i__28734_28801 = (0);
while(true){
if((i__28734_28801 < count__28733_28800)){
var vec__28735_28802 = cljs.core._nth.call(null,chunk__28732_28799,i__28734_28801);
var line_28803 = cljs.core.nth.call(null,vec__28735_28802,(0),null);
var cols_28804 = cljs.core.nth.call(null,vec__28735_28802,(1),null);
var seq__28736_28805 = cljs.core.seq.call(null,cols_28804);
var chunk__28737_28806 = null;
var count__28738_28807 = (0);
var i__28739_28808 = (0);
while(true){
if((i__28739_28808 < count__28738_28807)){
var vec__28740_28809 = cljs.core._nth.call(null,chunk__28737_28806,i__28739_28808);
var col_28810 = cljs.core.nth.call(null,vec__28740_28809,(0),null);
var infos_28811 = cljs.core.nth.call(null,vec__28740_28809,(1),null);
encode_cols.call(null,infos_28811,source_idx_28794,line_28803,col_28810);

var G__28812 = seq__28736_28805;
var G__28813 = chunk__28737_28806;
var G__28814 = count__28738_28807;
var G__28815 = (i__28739_28808 + (1));
seq__28736_28805 = G__28812;
chunk__28737_28806 = G__28813;
count__28738_28807 = G__28814;
i__28739_28808 = G__28815;
continue;
} else {
var temp__4425__auto___28816 = cljs.core.seq.call(null,seq__28736_28805);
if(temp__4425__auto___28816){
var seq__28736_28817__$1 = temp__4425__auto___28816;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28736_28817__$1)){
var c__19078__auto___28818 = cljs.core.chunk_first.call(null,seq__28736_28817__$1);
var G__28819 = cljs.core.chunk_rest.call(null,seq__28736_28817__$1);
var G__28820 = c__19078__auto___28818;
var G__28821 = cljs.core.count.call(null,c__19078__auto___28818);
var G__28822 = (0);
seq__28736_28805 = G__28819;
chunk__28737_28806 = G__28820;
count__28738_28807 = G__28821;
i__28739_28808 = G__28822;
continue;
} else {
var vec__28741_28823 = cljs.core.first.call(null,seq__28736_28817__$1);
var col_28824 = cljs.core.nth.call(null,vec__28741_28823,(0),null);
var infos_28825 = cljs.core.nth.call(null,vec__28741_28823,(1),null);
encode_cols.call(null,infos_28825,source_idx_28794,line_28803,col_28824);

var G__28826 = cljs.core.next.call(null,seq__28736_28817__$1);
var G__28827 = null;
var G__28828 = (0);
var G__28829 = (0);
seq__28736_28805 = G__28826;
chunk__28737_28806 = G__28827;
count__28738_28807 = G__28828;
i__28739_28808 = G__28829;
continue;
}
} else {
}
}
break;
}

var G__28830 = seq__28731_28798;
var G__28831 = chunk__28732_28799;
var G__28832 = count__28733_28800;
var G__28833 = (i__28734_28801 + (1));
seq__28731_28798 = G__28830;
chunk__28732_28799 = G__28831;
count__28733_28800 = G__28832;
i__28734_28801 = G__28833;
continue;
} else {
var temp__4425__auto___28834 = cljs.core.seq.call(null,seq__28731_28798);
if(temp__4425__auto___28834){
var seq__28731_28835__$1 = temp__4425__auto___28834;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28731_28835__$1)){
var c__19078__auto___28836 = cljs.core.chunk_first.call(null,seq__28731_28835__$1);
var G__28837 = cljs.core.chunk_rest.call(null,seq__28731_28835__$1);
var G__28838 = c__19078__auto___28836;
var G__28839 = cljs.core.count.call(null,c__19078__auto___28836);
var G__28840 = (0);
seq__28731_28798 = G__28837;
chunk__28732_28799 = G__28838;
count__28733_28800 = G__28839;
i__28734_28801 = G__28840;
continue;
} else {
var vec__28742_28841 = cljs.core.first.call(null,seq__28731_28835__$1);
var line_28842 = cljs.core.nth.call(null,vec__28742_28841,(0),null);
var cols_28843 = cljs.core.nth.call(null,vec__28742_28841,(1),null);
var seq__28743_28844 = cljs.core.seq.call(null,cols_28843);
var chunk__28744_28845 = null;
var count__28745_28846 = (0);
var i__28746_28847 = (0);
while(true){
if((i__28746_28847 < count__28745_28846)){
var vec__28747_28848 = cljs.core._nth.call(null,chunk__28744_28845,i__28746_28847);
var col_28849 = cljs.core.nth.call(null,vec__28747_28848,(0),null);
var infos_28850 = cljs.core.nth.call(null,vec__28747_28848,(1),null);
encode_cols.call(null,infos_28850,source_idx_28794,line_28842,col_28849);

var G__28851 = seq__28743_28844;
var G__28852 = chunk__28744_28845;
var G__28853 = count__28745_28846;
var G__28854 = (i__28746_28847 + (1));
seq__28743_28844 = G__28851;
chunk__28744_28845 = G__28852;
count__28745_28846 = G__28853;
i__28746_28847 = G__28854;
continue;
} else {
var temp__4425__auto___28855__$1 = cljs.core.seq.call(null,seq__28743_28844);
if(temp__4425__auto___28855__$1){
var seq__28743_28856__$1 = temp__4425__auto___28855__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28743_28856__$1)){
var c__19078__auto___28857 = cljs.core.chunk_first.call(null,seq__28743_28856__$1);
var G__28858 = cljs.core.chunk_rest.call(null,seq__28743_28856__$1);
var G__28859 = c__19078__auto___28857;
var G__28860 = cljs.core.count.call(null,c__19078__auto___28857);
var G__28861 = (0);
seq__28743_28844 = G__28858;
chunk__28744_28845 = G__28859;
count__28745_28846 = G__28860;
i__28746_28847 = G__28861;
continue;
} else {
var vec__28748_28862 = cljs.core.first.call(null,seq__28743_28856__$1);
var col_28863 = cljs.core.nth.call(null,vec__28748_28862,(0),null);
var infos_28864 = cljs.core.nth.call(null,vec__28748_28862,(1),null);
encode_cols.call(null,infos_28864,source_idx_28794,line_28842,col_28863);

var G__28865 = cljs.core.next.call(null,seq__28743_28856__$1);
var G__28866 = null;
var G__28867 = (0);
var G__28868 = (0);
seq__28743_28844 = G__28865;
chunk__28744_28845 = G__28866;
count__28745_28846 = G__28867;
i__28746_28847 = G__28868;
continue;
}
} else {
}
}
break;
}

var G__28869 = cljs.core.next.call(null,seq__28731_28835__$1);
var G__28870 = null;
var G__28871 = (0);
var G__28872 = (0);
seq__28731_28798 = G__28869;
chunk__28732_28799 = G__28870;
count__28733_28800 = G__28871;
i__28734_28801 = G__28872;
continue;
}
} else {
}
}
break;
}

var G__28873 = seq__28725_28789;
var G__28874 = chunk__28726_28790;
var G__28875 = count__28727_28791;
var G__28876 = (i__28728_28792 + (1));
seq__28725_28789 = G__28873;
chunk__28726_28790 = G__28874;
count__28727_28791 = G__28875;
i__28728_28792 = G__28876;
continue;
} else {
var temp__4425__auto___28877 = cljs.core.seq.call(null,seq__28725_28789);
if(temp__4425__auto___28877){
var seq__28725_28878__$1 = temp__4425__auto___28877;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28725_28878__$1)){
var c__19078__auto___28879 = cljs.core.chunk_first.call(null,seq__28725_28878__$1);
var G__28880 = cljs.core.chunk_rest.call(null,seq__28725_28878__$1);
var G__28881 = c__19078__auto___28879;
var G__28882 = cljs.core.count.call(null,c__19078__auto___28879);
var G__28883 = (0);
seq__28725_28789 = G__28880;
chunk__28726_28790 = G__28881;
count__28727_28791 = G__28882;
i__28728_28792 = G__28883;
continue;
} else {
var vec__28749_28884 = cljs.core.first.call(null,seq__28725_28878__$1);
var source_idx_28885 = cljs.core.nth.call(null,vec__28749_28884,(0),null);
var vec__28750_28886 = cljs.core.nth.call(null,vec__28749_28884,(1),null);
var __28887 = cljs.core.nth.call(null,vec__28750_28886,(0),null);
var lines_28888__$1 = cljs.core.nth.call(null,vec__28750_28886,(1),null);
var seq__28751_28889 = cljs.core.seq.call(null,lines_28888__$1);
var chunk__28752_28890 = null;
var count__28753_28891 = (0);
var i__28754_28892 = (0);
while(true){
if((i__28754_28892 < count__28753_28891)){
var vec__28755_28893 = cljs.core._nth.call(null,chunk__28752_28890,i__28754_28892);
var line_28894 = cljs.core.nth.call(null,vec__28755_28893,(0),null);
var cols_28895 = cljs.core.nth.call(null,vec__28755_28893,(1),null);
var seq__28756_28896 = cljs.core.seq.call(null,cols_28895);
var chunk__28757_28897 = null;
var count__28758_28898 = (0);
var i__28759_28899 = (0);
while(true){
if((i__28759_28899 < count__28758_28898)){
var vec__28760_28900 = cljs.core._nth.call(null,chunk__28757_28897,i__28759_28899);
var col_28901 = cljs.core.nth.call(null,vec__28760_28900,(0),null);
var infos_28902 = cljs.core.nth.call(null,vec__28760_28900,(1),null);
encode_cols.call(null,infos_28902,source_idx_28885,line_28894,col_28901);

var G__28903 = seq__28756_28896;
var G__28904 = chunk__28757_28897;
var G__28905 = count__28758_28898;
var G__28906 = (i__28759_28899 + (1));
seq__28756_28896 = G__28903;
chunk__28757_28897 = G__28904;
count__28758_28898 = G__28905;
i__28759_28899 = G__28906;
continue;
} else {
var temp__4425__auto___28907__$1 = cljs.core.seq.call(null,seq__28756_28896);
if(temp__4425__auto___28907__$1){
var seq__28756_28908__$1 = temp__4425__auto___28907__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28756_28908__$1)){
var c__19078__auto___28909 = cljs.core.chunk_first.call(null,seq__28756_28908__$1);
var G__28910 = cljs.core.chunk_rest.call(null,seq__28756_28908__$1);
var G__28911 = c__19078__auto___28909;
var G__28912 = cljs.core.count.call(null,c__19078__auto___28909);
var G__28913 = (0);
seq__28756_28896 = G__28910;
chunk__28757_28897 = G__28911;
count__28758_28898 = G__28912;
i__28759_28899 = G__28913;
continue;
} else {
var vec__28761_28914 = cljs.core.first.call(null,seq__28756_28908__$1);
var col_28915 = cljs.core.nth.call(null,vec__28761_28914,(0),null);
var infos_28916 = cljs.core.nth.call(null,vec__28761_28914,(1),null);
encode_cols.call(null,infos_28916,source_idx_28885,line_28894,col_28915);

var G__28917 = cljs.core.next.call(null,seq__28756_28908__$1);
var G__28918 = null;
var G__28919 = (0);
var G__28920 = (0);
seq__28756_28896 = G__28917;
chunk__28757_28897 = G__28918;
count__28758_28898 = G__28919;
i__28759_28899 = G__28920;
continue;
}
} else {
}
}
break;
}

var G__28921 = seq__28751_28889;
var G__28922 = chunk__28752_28890;
var G__28923 = count__28753_28891;
var G__28924 = (i__28754_28892 + (1));
seq__28751_28889 = G__28921;
chunk__28752_28890 = G__28922;
count__28753_28891 = G__28923;
i__28754_28892 = G__28924;
continue;
} else {
var temp__4425__auto___28925__$1 = cljs.core.seq.call(null,seq__28751_28889);
if(temp__4425__auto___28925__$1){
var seq__28751_28926__$1 = temp__4425__auto___28925__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28751_28926__$1)){
var c__19078__auto___28927 = cljs.core.chunk_first.call(null,seq__28751_28926__$1);
var G__28928 = cljs.core.chunk_rest.call(null,seq__28751_28926__$1);
var G__28929 = c__19078__auto___28927;
var G__28930 = cljs.core.count.call(null,c__19078__auto___28927);
var G__28931 = (0);
seq__28751_28889 = G__28928;
chunk__28752_28890 = G__28929;
count__28753_28891 = G__28930;
i__28754_28892 = G__28931;
continue;
} else {
var vec__28762_28932 = cljs.core.first.call(null,seq__28751_28926__$1);
var line_28933 = cljs.core.nth.call(null,vec__28762_28932,(0),null);
var cols_28934 = cljs.core.nth.call(null,vec__28762_28932,(1),null);
var seq__28763_28935 = cljs.core.seq.call(null,cols_28934);
var chunk__28764_28936 = null;
var count__28765_28937 = (0);
var i__28766_28938 = (0);
while(true){
if((i__28766_28938 < count__28765_28937)){
var vec__28767_28939 = cljs.core._nth.call(null,chunk__28764_28936,i__28766_28938);
var col_28940 = cljs.core.nth.call(null,vec__28767_28939,(0),null);
var infos_28941 = cljs.core.nth.call(null,vec__28767_28939,(1),null);
encode_cols.call(null,infos_28941,source_idx_28885,line_28933,col_28940);

var G__28942 = seq__28763_28935;
var G__28943 = chunk__28764_28936;
var G__28944 = count__28765_28937;
var G__28945 = (i__28766_28938 + (1));
seq__28763_28935 = G__28942;
chunk__28764_28936 = G__28943;
count__28765_28937 = G__28944;
i__28766_28938 = G__28945;
continue;
} else {
var temp__4425__auto___28946__$2 = cljs.core.seq.call(null,seq__28763_28935);
if(temp__4425__auto___28946__$2){
var seq__28763_28947__$1 = temp__4425__auto___28946__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28763_28947__$1)){
var c__19078__auto___28948 = cljs.core.chunk_first.call(null,seq__28763_28947__$1);
var G__28949 = cljs.core.chunk_rest.call(null,seq__28763_28947__$1);
var G__28950 = c__19078__auto___28948;
var G__28951 = cljs.core.count.call(null,c__19078__auto___28948);
var G__28952 = (0);
seq__28763_28935 = G__28949;
chunk__28764_28936 = G__28950;
count__28765_28937 = G__28951;
i__28766_28938 = G__28952;
continue;
} else {
var vec__28768_28953 = cljs.core.first.call(null,seq__28763_28947__$1);
var col_28954 = cljs.core.nth.call(null,vec__28768_28953,(0),null);
var infos_28955 = cljs.core.nth.call(null,vec__28768_28953,(1),null);
encode_cols.call(null,infos_28955,source_idx_28885,line_28933,col_28954);

var G__28956 = cljs.core.next.call(null,seq__28763_28947__$1);
var G__28957 = null;
var G__28958 = (0);
var G__28959 = (0);
seq__28763_28935 = G__28956;
chunk__28764_28936 = G__28957;
count__28765_28937 = G__28958;
i__28766_28938 = G__28959;
continue;
}
} else {
}
}
break;
}

var G__28960 = cljs.core.next.call(null,seq__28751_28926__$1);
var G__28961 = null;
var G__28962 = (0);
var G__28963 = (0);
seq__28751_28889 = G__28960;
chunk__28752_28890 = G__28961;
count__28753_28891 = G__28962;
i__28754_28892 = G__28963;
continue;
}
} else {
}
}
break;
}

var G__28964 = cljs.core.next.call(null,seq__28725_28878__$1);
var G__28965 = null;
var G__28966 = (0);
var G__28967 = (0);
seq__28725_28789 = G__28964;
chunk__28726_28790 = G__28965;
count__28727_28791 = G__28966;
i__28728_28792 = G__28967;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__28769 = {"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__28668_SHARP_){
return [cljs.core.str(p1__28668_SHARP_),cljs.core.str("?rel="),cljs.core.str((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__28669_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__28669_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__28670_SHARP_){
return clojure.string.join.call(null,",",p1__28670_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))};
var G__28769__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))?(function (){var G__28770 = G__28769;
goog.object.set(G__28770,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__28770;
})():G__28769);
return G__28769__$1;
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__28973 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__28973,(0),null);
var col_map = cljs.core.nth.call(null,vec__28973,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__28974 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__28974,(0),null);
var infos = cljs.core.nth.call(null,vec__28974,(1),null);
var G__28978 = cljs.core.next.call(null,col_map_seq);
var G__28979 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__28974,col,infos,vec__28973,line,col_map){
return (function (v,p__28975){
var map__28976 = p__28975;
var map__28976__$1 = ((((!((map__28976 == null)))?((((map__28976.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28976.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28976):map__28976);
var gline = cljs.core.get.call(null,map__28976__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__28976__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__28974,col,infos,vec__28973,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__28978;
new_cols = G__28979;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__28980 = cljs.core.next.call(null,line_map_seq);
var G__28981 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__28980;
new_lines = G__28981;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__29032_29082 = cljs.core.seq.call(null,reverse_map);
var chunk__29033_29083 = null;
var count__29034_29084 = (0);
var i__29035_29085 = (0);
while(true){
if((i__29035_29085 < count__29034_29084)){
var vec__29036_29086 = cljs.core._nth.call(null,chunk__29033_29083,i__29035_29085);
var line_29087 = cljs.core.nth.call(null,vec__29036_29086,(0),null);
var columns_29088 = cljs.core.nth.call(null,vec__29036_29086,(1),null);
var seq__29037_29089 = cljs.core.seq.call(null,columns_29088);
var chunk__29038_29090 = null;
var count__29039_29091 = (0);
var i__29040_29092 = (0);
while(true){
if((i__29040_29092 < count__29039_29091)){
var vec__29041_29093 = cljs.core._nth.call(null,chunk__29038_29090,i__29040_29092);
var column_29094 = cljs.core.nth.call(null,vec__29041_29093,(0),null);
var column_info_29095 = cljs.core.nth.call(null,vec__29041_29093,(1),null);
var seq__29042_29096 = cljs.core.seq.call(null,column_info_29095);
var chunk__29043_29097 = null;
var count__29044_29098 = (0);
var i__29045_29099 = (0);
while(true){
if((i__29045_29099 < count__29044_29098)){
var map__29046_29100 = cljs.core._nth.call(null,chunk__29043_29097,i__29045_29099);
var map__29046_29101__$1 = ((((!((map__29046_29100 == null)))?((((map__29046_29100.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29046_29100.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29046_29100):map__29046_29100);
var gline_29102 = cljs.core.get.call(null,map__29046_29101__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29103 = cljs.core.get.call(null,map__29046_29101__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29104 = cljs.core.get.call(null,map__29046_29101__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29102], null),cljs.core.fnil.call(null,((function (seq__29042_29096,chunk__29043_29097,count__29044_29098,i__29045_29099,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29046_29100,map__29046_29101__$1,gline_29102,gcol_29103,name_29104,vec__29041_29093,column_29094,column_info_29095,vec__29036_29086,line_29087,columns_29088,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29094], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29087,new cljs.core.Keyword(null,"col","col",-1959363084),column_29094,new cljs.core.Keyword(null,"name","name",1843675177),name_29104], null));
});})(seq__29042_29096,chunk__29043_29097,count__29044_29098,i__29045_29099,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29046_29100,map__29046_29101__$1,gline_29102,gcol_29103,name_29104,vec__29041_29093,column_29094,column_info_29095,vec__29036_29086,line_29087,columns_29088,inverted))
,cljs.core.sorted_map.call(null)));

var G__29105 = seq__29042_29096;
var G__29106 = chunk__29043_29097;
var G__29107 = count__29044_29098;
var G__29108 = (i__29045_29099 + (1));
seq__29042_29096 = G__29105;
chunk__29043_29097 = G__29106;
count__29044_29098 = G__29107;
i__29045_29099 = G__29108;
continue;
} else {
var temp__4425__auto___29109 = cljs.core.seq.call(null,seq__29042_29096);
if(temp__4425__auto___29109){
var seq__29042_29110__$1 = temp__4425__auto___29109;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29042_29110__$1)){
var c__19078__auto___29111 = cljs.core.chunk_first.call(null,seq__29042_29110__$1);
var G__29112 = cljs.core.chunk_rest.call(null,seq__29042_29110__$1);
var G__29113 = c__19078__auto___29111;
var G__29114 = cljs.core.count.call(null,c__19078__auto___29111);
var G__29115 = (0);
seq__29042_29096 = G__29112;
chunk__29043_29097 = G__29113;
count__29044_29098 = G__29114;
i__29045_29099 = G__29115;
continue;
} else {
var map__29048_29116 = cljs.core.first.call(null,seq__29042_29110__$1);
var map__29048_29117__$1 = ((((!((map__29048_29116 == null)))?((((map__29048_29116.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29048_29116.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29048_29116):map__29048_29116);
var gline_29118 = cljs.core.get.call(null,map__29048_29117__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29119 = cljs.core.get.call(null,map__29048_29117__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29120 = cljs.core.get.call(null,map__29048_29117__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29118], null),cljs.core.fnil.call(null,((function (seq__29042_29096,chunk__29043_29097,count__29044_29098,i__29045_29099,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29048_29116,map__29048_29117__$1,gline_29118,gcol_29119,name_29120,seq__29042_29110__$1,temp__4425__auto___29109,vec__29041_29093,column_29094,column_info_29095,vec__29036_29086,line_29087,columns_29088,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29094], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29087,new cljs.core.Keyword(null,"col","col",-1959363084),column_29094,new cljs.core.Keyword(null,"name","name",1843675177),name_29120], null));
});})(seq__29042_29096,chunk__29043_29097,count__29044_29098,i__29045_29099,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29048_29116,map__29048_29117__$1,gline_29118,gcol_29119,name_29120,seq__29042_29110__$1,temp__4425__auto___29109,vec__29041_29093,column_29094,column_info_29095,vec__29036_29086,line_29087,columns_29088,inverted))
,cljs.core.sorted_map.call(null)));

var G__29121 = cljs.core.next.call(null,seq__29042_29110__$1);
var G__29122 = null;
var G__29123 = (0);
var G__29124 = (0);
seq__29042_29096 = G__29121;
chunk__29043_29097 = G__29122;
count__29044_29098 = G__29123;
i__29045_29099 = G__29124;
continue;
}
} else {
}
}
break;
}

var G__29125 = seq__29037_29089;
var G__29126 = chunk__29038_29090;
var G__29127 = count__29039_29091;
var G__29128 = (i__29040_29092 + (1));
seq__29037_29089 = G__29125;
chunk__29038_29090 = G__29126;
count__29039_29091 = G__29127;
i__29040_29092 = G__29128;
continue;
} else {
var temp__4425__auto___29129 = cljs.core.seq.call(null,seq__29037_29089);
if(temp__4425__auto___29129){
var seq__29037_29130__$1 = temp__4425__auto___29129;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29037_29130__$1)){
var c__19078__auto___29131 = cljs.core.chunk_first.call(null,seq__29037_29130__$1);
var G__29132 = cljs.core.chunk_rest.call(null,seq__29037_29130__$1);
var G__29133 = c__19078__auto___29131;
var G__29134 = cljs.core.count.call(null,c__19078__auto___29131);
var G__29135 = (0);
seq__29037_29089 = G__29132;
chunk__29038_29090 = G__29133;
count__29039_29091 = G__29134;
i__29040_29092 = G__29135;
continue;
} else {
var vec__29050_29136 = cljs.core.first.call(null,seq__29037_29130__$1);
var column_29137 = cljs.core.nth.call(null,vec__29050_29136,(0),null);
var column_info_29138 = cljs.core.nth.call(null,vec__29050_29136,(1),null);
var seq__29051_29139 = cljs.core.seq.call(null,column_info_29138);
var chunk__29052_29140 = null;
var count__29053_29141 = (0);
var i__29054_29142 = (0);
while(true){
if((i__29054_29142 < count__29053_29141)){
var map__29055_29143 = cljs.core._nth.call(null,chunk__29052_29140,i__29054_29142);
var map__29055_29144__$1 = ((((!((map__29055_29143 == null)))?((((map__29055_29143.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29055_29143.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29055_29143):map__29055_29143);
var gline_29145 = cljs.core.get.call(null,map__29055_29144__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29146 = cljs.core.get.call(null,map__29055_29144__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29147 = cljs.core.get.call(null,map__29055_29144__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29145], null),cljs.core.fnil.call(null,((function (seq__29051_29139,chunk__29052_29140,count__29053_29141,i__29054_29142,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29055_29143,map__29055_29144__$1,gline_29145,gcol_29146,name_29147,vec__29050_29136,column_29137,column_info_29138,seq__29037_29130__$1,temp__4425__auto___29129,vec__29036_29086,line_29087,columns_29088,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29137], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29087,new cljs.core.Keyword(null,"col","col",-1959363084),column_29137,new cljs.core.Keyword(null,"name","name",1843675177),name_29147], null));
});})(seq__29051_29139,chunk__29052_29140,count__29053_29141,i__29054_29142,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29055_29143,map__29055_29144__$1,gline_29145,gcol_29146,name_29147,vec__29050_29136,column_29137,column_info_29138,seq__29037_29130__$1,temp__4425__auto___29129,vec__29036_29086,line_29087,columns_29088,inverted))
,cljs.core.sorted_map.call(null)));

var G__29148 = seq__29051_29139;
var G__29149 = chunk__29052_29140;
var G__29150 = count__29053_29141;
var G__29151 = (i__29054_29142 + (1));
seq__29051_29139 = G__29148;
chunk__29052_29140 = G__29149;
count__29053_29141 = G__29150;
i__29054_29142 = G__29151;
continue;
} else {
var temp__4425__auto___29152__$1 = cljs.core.seq.call(null,seq__29051_29139);
if(temp__4425__auto___29152__$1){
var seq__29051_29153__$1 = temp__4425__auto___29152__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29051_29153__$1)){
var c__19078__auto___29154 = cljs.core.chunk_first.call(null,seq__29051_29153__$1);
var G__29155 = cljs.core.chunk_rest.call(null,seq__29051_29153__$1);
var G__29156 = c__19078__auto___29154;
var G__29157 = cljs.core.count.call(null,c__19078__auto___29154);
var G__29158 = (0);
seq__29051_29139 = G__29155;
chunk__29052_29140 = G__29156;
count__29053_29141 = G__29157;
i__29054_29142 = G__29158;
continue;
} else {
var map__29057_29159 = cljs.core.first.call(null,seq__29051_29153__$1);
var map__29057_29160__$1 = ((((!((map__29057_29159 == null)))?((((map__29057_29159.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29057_29159.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29057_29159):map__29057_29159);
var gline_29161 = cljs.core.get.call(null,map__29057_29160__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29162 = cljs.core.get.call(null,map__29057_29160__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29163 = cljs.core.get.call(null,map__29057_29160__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29161], null),cljs.core.fnil.call(null,((function (seq__29051_29139,chunk__29052_29140,count__29053_29141,i__29054_29142,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29057_29159,map__29057_29160__$1,gline_29161,gcol_29162,name_29163,seq__29051_29153__$1,temp__4425__auto___29152__$1,vec__29050_29136,column_29137,column_info_29138,seq__29037_29130__$1,temp__4425__auto___29129,vec__29036_29086,line_29087,columns_29088,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29137], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29087,new cljs.core.Keyword(null,"col","col",-1959363084),column_29137,new cljs.core.Keyword(null,"name","name",1843675177),name_29163], null));
});})(seq__29051_29139,chunk__29052_29140,count__29053_29141,i__29054_29142,seq__29037_29089,chunk__29038_29090,count__29039_29091,i__29040_29092,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29057_29159,map__29057_29160__$1,gline_29161,gcol_29162,name_29163,seq__29051_29153__$1,temp__4425__auto___29152__$1,vec__29050_29136,column_29137,column_info_29138,seq__29037_29130__$1,temp__4425__auto___29129,vec__29036_29086,line_29087,columns_29088,inverted))
,cljs.core.sorted_map.call(null)));

var G__29164 = cljs.core.next.call(null,seq__29051_29153__$1);
var G__29165 = null;
var G__29166 = (0);
var G__29167 = (0);
seq__29051_29139 = G__29164;
chunk__29052_29140 = G__29165;
count__29053_29141 = G__29166;
i__29054_29142 = G__29167;
continue;
}
} else {
}
}
break;
}

var G__29168 = cljs.core.next.call(null,seq__29037_29130__$1);
var G__29169 = null;
var G__29170 = (0);
var G__29171 = (0);
seq__29037_29089 = G__29168;
chunk__29038_29090 = G__29169;
count__29039_29091 = G__29170;
i__29040_29092 = G__29171;
continue;
}
} else {
}
}
break;
}

var G__29172 = seq__29032_29082;
var G__29173 = chunk__29033_29083;
var G__29174 = count__29034_29084;
var G__29175 = (i__29035_29085 + (1));
seq__29032_29082 = G__29172;
chunk__29033_29083 = G__29173;
count__29034_29084 = G__29174;
i__29035_29085 = G__29175;
continue;
} else {
var temp__4425__auto___29176 = cljs.core.seq.call(null,seq__29032_29082);
if(temp__4425__auto___29176){
var seq__29032_29177__$1 = temp__4425__auto___29176;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29032_29177__$1)){
var c__19078__auto___29178 = cljs.core.chunk_first.call(null,seq__29032_29177__$1);
var G__29179 = cljs.core.chunk_rest.call(null,seq__29032_29177__$1);
var G__29180 = c__19078__auto___29178;
var G__29181 = cljs.core.count.call(null,c__19078__auto___29178);
var G__29182 = (0);
seq__29032_29082 = G__29179;
chunk__29033_29083 = G__29180;
count__29034_29084 = G__29181;
i__29035_29085 = G__29182;
continue;
} else {
var vec__29059_29183 = cljs.core.first.call(null,seq__29032_29177__$1);
var line_29184 = cljs.core.nth.call(null,vec__29059_29183,(0),null);
var columns_29185 = cljs.core.nth.call(null,vec__29059_29183,(1),null);
var seq__29060_29186 = cljs.core.seq.call(null,columns_29185);
var chunk__29061_29187 = null;
var count__29062_29188 = (0);
var i__29063_29189 = (0);
while(true){
if((i__29063_29189 < count__29062_29188)){
var vec__29064_29190 = cljs.core._nth.call(null,chunk__29061_29187,i__29063_29189);
var column_29191 = cljs.core.nth.call(null,vec__29064_29190,(0),null);
var column_info_29192 = cljs.core.nth.call(null,vec__29064_29190,(1),null);
var seq__29065_29193 = cljs.core.seq.call(null,column_info_29192);
var chunk__29066_29194 = null;
var count__29067_29195 = (0);
var i__29068_29196 = (0);
while(true){
if((i__29068_29196 < count__29067_29195)){
var map__29069_29197 = cljs.core._nth.call(null,chunk__29066_29194,i__29068_29196);
var map__29069_29198__$1 = ((((!((map__29069_29197 == null)))?((((map__29069_29197.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29069_29197.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29069_29197):map__29069_29197);
var gline_29199 = cljs.core.get.call(null,map__29069_29198__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29200 = cljs.core.get.call(null,map__29069_29198__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29201 = cljs.core.get.call(null,map__29069_29198__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29199], null),cljs.core.fnil.call(null,((function (seq__29065_29193,chunk__29066_29194,count__29067_29195,i__29068_29196,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29069_29197,map__29069_29198__$1,gline_29199,gcol_29200,name_29201,vec__29064_29190,column_29191,column_info_29192,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29191], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29184,new cljs.core.Keyword(null,"col","col",-1959363084),column_29191,new cljs.core.Keyword(null,"name","name",1843675177),name_29201], null));
});})(seq__29065_29193,chunk__29066_29194,count__29067_29195,i__29068_29196,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29069_29197,map__29069_29198__$1,gline_29199,gcol_29200,name_29201,vec__29064_29190,column_29191,column_info_29192,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted))
,cljs.core.sorted_map.call(null)));

var G__29202 = seq__29065_29193;
var G__29203 = chunk__29066_29194;
var G__29204 = count__29067_29195;
var G__29205 = (i__29068_29196 + (1));
seq__29065_29193 = G__29202;
chunk__29066_29194 = G__29203;
count__29067_29195 = G__29204;
i__29068_29196 = G__29205;
continue;
} else {
var temp__4425__auto___29206__$1 = cljs.core.seq.call(null,seq__29065_29193);
if(temp__4425__auto___29206__$1){
var seq__29065_29207__$1 = temp__4425__auto___29206__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29065_29207__$1)){
var c__19078__auto___29208 = cljs.core.chunk_first.call(null,seq__29065_29207__$1);
var G__29209 = cljs.core.chunk_rest.call(null,seq__29065_29207__$1);
var G__29210 = c__19078__auto___29208;
var G__29211 = cljs.core.count.call(null,c__19078__auto___29208);
var G__29212 = (0);
seq__29065_29193 = G__29209;
chunk__29066_29194 = G__29210;
count__29067_29195 = G__29211;
i__29068_29196 = G__29212;
continue;
} else {
var map__29071_29213 = cljs.core.first.call(null,seq__29065_29207__$1);
var map__29071_29214__$1 = ((((!((map__29071_29213 == null)))?((((map__29071_29213.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29071_29213.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29071_29213):map__29071_29213);
var gline_29215 = cljs.core.get.call(null,map__29071_29214__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29216 = cljs.core.get.call(null,map__29071_29214__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29217 = cljs.core.get.call(null,map__29071_29214__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29215], null),cljs.core.fnil.call(null,((function (seq__29065_29193,chunk__29066_29194,count__29067_29195,i__29068_29196,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29071_29213,map__29071_29214__$1,gline_29215,gcol_29216,name_29217,seq__29065_29207__$1,temp__4425__auto___29206__$1,vec__29064_29190,column_29191,column_info_29192,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29191], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29184,new cljs.core.Keyword(null,"col","col",-1959363084),column_29191,new cljs.core.Keyword(null,"name","name",1843675177),name_29217], null));
});})(seq__29065_29193,chunk__29066_29194,count__29067_29195,i__29068_29196,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29071_29213,map__29071_29214__$1,gline_29215,gcol_29216,name_29217,seq__29065_29207__$1,temp__4425__auto___29206__$1,vec__29064_29190,column_29191,column_info_29192,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted))
,cljs.core.sorted_map.call(null)));

var G__29218 = cljs.core.next.call(null,seq__29065_29207__$1);
var G__29219 = null;
var G__29220 = (0);
var G__29221 = (0);
seq__29065_29193 = G__29218;
chunk__29066_29194 = G__29219;
count__29067_29195 = G__29220;
i__29068_29196 = G__29221;
continue;
}
} else {
}
}
break;
}

var G__29222 = seq__29060_29186;
var G__29223 = chunk__29061_29187;
var G__29224 = count__29062_29188;
var G__29225 = (i__29063_29189 + (1));
seq__29060_29186 = G__29222;
chunk__29061_29187 = G__29223;
count__29062_29188 = G__29224;
i__29063_29189 = G__29225;
continue;
} else {
var temp__4425__auto___29226__$1 = cljs.core.seq.call(null,seq__29060_29186);
if(temp__4425__auto___29226__$1){
var seq__29060_29227__$1 = temp__4425__auto___29226__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29060_29227__$1)){
var c__19078__auto___29228 = cljs.core.chunk_first.call(null,seq__29060_29227__$1);
var G__29229 = cljs.core.chunk_rest.call(null,seq__29060_29227__$1);
var G__29230 = c__19078__auto___29228;
var G__29231 = cljs.core.count.call(null,c__19078__auto___29228);
var G__29232 = (0);
seq__29060_29186 = G__29229;
chunk__29061_29187 = G__29230;
count__29062_29188 = G__29231;
i__29063_29189 = G__29232;
continue;
} else {
var vec__29073_29233 = cljs.core.first.call(null,seq__29060_29227__$1);
var column_29234 = cljs.core.nth.call(null,vec__29073_29233,(0),null);
var column_info_29235 = cljs.core.nth.call(null,vec__29073_29233,(1),null);
var seq__29074_29236 = cljs.core.seq.call(null,column_info_29235);
var chunk__29075_29237 = null;
var count__29076_29238 = (0);
var i__29077_29239 = (0);
while(true){
if((i__29077_29239 < count__29076_29238)){
var map__29078_29240 = cljs.core._nth.call(null,chunk__29075_29237,i__29077_29239);
var map__29078_29241__$1 = ((((!((map__29078_29240 == null)))?((((map__29078_29240.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29078_29240.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29078_29240):map__29078_29240);
var gline_29242 = cljs.core.get.call(null,map__29078_29241__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29243 = cljs.core.get.call(null,map__29078_29241__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29244 = cljs.core.get.call(null,map__29078_29241__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29242], null),cljs.core.fnil.call(null,((function (seq__29074_29236,chunk__29075_29237,count__29076_29238,i__29077_29239,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29078_29240,map__29078_29241__$1,gline_29242,gcol_29243,name_29244,vec__29073_29233,column_29234,column_info_29235,seq__29060_29227__$1,temp__4425__auto___29226__$1,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29234], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29184,new cljs.core.Keyword(null,"col","col",-1959363084),column_29234,new cljs.core.Keyword(null,"name","name",1843675177),name_29244], null));
});})(seq__29074_29236,chunk__29075_29237,count__29076_29238,i__29077_29239,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29078_29240,map__29078_29241__$1,gline_29242,gcol_29243,name_29244,vec__29073_29233,column_29234,column_info_29235,seq__29060_29227__$1,temp__4425__auto___29226__$1,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted))
,cljs.core.sorted_map.call(null)));

var G__29245 = seq__29074_29236;
var G__29246 = chunk__29075_29237;
var G__29247 = count__29076_29238;
var G__29248 = (i__29077_29239 + (1));
seq__29074_29236 = G__29245;
chunk__29075_29237 = G__29246;
count__29076_29238 = G__29247;
i__29077_29239 = G__29248;
continue;
} else {
var temp__4425__auto___29249__$2 = cljs.core.seq.call(null,seq__29074_29236);
if(temp__4425__auto___29249__$2){
var seq__29074_29250__$1 = temp__4425__auto___29249__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29074_29250__$1)){
var c__19078__auto___29251 = cljs.core.chunk_first.call(null,seq__29074_29250__$1);
var G__29252 = cljs.core.chunk_rest.call(null,seq__29074_29250__$1);
var G__29253 = c__19078__auto___29251;
var G__29254 = cljs.core.count.call(null,c__19078__auto___29251);
var G__29255 = (0);
seq__29074_29236 = G__29252;
chunk__29075_29237 = G__29253;
count__29076_29238 = G__29254;
i__29077_29239 = G__29255;
continue;
} else {
var map__29080_29256 = cljs.core.first.call(null,seq__29074_29250__$1);
var map__29080_29257__$1 = ((((!((map__29080_29256 == null)))?((((map__29080_29256.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29080_29256.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29080_29256):map__29080_29256);
var gline_29258 = cljs.core.get.call(null,map__29080_29257__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_29259 = cljs.core.get.call(null,map__29080_29257__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_29260 = cljs.core.get.call(null,map__29080_29257__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_29258], null),cljs.core.fnil.call(null,((function (seq__29074_29236,chunk__29075_29237,count__29076_29238,i__29077_29239,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29080_29256,map__29080_29257__$1,gline_29258,gcol_29259,name_29260,seq__29074_29250__$1,temp__4425__auto___29249__$2,vec__29073_29233,column_29234,column_info_29235,seq__29060_29227__$1,temp__4425__auto___29226__$1,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [column_29234], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_29184,new cljs.core.Keyword(null,"col","col",-1959363084),column_29234,new cljs.core.Keyword(null,"name","name",1843675177),name_29260], null));
});})(seq__29074_29236,chunk__29075_29237,count__29076_29238,i__29077_29239,seq__29060_29186,chunk__29061_29187,count__29062_29188,i__29063_29189,seq__29032_29082,chunk__29033_29083,count__29034_29084,i__29035_29085,map__29080_29256,map__29080_29257__$1,gline_29258,gcol_29259,name_29260,seq__29074_29250__$1,temp__4425__auto___29249__$2,vec__29073_29233,column_29234,column_info_29235,seq__29060_29227__$1,temp__4425__auto___29226__$1,vec__29059_29183,line_29184,columns_29185,seq__29032_29177__$1,temp__4425__auto___29176,inverted))
,cljs.core.sorted_map.call(null)));

var G__29261 = cljs.core.next.call(null,seq__29074_29250__$1);
var G__29262 = null;
var G__29263 = (0);
var G__29264 = (0);
seq__29074_29236 = G__29261;
chunk__29075_29237 = G__29262;
count__29076_29238 = G__29263;
i__29077_29239 = G__29264;
continue;
}
} else {
}
}
break;
}

var G__29265 = cljs.core.next.call(null,seq__29060_29227__$1);
var G__29266 = null;
var G__29267 = (0);
var G__29268 = (0);
seq__29060_29186 = G__29265;
chunk__29061_29187 = G__29266;
count__29062_29188 = G__29267;
i__29063_29189 = G__29268;
continue;
}
} else {
}
}
break;
}

var G__29269 = cljs.core.next.call(null,seq__29032_29177__$1);
var G__29270 = null;
var G__29271 = (0);
var G__29272 = (0);
seq__29032_29082 = G__29269;
chunk__29033_29083 = G__29270;
count__29034_29084 = G__29271;
i__29035_29085 = G__29272;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});

//# sourceMappingURL=source_map.js.map