(ns gadjett.jipper
  (:require [clojure.zip :as zip]))


(defn- loc-replace-and-insert [match [replacement & values] loc]
  (if (= (zip/node loc) match)
    (as-> loc $
      (zip/replace $ replacement)
      (reduce (fn [agg v] (zip/insert-right agg v)) $ (reverse values)))
    loc))

(defn replace-and-insert
  "Recursively transforms `form` by replacing `match` with values."
  [match values form]
  (let [the-values (or (seq values) (list values))]
  (loop [loc (zip/seq-zip form)]
    (if (zip/end? loc)
      (zip/root loc)
      (recur (zip/next (loc-replace-and-insert match the-values loc)))))))
