// Compiled by ClojureScript 1.9.227 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args28022 = [];
var len__25820__auto___28028 = arguments.length;
var i__25821__auto___28029 = (0);
while(true){
if((i__25821__auto___28029 < len__25820__auto___28028)){
args28022.push((arguments[i__25821__auto___28029]));

var G__28030 = (i__25821__auto___28029 + (1));
i__25821__auto___28029 = G__28030;
continue;
} else {
}
break;
}

var G__28024 = args28022.length;
switch (G__28024) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28022.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async28025 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28025 = (function (f,blockable,meta28026){
this.f = f;
this.blockable = blockable;
this.meta28026 = meta28026;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28027,meta28026__$1){
var self__ = this;
var _28027__$1 = this;
return (new cljs.core.async.t_cljs$core$async28025(self__.f,self__.blockable,meta28026__$1));
});

cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28027){
var self__ = this;
var _28027__$1 = this;
return self__.meta28026;
});

cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async28025.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async28025.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28026","meta28026",1814892642,null)], null);
});

cljs.core.async.t_cljs$core$async28025.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28025.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28025";

cljs.core.async.t_cljs$core$async28025.cljs$lang$ctorPrWriter = (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async28025");
});

cljs.core.async.__GT_t_cljs$core$async28025 = (function cljs$core$async$__GT_t_cljs$core$async28025(f__$1,blockable__$1,meta28026){
return (new cljs.core.async.t_cljs$core$async28025(f__$1,blockable__$1,meta28026));
});

}

return (new cljs.core.async.t_cljs$core$async28025(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args28034 = [];
var len__25820__auto___28037 = arguments.length;
var i__25821__auto___28038 = (0);
while(true){
if((i__25821__auto___28038 < len__25820__auto___28037)){
args28034.push((arguments[i__25821__auto___28038]));

var G__28039 = (i__25821__auto___28038 + (1));
i__25821__auto___28038 = G__28039;
continue;
} else {
}
break;
}

var G__28036 = args28034.length;
switch (G__28036) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28034.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args28041 = [];
var len__25820__auto___28044 = arguments.length;
var i__25821__auto___28045 = (0);
while(true){
if((i__25821__auto___28045 < len__25820__auto___28044)){
args28041.push((arguments[i__25821__auto___28045]));

var G__28046 = (i__25821__auto___28045 + (1));
i__25821__auto___28045 = G__28046;
continue;
} else {
}
break;
}

var G__28043 = args28041.length;
switch (G__28043) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28041.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args28048 = [];
var len__25820__auto___28051 = arguments.length;
var i__25821__auto___28052 = (0);
while(true){
if((i__25821__auto___28052 < len__25820__auto___28051)){
args28048.push((arguments[i__25821__auto___28052]));

var G__28053 = (i__25821__auto___28052 + (1));
i__25821__auto___28052 = G__28053;
continue;
} else {
}
break;
}

var G__28050 = args28048.length;
switch (G__28050) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28048.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_28055 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_28055);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_28055,ret){
return (function (){
return fn1.call(null,val_28055);
});})(val_28055,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args28056 = [];
var len__25820__auto___28059 = arguments.length;
var i__25821__auto___28060 = (0);
while(true){
if((i__25821__auto___28060 < len__25820__auto___28059)){
args28056.push((arguments[i__25821__auto___28060]));

var G__28061 = (i__25821__auto___28060 + (1));
i__25821__auto___28060 = G__28061;
continue;
} else {
}
break;
}

var G__28058 = args28056.length;
switch (G__28058) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28056.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__25660__auto___28063 = n;
var x_28064 = (0);
while(true){
if((x_28064 < n__25660__auto___28063)){
(a[x_28064] = (0));

var G__28065 = (x_28064 + (1));
x_28064 = G__28065;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__28066 = (i + (1));
i = G__28066;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async28070 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28070 = (function (alt_flag,flag,meta28071){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta28071 = meta28071;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_28072,meta28071__$1){
var self__ = this;
var _28072__$1 = this;
return (new cljs.core.async.t_cljs$core$async28070(self__.alt_flag,self__.flag,meta28071__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_28072){
var self__ = this;
var _28072__$1 = this;
return self__.meta28071;
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28071","meta28071",-1168607507,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async28070.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28070.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28070";

cljs.core.async.t_cljs$core$async28070.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async28070");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async28070 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28070(alt_flag__$1,flag__$1,meta28071){
return (new cljs.core.async.t_cljs$core$async28070(alt_flag__$1,flag__$1,meta28071));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async28070(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async28076 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28076 = (function (alt_handler,flag,cb,meta28077){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta28077 = meta28077;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28078,meta28077__$1){
var self__ = this;
var _28078__$1 = this;
return (new cljs.core.async.t_cljs$core$async28076(self__.alt_handler,self__.flag,self__.cb,meta28077__$1));
});

cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28078){
var self__ = this;
var _28078__$1 = this;
return self__.meta28077;
});

cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28076.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async28076.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28077","meta28077",1879271636,null)], null);
});

cljs.core.async.t_cljs$core$async28076.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28076.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28076";

cljs.core.async.t_cljs$core$async28076.cljs$lang$ctorPrWriter = (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async28076");
});

cljs.core.async.__GT_t_cljs$core$async28076 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28076(alt_handler__$1,flag__$1,cb__$1,meta28077){
return (new cljs.core.async.t_cljs$core$async28076(alt_handler__$1,flag__$1,cb__$1,meta28077));
});

}

return (new cljs.core.async.t_cljs$core$async28076(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28079_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28079_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28080_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28080_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__24745__auto__ = wport;
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28081 = (i + (1));
i = G__28081;
continue;
}
} else {
return null;
}
break;
}
})();
var or__24745__auto__ = ret;
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__24733__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__24733__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__24733__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__25827__auto__ = [];
var len__25820__auto___28087 = arguments.length;
var i__25821__auto___28088 = (0);
while(true){
if((i__25821__auto___28088 < len__25820__auto___28087)){
args__25827__auto__.push((arguments[i__25821__auto___28088]));

var G__28089 = (i__25821__auto___28088 + (1));
i__25821__auto___28088 = G__28089;
continue;
} else {
}
break;
}

var argseq__25828__auto__ = ((((1) < args__25827__auto__.length))?(new cljs.core.IndexedSeq(args__25827__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__25828__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28084){
var map__28085 = p__28084;
var map__28085__$1 = ((((!((map__28085 == null)))?((((map__28085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28085):map__28085);
var opts = map__28085__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28082){
var G__28083 = cljs.core.first.call(null,seq28082);
var seq28082__$1 = cljs.core.next.call(null,seq28082);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28083,seq28082__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args28090 = [];
var len__25820__auto___28140 = arguments.length;
var i__25821__auto___28141 = (0);
while(true){
if((i__25821__auto___28141 < len__25820__auto___28140)){
args28090.push((arguments[i__25821__auto___28141]));

var G__28142 = (i__25821__auto___28141 + (1));
i__25821__auto___28141 = G__28142;
continue;
} else {
}
break;
}

var G__28092 = args28090.length;
switch (G__28092) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28090.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__27977__auto___28144 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___28144){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___28144){
return (function (state_28116){
var state_val_28117 = (state_28116[(1)]);
if((state_val_28117 === (7))){
var inst_28112 = (state_28116[(2)]);
var state_28116__$1 = state_28116;
var statearr_28118_28145 = state_28116__$1;
(statearr_28118_28145[(2)] = inst_28112);

(statearr_28118_28145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (1))){
var state_28116__$1 = state_28116;
var statearr_28119_28146 = state_28116__$1;
(statearr_28119_28146[(2)] = null);

(statearr_28119_28146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (4))){
var inst_28095 = (state_28116[(7)]);
var inst_28095__$1 = (state_28116[(2)]);
var inst_28096 = (inst_28095__$1 == null);
var state_28116__$1 = (function (){var statearr_28120 = state_28116;
(statearr_28120[(7)] = inst_28095__$1);

return statearr_28120;
})();
if(cljs.core.truth_(inst_28096)){
var statearr_28121_28147 = state_28116__$1;
(statearr_28121_28147[(1)] = (5));

} else {
var statearr_28122_28148 = state_28116__$1;
(statearr_28122_28148[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (13))){
var state_28116__$1 = state_28116;
var statearr_28123_28149 = state_28116__$1;
(statearr_28123_28149[(2)] = null);

(statearr_28123_28149[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (6))){
var inst_28095 = (state_28116[(7)]);
var state_28116__$1 = state_28116;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28116__$1,(11),to,inst_28095);
} else {
if((state_val_28117 === (3))){
var inst_28114 = (state_28116[(2)]);
var state_28116__$1 = state_28116;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28116__$1,inst_28114);
} else {
if((state_val_28117 === (12))){
var state_28116__$1 = state_28116;
var statearr_28124_28150 = state_28116__$1;
(statearr_28124_28150[(2)] = null);

(statearr_28124_28150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (2))){
var state_28116__$1 = state_28116;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28116__$1,(4),from);
} else {
if((state_val_28117 === (11))){
var inst_28105 = (state_28116[(2)]);
var state_28116__$1 = state_28116;
if(cljs.core.truth_(inst_28105)){
var statearr_28125_28151 = state_28116__$1;
(statearr_28125_28151[(1)] = (12));

} else {
var statearr_28126_28152 = state_28116__$1;
(statearr_28126_28152[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (9))){
var state_28116__$1 = state_28116;
var statearr_28127_28153 = state_28116__$1;
(statearr_28127_28153[(2)] = null);

(statearr_28127_28153[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (5))){
var state_28116__$1 = state_28116;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28128_28154 = state_28116__$1;
(statearr_28128_28154[(1)] = (8));

} else {
var statearr_28129_28155 = state_28116__$1;
(statearr_28129_28155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (14))){
var inst_28110 = (state_28116[(2)]);
var state_28116__$1 = state_28116;
var statearr_28130_28156 = state_28116__$1;
(statearr_28130_28156[(2)] = inst_28110);

(statearr_28130_28156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (10))){
var inst_28102 = (state_28116[(2)]);
var state_28116__$1 = state_28116;
var statearr_28131_28157 = state_28116__$1;
(statearr_28131_28157[(2)] = inst_28102);

(statearr_28131_28157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28117 === (8))){
var inst_28099 = cljs.core.async.close_BANG_.call(null,to);
var state_28116__$1 = state_28116;
var statearr_28132_28158 = state_28116__$1;
(statearr_28132_28158[(2)] = inst_28099);

(statearr_28132_28158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___28144))
;
return ((function (switch__27865__auto__,c__27977__auto___28144){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_28136 = [null,null,null,null,null,null,null,null];
(statearr_28136[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_28136[(1)] = (1));

return statearr_28136;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_28116){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28116);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28137){if((e28137 instanceof Object)){
var ex__27869__auto__ = e28137;
var statearr_28138_28159 = state_28116;
(statearr_28138_28159[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28116);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28137;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28160 = state_28116;
state_28116 = G__28160;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_28116){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_28116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___28144))
})();
var state__27979__auto__ = (function (){var statearr_28139 = f__27978__auto__.call(null);
(statearr_28139[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28144);

return statearr_28139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___28144))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__28348){
var vec__28349 = p__28348;
var v = cljs.core.nth.call(null,vec__28349,(0),null);
var p = cljs.core.nth.call(null,vec__28349,(1),null);
var job = vec__28349;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__27977__auto___28535 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results){
return (function (state_28356){
var state_val_28357 = (state_28356[(1)]);
if((state_val_28357 === (1))){
var state_28356__$1 = state_28356;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28356__$1,(2),res,v);
} else {
if((state_val_28357 === (2))){
var inst_28353 = (state_28356[(2)]);
var inst_28354 = cljs.core.async.close_BANG_.call(null,res);
var state_28356__$1 = (function (){var statearr_28358 = state_28356;
(statearr_28358[(7)] = inst_28353);

return statearr_28358;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28356__$1,inst_28354);
} else {
return null;
}
}
});})(c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results))
;
return ((function (switch__27865__auto__,c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_28362 = [null,null,null,null,null,null,null,null];
(statearr_28362[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__);

(statearr_28362[(1)] = (1));

return statearr_28362;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1 = (function (state_28356){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28363){if((e28363 instanceof Object)){
var ex__27869__auto__ = e28363;
var statearr_28364_28536 = state_28356;
(statearr_28364_28536[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28356);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28363;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28537 = state_28356;
state_28356 = G__28537;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = function(state_28356){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1.call(this,state_28356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results))
})();
var state__27979__auto__ = (function (){var statearr_28365 = f__27978__auto__.call(null);
(statearr_28365[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28535);

return statearr_28365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___28535,res,vec__28349,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__28366){
var vec__28367 = p__28366;
var v = cljs.core.nth.call(null,vec__28367,(0),null);
var p = cljs.core.nth.call(null,vec__28367,(1),null);
var job = vec__28367;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__25660__auto___28538 = n;
var __28539 = (0);
while(true){
if((__28539 < n__25660__auto___28538)){
var G__28370_28540 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__28370_28540) {
case "compute":
var c__27977__auto___28542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28539,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (__28539,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function (state_28383){
var state_val_28384 = (state_28383[(1)]);
if((state_val_28384 === (1))){
var state_28383__$1 = state_28383;
var statearr_28385_28543 = state_28383__$1;
(statearr_28385_28543[(2)] = null);

(statearr_28385_28543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (2))){
var state_28383__$1 = state_28383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28383__$1,(4),jobs);
} else {
if((state_val_28384 === (3))){
var inst_28381 = (state_28383[(2)]);
var state_28383__$1 = state_28383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28383__$1,inst_28381);
} else {
if((state_val_28384 === (4))){
var inst_28373 = (state_28383[(2)]);
var inst_28374 = process.call(null,inst_28373);
var state_28383__$1 = state_28383;
if(cljs.core.truth_(inst_28374)){
var statearr_28386_28544 = state_28383__$1;
(statearr_28386_28544[(1)] = (5));

} else {
var statearr_28387_28545 = state_28383__$1;
(statearr_28387_28545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (5))){
var state_28383__$1 = state_28383;
var statearr_28388_28546 = state_28383__$1;
(statearr_28388_28546[(2)] = null);

(statearr_28388_28546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (6))){
var state_28383__$1 = state_28383;
var statearr_28389_28547 = state_28383__$1;
(statearr_28389_28547[(2)] = null);

(statearr_28389_28547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (7))){
var inst_28379 = (state_28383[(2)]);
var state_28383__$1 = state_28383;
var statearr_28390_28548 = state_28383__$1;
(statearr_28390_28548[(2)] = inst_28379);

(statearr_28390_28548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28539,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
;
return ((function (__28539,switch__27865__auto__,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_28394 = [null,null,null,null,null,null,null];
(statearr_28394[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__);

(statearr_28394[(1)] = (1));

return statearr_28394;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1 = (function (state_28383){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28395){if((e28395 instanceof Object)){
var ex__27869__auto__ = e28395;
var statearr_28396_28549 = state_28383;
(statearr_28396_28549[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28395;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28550 = state_28383;
state_28383 = G__28550;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = function(state_28383){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1.call(this,state_28383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__;
})()
;})(__28539,switch__27865__auto__,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
})();
var state__27979__auto__ = (function (){var statearr_28397 = f__27978__auto__.call(null);
(statearr_28397[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28542);

return statearr_28397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(__28539,c__27977__auto___28542,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
);


break;
case "async":
var c__27977__auto___28551 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28539,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (__28539,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function (state_28410){
var state_val_28411 = (state_28410[(1)]);
if((state_val_28411 === (1))){
var state_28410__$1 = state_28410;
var statearr_28412_28552 = state_28410__$1;
(statearr_28412_28552[(2)] = null);

(statearr_28412_28552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28411 === (2))){
var state_28410__$1 = state_28410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28410__$1,(4),jobs);
} else {
if((state_val_28411 === (3))){
var inst_28408 = (state_28410[(2)]);
var state_28410__$1 = state_28410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28410__$1,inst_28408);
} else {
if((state_val_28411 === (4))){
var inst_28400 = (state_28410[(2)]);
var inst_28401 = async.call(null,inst_28400);
var state_28410__$1 = state_28410;
if(cljs.core.truth_(inst_28401)){
var statearr_28413_28553 = state_28410__$1;
(statearr_28413_28553[(1)] = (5));

} else {
var statearr_28414_28554 = state_28410__$1;
(statearr_28414_28554[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28411 === (5))){
var state_28410__$1 = state_28410;
var statearr_28415_28555 = state_28410__$1;
(statearr_28415_28555[(2)] = null);

(statearr_28415_28555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28411 === (6))){
var state_28410__$1 = state_28410;
var statearr_28416_28556 = state_28410__$1;
(statearr_28416_28556[(2)] = null);

(statearr_28416_28556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28411 === (7))){
var inst_28406 = (state_28410[(2)]);
var state_28410__$1 = state_28410;
var statearr_28417_28557 = state_28410__$1;
(statearr_28417_28557[(2)] = inst_28406);

(statearr_28417_28557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28539,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
;
return ((function (__28539,switch__27865__auto__,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_28421 = [null,null,null,null,null,null,null];
(statearr_28421[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__);

(statearr_28421[(1)] = (1));

return statearr_28421;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1 = (function (state_28410){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28422){if((e28422 instanceof Object)){
var ex__27869__auto__ = e28422;
var statearr_28423_28558 = state_28410;
(statearr_28423_28558[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28410);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28422;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28559 = state_28410;
state_28410 = G__28559;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = function(state_28410){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1.call(this,state_28410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__;
})()
;})(__28539,switch__27865__auto__,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
})();
var state__27979__auto__ = (function (){var statearr_28424 = f__27978__auto__.call(null);
(statearr_28424[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28551);

return statearr_28424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(__28539,c__27977__auto___28551,G__28370_28540,n__25660__auto___28538,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__28560 = (__28539 + (1));
__28539 = G__28560;
continue;
} else {
}
break;
}

var c__27977__auto___28561 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___28561,jobs,results,process,async){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___28561,jobs,results,process,async){
return (function (state_28446){
var state_val_28447 = (state_28446[(1)]);
if((state_val_28447 === (1))){
var state_28446__$1 = state_28446;
var statearr_28448_28562 = state_28446__$1;
(statearr_28448_28562[(2)] = null);

(statearr_28448_28562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28447 === (2))){
var state_28446__$1 = state_28446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28446__$1,(4),from);
} else {
if((state_val_28447 === (3))){
var inst_28444 = (state_28446[(2)]);
var state_28446__$1 = state_28446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28446__$1,inst_28444);
} else {
if((state_val_28447 === (4))){
var inst_28427 = (state_28446[(7)]);
var inst_28427__$1 = (state_28446[(2)]);
var inst_28428 = (inst_28427__$1 == null);
var state_28446__$1 = (function (){var statearr_28449 = state_28446;
(statearr_28449[(7)] = inst_28427__$1);

return statearr_28449;
})();
if(cljs.core.truth_(inst_28428)){
var statearr_28450_28563 = state_28446__$1;
(statearr_28450_28563[(1)] = (5));

} else {
var statearr_28451_28564 = state_28446__$1;
(statearr_28451_28564[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28447 === (5))){
var inst_28430 = cljs.core.async.close_BANG_.call(null,jobs);
var state_28446__$1 = state_28446;
var statearr_28452_28565 = state_28446__$1;
(statearr_28452_28565[(2)] = inst_28430);

(statearr_28452_28565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28447 === (6))){
var inst_28432 = (state_28446[(8)]);
var inst_28427 = (state_28446[(7)]);
var inst_28432__$1 = cljs.core.async.chan.call(null,(1));
var inst_28433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28434 = [inst_28427,inst_28432__$1];
var inst_28435 = (new cljs.core.PersistentVector(null,2,(5),inst_28433,inst_28434,null));
var state_28446__$1 = (function (){var statearr_28453 = state_28446;
(statearr_28453[(8)] = inst_28432__$1);

return statearr_28453;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28446__$1,(8),jobs,inst_28435);
} else {
if((state_val_28447 === (7))){
var inst_28442 = (state_28446[(2)]);
var state_28446__$1 = state_28446;
var statearr_28454_28566 = state_28446__$1;
(statearr_28454_28566[(2)] = inst_28442);

(statearr_28454_28566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28447 === (8))){
var inst_28432 = (state_28446[(8)]);
var inst_28437 = (state_28446[(2)]);
var state_28446__$1 = (function (){var statearr_28455 = state_28446;
(statearr_28455[(9)] = inst_28437);

return statearr_28455;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28446__$1,(9),results,inst_28432);
} else {
if((state_val_28447 === (9))){
var inst_28439 = (state_28446[(2)]);
var state_28446__$1 = (function (){var statearr_28456 = state_28446;
(statearr_28456[(10)] = inst_28439);

return statearr_28456;
})();
var statearr_28457_28567 = state_28446__$1;
(statearr_28457_28567[(2)] = null);

(statearr_28457_28567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___28561,jobs,results,process,async))
;
return ((function (switch__27865__auto__,c__27977__auto___28561,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_28461 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28461[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__);

(statearr_28461[(1)] = (1));

return statearr_28461;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1 = (function (state_28446){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28462){if((e28462 instanceof Object)){
var ex__27869__auto__ = e28462;
var statearr_28463_28568 = state_28446;
(statearr_28463_28568[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28462;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28569 = state_28446;
state_28446 = G__28569;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = function(state_28446){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1.call(this,state_28446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___28561,jobs,results,process,async))
})();
var state__27979__auto__ = (function (){var statearr_28464 = f__27978__auto__.call(null);
(statearr_28464[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28561);

return statearr_28464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___28561,jobs,results,process,async))
);


var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__,jobs,results,process,async){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__,jobs,results,process,async){
return (function (state_28502){
var state_val_28503 = (state_28502[(1)]);
if((state_val_28503 === (7))){
var inst_28498 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
var statearr_28504_28570 = state_28502__$1;
(statearr_28504_28570[(2)] = inst_28498);

(statearr_28504_28570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (20))){
var state_28502__$1 = state_28502;
var statearr_28505_28571 = state_28502__$1;
(statearr_28505_28571[(2)] = null);

(statearr_28505_28571[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (1))){
var state_28502__$1 = state_28502;
var statearr_28506_28572 = state_28502__$1;
(statearr_28506_28572[(2)] = null);

(statearr_28506_28572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (4))){
var inst_28467 = (state_28502[(7)]);
var inst_28467__$1 = (state_28502[(2)]);
var inst_28468 = (inst_28467__$1 == null);
var state_28502__$1 = (function (){var statearr_28507 = state_28502;
(statearr_28507[(7)] = inst_28467__$1);

return statearr_28507;
})();
if(cljs.core.truth_(inst_28468)){
var statearr_28508_28573 = state_28502__$1;
(statearr_28508_28573[(1)] = (5));

} else {
var statearr_28509_28574 = state_28502__$1;
(statearr_28509_28574[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (15))){
var inst_28480 = (state_28502[(8)]);
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28502__$1,(18),to,inst_28480);
} else {
if((state_val_28503 === (21))){
var inst_28493 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
var statearr_28510_28575 = state_28502__$1;
(statearr_28510_28575[(2)] = inst_28493);

(statearr_28510_28575[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (13))){
var inst_28495 = (state_28502[(2)]);
var state_28502__$1 = (function (){var statearr_28511 = state_28502;
(statearr_28511[(9)] = inst_28495);

return statearr_28511;
})();
var statearr_28512_28576 = state_28502__$1;
(statearr_28512_28576[(2)] = null);

(statearr_28512_28576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (6))){
var inst_28467 = (state_28502[(7)]);
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28502__$1,(11),inst_28467);
} else {
if((state_val_28503 === (17))){
var inst_28488 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
if(cljs.core.truth_(inst_28488)){
var statearr_28513_28577 = state_28502__$1;
(statearr_28513_28577[(1)] = (19));

} else {
var statearr_28514_28578 = state_28502__$1;
(statearr_28514_28578[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (3))){
var inst_28500 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28502__$1,inst_28500);
} else {
if((state_val_28503 === (12))){
var inst_28477 = (state_28502[(10)]);
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28502__$1,(14),inst_28477);
} else {
if((state_val_28503 === (2))){
var state_28502__$1 = state_28502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28502__$1,(4),results);
} else {
if((state_val_28503 === (19))){
var state_28502__$1 = state_28502;
var statearr_28515_28579 = state_28502__$1;
(statearr_28515_28579[(2)] = null);

(statearr_28515_28579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (11))){
var inst_28477 = (state_28502[(2)]);
var state_28502__$1 = (function (){var statearr_28516 = state_28502;
(statearr_28516[(10)] = inst_28477);

return statearr_28516;
})();
var statearr_28517_28580 = state_28502__$1;
(statearr_28517_28580[(2)] = null);

(statearr_28517_28580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (9))){
var state_28502__$1 = state_28502;
var statearr_28518_28581 = state_28502__$1;
(statearr_28518_28581[(2)] = null);

(statearr_28518_28581[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (5))){
var state_28502__$1 = state_28502;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28519_28582 = state_28502__$1;
(statearr_28519_28582[(1)] = (8));

} else {
var statearr_28520_28583 = state_28502__$1;
(statearr_28520_28583[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (14))){
var inst_28480 = (state_28502[(8)]);
var inst_28482 = (state_28502[(11)]);
var inst_28480__$1 = (state_28502[(2)]);
var inst_28481 = (inst_28480__$1 == null);
var inst_28482__$1 = cljs.core.not.call(null,inst_28481);
var state_28502__$1 = (function (){var statearr_28521 = state_28502;
(statearr_28521[(8)] = inst_28480__$1);

(statearr_28521[(11)] = inst_28482__$1);

return statearr_28521;
})();
if(inst_28482__$1){
var statearr_28522_28584 = state_28502__$1;
(statearr_28522_28584[(1)] = (15));

} else {
var statearr_28523_28585 = state_28502__$1;
(statearr_28523_28585[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (16))){
var inst_28482 = (state_28502[(11)]);
var state_28502__$1 = state_28502;
var statearr_28524_28586 = state_28502__$1;
(statearr_28524_28586[(2)] = inst_28482);

(statearr_28524_28586[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (10))){
var inst_28474 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
var statearr_28525_28587 = state_28502__$1;
(statearr_28525_28587[(2)] = inst_28474);

(statearr_28525_28587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (18))){
var inst_28485 = (state_28502[(2)]);
var state_28502__$1 = state_28502;
var statearr_28526_28588 = state_28502__$1;
(statearr_28526_28588[(2)] = inst_28485);

(statearr_28526_28588[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28503 === (8))){
var inst_28471 = cljs.core.async.close_BANG_.call(null,to);
var state_28502__$1 = state_28502;
var statearr_28527_28589 = state_28502__$1;
(statearr_28527_28589[(2)] = inst_28471);

(statearr_28527_28589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__,jobs,results,process,async))
;
return ((function (switch__27865__auto__,c__27977__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_28531 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28531[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__);

(statearr_28531[(1)] = (1));

return statearr_28531;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1 = (function (state_28502){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28532){if((e28532 instanceof Object)){
var ex__27869__auto__ = e28532;
var statearr_28533_28590 = state_28502;
(statearr_28533_28590[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28532;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28591 = state_28502;
state_28502 = G__28591;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__ = function(state_28502){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1.call(this,state_28502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__,jobs,results,process,async))
})();
var state__27979__auto__ = (function (){var statearr_28534 = f__27978__auto__.call(null);
(statearr_28534[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_28534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__,jobs,results,process,async))
);

return c__27977__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args28592 = [];
var len__25820__auto___28595 = arguments.length;
var i__25821__auto___28596 = (0);
while(true){
if((i__25821__auto___28596 < len__25820__auto___28595)){
args28592.push((arguments[i__25821__auto___28596]));

var G__28597 = (i__25821__auto___28596 + (1));
i__25821__auto___28596 = G__28597;
continue;
} else {
}
break;
}

var G__28594 = args28592.length;
switch (G__28594) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28592.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args28599 = [];
var len__25820__auto___28602 = arguments.length;
var i__25821__auto___28603 = (0);
while(true){
if((i__25821__auto___28603 < len__25820__auto___28602)){
args28599.push((arguments[i__25821__auto___28603]));

var G__28604 = (i__25821__auto___28603 + (1));
i__25821__auto___28603 = G__28604;
continue;
} else {
}
break;
}

var G__28601 = args28599.length;
switch (G__28601) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28599.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args28606 = [];
var len__25820__auto___28659 = arguments.length;
var i__25821__auto___28660 = (0);
while(true){
if((i__25821__auto___28660 < len__25820__auto___28659)){
args28606.push((arguments[i__25821__auto___28660]));

var G__28661 = (i__25821__auto___28660 + (1));
i__25821__auto___28660 = G__28661;
continue;
} else {
}
break;
}

var G__28608 = args28606.length;
switch (G__28608) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28606.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__27977__auto___28663 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___28663,tc,fc){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___28663,tc,fc){
return (function (state_28634){
var state_val_28635 = (state_28634[(1)]);
if((state_val_28635 === (7))){
var inst_28630 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
var statearr_28636_28664 = state_28634__$1;
(statearr_28636_28664[(2)] = inst_28630);

(statearr_28636_28664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (1))){
var state_28634__$1 = state_28634;
var statearr_28637_28665 = state_28634__$1;
(statearr_28637_28665[(2)] = null);

(statearr_28637_28665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (4))){
var inst_28611 = (state_28634[(7)]);
var inst_28611__$1 = (state_28634[(2)]);
var inst_28612 = (inst_28611__$1 == null);
var state_28634__$1 = (function (){var statearr_28638 = state_28634;
(statearr_28638[(7)] = inst_28611__$1);

return statearr_28638;
})();
if(cljs.core.truth_(inst_28612)){
var statearr_28639_28666 = state_28634__$1;
(statearr_28639_28666[(1)] = (5));

} else {
var statearr_28640_28667 = state_28634__$1;
(statearr_28640_28667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (13))){
var state_28634__$1 = state_28634;
var statearr_28641_28668 = state_28634__$1;
(statearr_28641_28668[(2)] = null);

(statearr_28641_28668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (6))){
var inst_28611 = (state_28634[(7)]);
var inst_28617 = p.call(null,inst_28611);
var state_28634__$1 = state_28634;
if(cljs.core.truth_(inst_28617)){
var statearr_28642_28669 = state_28634__$1;
(statearr_28642_28669[(1)] = (9));

} else {
var statearr_28643_28670 = state_28634__$1;
(statearr_28643_28670[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (3))){
var inst_28632 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28634__$1,inst_28632);
} else {
if((state_val_28635 === (12))){
var state_28634__$1 = state_28634;
var statearr_28644_28671 = state_28634__$1;
(statearr_28644_28671[(2)] = null);

(statearr_28644_28671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (2))){
var state_28634__$1 = state_28634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28634__$1,(4),ch);
} else {
if((state_val_28635 === (11))){
var inst_28611 = (state_28634[(7)]);
var inst_28621 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28634__$1,(8),inst_28621,inst_28611);
} else {
if((state_val_28635 === (9))){
var state_28634__$1 = state_28634;
var statearr_28645_28672 = state_28634__$1;
(statearr_28645_28672[(2)] = tc);

(statearr_28645_28672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (5))){
var inst_28614 = cljs.core.async.close_BANG_.call(null,tc);
var inst_28615 = cljs.core.async.close_BANG_.call(null,fc);
var state_28634__$1 = (function (){var statearr_28646 = state_28634;
(statearr_28646[(8)] = inst_28614);

return statearr_28646;
})();
var statearr_28647_28673 = state_28634__$1;
(statearr_28647_28673[(2)] = inst_28615);

(statearr_28647_28673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (14))){
var inst_28628 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
var statearr_28648_28674 = state_28634__$1;
(statearr_28648_28674[(2)] = inst_28628);

(statearr_28648_28674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (10))){
var state_28634__$1 = state_28634;
var statearr_28649_28675 = state_28634__$1;
(statearr_28649_28675[(2)] = fc);

(statearr_28649_28675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (8))){
var inst_28623 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
if(cljs.core.truth_(inst_28623)){
var statearr_28650_28676 = state_28634__$1;
(statearr_28650_28676[(1)] = (12));

} else {
var statearr_28651_28677 = state_28634__$1;
(statearr_28651_28677[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___28663,tc,fc))
;
return ((function (switch__27865__auto__,c__27977__auto___28663,tc,fc){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_28655 = [null,null,null,null,null,null,null,null,null];
(statearr_28655[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_28655[(1)] = (1));

return statearr_28655;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_28634){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28656){if((e28656 instanceof Object)){
var ex__27869__auto__ = e28656;
var statearr_28657_28678 = state_28634;
(statearr_28657_28678[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28634);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28679 = state_28634;
state_28634 = G__28679;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_28634){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_28634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___28663,tc,fc))
})();
var state__27979__auto__ = (function (){var statearr_28658 = f__27978__auto__.call(null);
(statearr_28658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___28663);

return statearr_28658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___28663,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__){
return (function (state_28743){
var state_val_28744 = (state_28743[(1)]);
if((state_val_28744 === (7))){
var inst_28739 = (state_28743[(2)]);
var state_28743__$1 = state_28743;
var statearr_28745_28766 = state_28743__$1;
(statearr_28745_28766[(2)] = inst_28739);

(statearr_28745_28766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (1))){
var inst_28723 = init;
var state_28743__$1 = (function (){var statearr_28746 = state_28743;
(statearr_28746[(7)] = inst_28723);

return statearr_28746;
})();
var statearr_28747_28767 = state_28743__$1;
(statearr_28747_28767[(2)] = null);

(statearr_28747_28767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (4))){
var inst_28726 = (state_28743[(8)]);
var inst_28726__$1 = (state_28743[(2)]);
var inst_28727 = (inst_28726__$1 == null);
var state_28743__$1 = (function (){var statearr_28748 = state_28743;
(statearr_28748[(8)] = inst_28726__$1);

return statearr_28748;
})();
if(cljs.core.truth_(inst_28727)){
var statearr_28749_28768 = state_28743__$1;
(statearr_28749_28768[(1)] = (5));

} else {
var statearr_28750_28769 = state_28743__$1;
(statearr_28750_28769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (6))){
var inst_28723 = (state_28743[(7)]);
var inst_28726 = (state_28743[(8)]);
var inst_28730 = (state_28743[(9)]);
var inst_28730__$1 = f.call(null,inst_28723,inst_28726);
var inst_28731 = cljs.core.reduced_QMARK_.call(null,inst_28730__$1);
var state_28743__$1 = (function (){var statearr_28751 = state_28743;
(statearr_28751[(9)] = inst_28730__$1);

return statearr_28751;
})();
if(inst_28731){
var statearr_28752_28770 = state_28743__$1;
(statearr_28752_28770[(1)] = (8));

} else {
var statearr_28753_28771 = state_28743__$1;
(statearr_28753_28771[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (3))){
var inst_28741 = (state_28743[(2)]);
var state_28743__$1 = state_28743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28743__$1,inst_28741);
} else {
if((state_val_28744 === (2))){
var state_28743__$1 = state_28743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28743__$1,(4),ch);
} else {
if((state_val_28744 === (9))){
var inst_28730 = (state_28743[(9)]);
var inst_28723 = inst_28730;
var state_28743__$1 = (function (){var statearr_28754 = state_28743;
(statearr_28754[(7)] = inst_28723);

return statearr_28754;
})();
var statearr_28755_28772 = state_28743__$1;
(statearr_28755_28772[(2)] = null);

(statearr_28755_28772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (5))){
var inst_28723 = (state_28743[(7)]);
var state_28743__$1 = state_28743;
var statearr_28756_28773 = state_28743__$1;
(statearr_28756_28773[(2)] = inst_28723);

(statearr_28756_28773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (10))){
var inst_28737 = (state_28743[(2)]);
var state_28743__$1 = state_28743;
var statearr_28757_28774 = state_28743__$1;
(statearr_28757_28774[(2)] = inst_28737);

(statearr_28757_28774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28744 === (8))){
var inst_28730 = (state_28743[(9)]);
var inst_28733 = cljs.core.deref.call(null,inst_28730);
var state_28743__$1 = state_28743;
var statearr_28758_28775 = state_28743__$1;
(statearr_28758_28775[(2)] = inst_28733);

(statearr_28758_28775[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__))
;
return ((function (switch__27865__auto__,c__27977__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__27866__auto__ = null;
var cljs$core$async$reduce_$_state_machine__27866__auto____0 = (function (){
var statearr_28762 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28762[(0)] = cljs$core$async$reduce_$_state_machine__27866__auto__);

(statearr_28762[(1)] = (1));

return statearr_28762;
});
var cljs$core$async$reduce_$_state_machine__27866__auto____1 = (function (state_28743){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28763){if((e28763 instanceof Object)){
var ex__27869__auto__ = e28763;
var statearr_28764_28776 = state_28743;
(statearr_28764_28776[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28763;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28777 = state_28743;
state_28743 = G__28777;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__27866__auto__ = function(state_28743){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__27866__auto____1.call(this,state_28743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__27866__auto____0;
cljs$core$async$reduce_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__27866__auto____1;
return cljs$core$async$reduce_$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__))
})();
var state__27979__auto__ = (function (){var statearr_28765 = f__27978__auto__.call(null);
(statearr_28765[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_28765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__))
);

return c__27977__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args28778 = [];
var len__25820__auto___28830 = arguments.length;
var i__25821__auto___28831 = (0);
while(true){
if((i__25821__auto___28831 < len__25820__auto___28830)){
args28778.push((arguments[i__25821__auto___28831]));

var G__28832 = (i__25821__auto___28831 + (1));
i__25821__auto___28831 = G__28832;
continue;
} else {
}
break;
}

var G__28780 = args28778.length;
switch (G__28780) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28778.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__){
return (function (state_28805){
var state_val_28806 = (state_28805[(1)]);
if((state_val_28806 === (7))){
var inst_28787 = (state_28805[(2)]);
var state_28805__$1 = state_28805;
var statearr_28807_28834 = state_28805__$1;
(statearr_28807_28834[(2)] = inst_28787);

(statearr_28807_28834[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (1))){
var inst_28781 = cljs.core.seq.call(null,coll);
var inst_28782 = inst_28781;
var state_28805__$1 = (function (){var statearr_28808 = state_28805;
(statearr_28808[(7)] = inst_28782);

return statearr_28808;
})();
var statearr_28809_28835 = state_28805__$1;
(statearr_28809_28835[(2)] = null);

(statearr_28809_28835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (4))){
var inst_28782 = (state_28805[(7)]);
var inst_28785 = cljs.core.first.call(null,inst_28782);
var state_28805__$1 = state_28805;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28805__$1,(7),ch,inst_28785);
} else {
if((state_val_28806 === (13))){
var inst_28799 = (state_28805[(2)]);
var state_28805__$1 = state_28805;
var statearr_28810_28836 = state_28805__$1;
(statearr_28810_28836[(2)] = inst_28799);

(statearr_28810_28836[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (6))){
var inst_28790 = (state_28805[(2)]);
var state_28805__$1 = state_28805;
if(cljs.core.truth_(inst_28790)){
var statearr_28811_28837 = state_28805__$1;
(statearr_28811_28837[(1)] = (8));

} else {
var statearr_28812_28838 = state_28805__$1;
(statearr_28812_28838[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (3))){
var inst_28803 = (state_28805[(2)]);
var state_28805__$1 = state_28805;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28805__$1,inst_28803);
} else {
if((state_val_28806 === (12))){
var state_28805__$1 = state_28805;
var statearr_28813_28839 = state_28805__$1;
(statearr_28813_28839[(2)] = null);

(statearr_28813_28839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (2))){
var inst_28782 = (state_28805[(7)]);
var state_28805__$1 = state_28805;
if(cljs.core.truth_(inst_28782)){
var statearr_28814_28840 = state_28805__$1;
(statearr_28814_28840[(1)] = (4));

} else {
var statearr_28815_28841 = state_28805__$1;
(statearr_28815_28841[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (11))){
var inst_28796 = cljs.core.async.close_BANG_.call(null,ch);
var state_28805__$1 = state_28805;
var statearr_28816_28842 = state_28805__$1;
(statearr_28816_28842[(2)] = inst_28796);

(statearr_28816_28842[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (9))){
var state_28805__$1 = state_28805;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28817_28843 = state_28805__$1;
(statearr_28817_28843[(1)] = (11));

} else {
var statearr_28818_28844 = state_28805__$1;
(statearr_28818_28844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (5))){
var inst_28782 = (state_28805[(7)]);
var state_28805__$1 = state_28805;
var statearr_28819_28845 = state_28805__$1;
(statearr_28819_28845[(2)] = inst_28782);

(statearr_28819_28845[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (10))){
var inst_28801 = (state_28805[(2)]);
var state_28805__$1 = state_28805;
var statearr_28820_28846 = state_28805__$1;
(statearr_28820_28846[(2)] = inst_28801);

(statearr_28820_28846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28806 === (8))){
var inst_28782 = (state_28805[(7)]);
var inst_28792 = cljs.core.next.call(null,inst_28782);
var inst_28782__$1 = inst_28792;
var state_28805__$1 = (function (){var statearr_28821 = state_28805;
(statearr_28821[(7)] = inst_28782__$1);

return statearr_28821;
})();
var statearr_28822_28847 = state_28805__$1;
(statearr_28822_28847[(2)] = null);

(statearr_28822_28847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__))
;
return ((function (switch__27865__auto__,c__27977__auto__){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_28826 = [null,null,null,null,null,null,null,null];
(statearr_28826[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_28826[(1)] = (1));

return statearr_28826;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_28805){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_28805);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e28827){if((e28827 instanceof Object)){
var ex__27869__auto__ = e28827;
var statearr_28828_28848 = state_28805;
(statearr_28828_28848[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28805);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28849 = state_28805;
state_28805 = G__28849;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_28805){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_28805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__))
})();
var state__27979__auto__ = (function (){var statearr_28829 = f__27978__auto__.call(null);
(statearr_28829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_28829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__))
);

return c__27977__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__25408__auto__ = (((_ == null))?null:_);
var m__25409__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,_);
} else {
var m__25409__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__25409__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,ch);
} else {
var m__25409__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m);
} else {
var m__25409__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async29075 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29075 = (function (mult,ch,cs,meta29076){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta29076 = meta29076;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_29077,meta29076__$1){
var self__ = this;
var _29077__$1 = this;
return (new cljs.core.async.t_cljs$core$async29075(self__.mult,self__.ch,self__.cs,meta29076__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_29077){
var self__ = this;
var _29077__$1 = this;
return self__.meta29076;
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29076","meta29076",-1364350317,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async29075.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29075.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29075";

cljs.core.async.t_cljs$core$async29075.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async29075");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async29075 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async29075(mult__$1,ch__$1,cs__$1,meta29076){
return (new cljs.core.async.t_cljs$core$async29075(mult__$1,ch__$1,cs__$1,meta29076));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async29075(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__27977__auto___29300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___29300,cs,m,dchan,dctr,done){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___29300,cs,m,dchan,dctr,done){
return (function (state_29212){
var state_val_29213 = (state_29212[(1)]);
if((state_val_29213 === (7))){
var inst_29208 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29214_29301 = state_29212__$1;
(statearr_29214_29301[(2)] = inst_29208);

(statearr_29214_29301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (20))){
var inst_29111 = (state_29212[(7)]);
var inst_29123 = cljs.core.first.call(null,inst_29111);
var inst_29124 = cljs.core.nth.call(null,inst_29123,(0),null);
var inst_29125 = cljs.core.nth.call(null,inst_29123,(1),null);
var state_29212__$1 = (function (){var statearr_29215 = state_29212;
(statearr_29215[(8)] = inst_29124);

return statearr_29215;
})();
if(cljs.core.truth_(inst_29125)){
var statearr_29216_29302 = state_29212__$1;
(statearr_29216_29302[(1)] = (22));

} else {
var statearr_29217_29303 = state_29212__$1;
(statearr_29217_29303[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (27))){
var inst_29155 = (state_29212[(9)]);
var inst_29153 = (state_29212[(10)]);
var inst_29080 = (state_29212[(11)]);
var inst_29160 = (state_29212[(12)]);
var inst_29160__$1 = cljs.core._nth.call(null,inst_29153,inst_29155);
var inst_29161 = cljs.core.async.put_BANG_.call(null,inst_29160__$1,inst_29080,done);
var state_29212__$1 = (function (){var statearr_29218 = state_29212;
(statearr_29218[(12)] = inst_29160__$1);

return statearr_29218;
})();
if(cljs.core.truth_(inst_29161)){
var statearr_29219_29304 = state_29212__$1;
(statearr_29219_29304[(1)] = (30));

} else {
var statearr_29220_29305 = state_29212__$1;
(statearr_29220_29305[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (1))){
var state_29212__$1 = state_29212;
var statearr_29221_29306 = state_29212__$1;
(statearr_29221_29306[(2)] = null);

(statearr_29221_29306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (24))){
var inst_29111 = (state_29212[(7)]);
var inst_29130 = (state_29212[(2)]);
var inst_29131 = cljs.core.next.call(null,inst_29111);
var inst_29089 = inst_29131;
var inst_29090 = null;
var inst_29091 = (0);
var inst_29092 = (0);
var state_29212__$1 = (function (){var statearr_29222 = state_29212;
(statearr_29222[(13)] = inst_29130);

(statearr_29222[(14)] = inst_29091);

(statearr_29222[(15)] = inst_29090);

(statearr_29222[(16)] = inst_29089);

(statearr_29222[(17)] = inst_29092);

return statearr_29222;
})();
var statearr_29223_29307 = state_29212__$1;
(statearr_29223_29307[(2)] = null);

(statearr_29223_29307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (39))){
var state_29212__$1 = state_29212;
var statearr_29227_29308 = state_29212__$1;
(statearr_29227_29308[(2)] = null);

(statearr_29227_29308[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (4))){
var inst_29080 = (state_29212[(11)]);
var inst_29080__$1 = (state_29212[(2)]);
var inst_29081 = (inst_29080__$1 == null);
var state_29212__$1 = (function (){var statearr_29228 = state_29212;
(statearr_29228[(11)] = inst_29080__$1);

return statearr_29228;
})();
if(cljs.core.truth_(inst_29081)){
var statearr_29229_29309 = state_29212__$1;
(statearr_29229_29309[(1)] = (5));

} else {
var statearr_29230_29310 = state_29212__$1;
(statearr_29230_29310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (15))){
var inst_29091 = (state_29212[(14)]);
var inst_29090 = (state_29212[(15)]);
var inst_29089 = (state_29212[(16)]);
var inst_29092 = (state_29212[(17)]);
var inst_29107 = (state_29212[(2)]);
var inst_29108 = (inst_29092 + (1));
var tmp29224 = inst_29091;
var tmp29225 = inst_29090;
var tmp29226 = inst_29089;
var inst_29089__$1 = tmp29226;
var inst_29090__$1 = tmp29225;
var inst_29091__$1 = tmp29224;
var inst_29092__$1 = inst_29108;
var state_29212__$1 = (function (){var statearr_29231 = state_29212;
(statearr_29231[(18)] = inst_29107);

(statearr_29231[(14)] = inst_29091__$1);

(statearr_29231[(15)] = inst_29090__$1);

(statearr_29231[(16)] = inst_29089__$1);

(statearr_29231[(17)] = inst_29092__$1);

return statearr_29231;
})();
var statearr_29232_29311 = state_29212__$1;
(statearr_29232_29311[(2)] = null);

(statearr_29232_29311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (21))){
var inst_29134 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29236_29312 = state_29212__$1;
(statearr_29236_29312[(2)] = inst_29134);

(statearr_29236_29312[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (31))){
var inst_29160 = (state_29212[(12)]);
var inst_29164 = done.call(null,null);
var inst_29165 = cljs.core.async.untap_STAR_.call(null,m,inst_29160);
var state_29212__$1 = (function (){var statearr_29237 = state_29212;
(statearr_29237[(19)] = inst_29164);

return statearr_29237;
})();
var statearr_29238_29313 = state_29212__$1;
(statearr_29238_29313[(2)] = inst_29165);

(statearr_29238_29313[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (32))){
var inst_29155 = (state_29212[(9)]);
var inst_29152 = (state_29212[(20)]);
var inst_29153 = (state_29212[(10)]);
var inst_29154 = (state_29212[(21)]);
var inst_29167 = (state_29212[(2)]);
var inst_29168 = (inst_29155 + (1));
var tmp29233 = inst_29152;
var tmp29234 = inst_29153;
var tmp29235 = inst_29154;
var inst_29152__$1 = tmp29233;
var inst_29153__$1 = tmp29234;
var inst_29154__$1 = tmp29235;
var inst_29155__$1 = inst_29168;
var state_29212__$1 = (function (){var statearr_29239 = state_29212;
(statearr_29239[(9)] = inst_29155__$1);

(statearr_29239[(20)] = inst_29152__$1);

(statearr_29239[(10)] = inst_29153__$1);

(statearr_29239[(21)] = inst_29154__$1);

(statearr_29239[(22)] = inst_29167);

return statearr_29239;
})();
var statearr_29240_29314 = state_29212__$1;
(statearr_29240_29314[(2)] = null);

(statearr_29240_29314[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (40))){
var inst_29180 = (state_29212[(23)]);
var inst_29184 = done.call(null,null);
var inst_29185 = cljs.core.async.untap_STAR_.call(null,m,inst_29180);
var state_29212__$1 = (function (){var statearr_29241 = state_29212;
(statearr_29241[(24)] = inst_29184);

return statearr_29241;
})();
var statearr_29242_29315 = state_29212__$1;
(statearr_29242_29315[(2)] = inst_29185);

(statearr_29242_29315[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (33))){
var inst_29171 = (state_29212[(25)]);
var inst_29173 = cljs.core.chunked_seq_QMARK_.call(null,inst_29171);
var state_29212__$1 = state_29212;
if(inst_29173){
var statearr_29243_29316 = state_29212__$1;
(statearr_29243_29316[(1)] = (36));

} else {
var statearr_29244_29317 = state_29212__$1;
(statearr_29244_29317[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (13))){
var inst_29101 = (state_29212[(26)]);
var inst_29104 = cljs.core.async.close_BANG_.call(null,inst_29101);
var state_29212__$1 = state_29212;
var statearr_29245_29318 = state_29212__$1;
(statearr_29245_29318[(2)] = inst_29104);

(statearr_29245_29318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (22))){
var inst_29124 = (state_29212[(8)]);
var inst_29127 = cljs.core.async.close_BANG_.call(null,inst_29124);
var state_29212__$1 = state_29212;
var statearr_29246_29319 = state_29212__$1;
(statearr_29246_29319[(2)] = inst_29127);

(statearr_29246_29319[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (36))){
var inst_29171 = (state_29212[(25)]);
var inst_29175 = cljs.core.chunk_first.call(null,inst_29171);
var inst_29176 = cljs.core.chunk_rest.call(null,inst_29171);
var inst_29177 = cljs.core.count.call(null,inst_29175);
var inst_29152 = inst_29176;
var inst_29153 = inst_29175;
var inst_29154 = inst_29177;
var inst_29155 = (0);
var state_29212__$1 = (function (){var statearr_29247 = state_29212;
(statearr_29247[(9)] = inst_29155);

(statearr_29247[(20)] = inst_29152);

(statearr_29247[(10)] = inst_29153);

(statearr_29247[(21)] = inst_29154);

return statearr_29247;
})();
var statearr_29248_29320 = state_29212__$1;
(statearr_29248_29320[(2)] = null);

(statearr_29248_29320[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (41))){
var inst_29171 = (state_29212[(25)]);
var inst_29187 = (state_29212[(2)]);
var inst_29188 = cljs.core.next.call(null,inst_29171);
var inst_29152 = inst_29188;
var inst_29153 = null;
var inst_29154 = (0);
var inst_29155 = (0);
var state_29212__$1 = (function (){var statearr_29249 = state_29212;
(statearr_29249[(9)] = inst_29155);

(statearr_29249[(27)] = inst_29187);

(statearr_29249[(20)] = inst_29152);

(statearr_29249[(10)] = inst_29153);

(statearr_29249[(21)] = inst_29154);

return statearr_29249;
})();
var statearr_29250_29321 = state_29212__$1;
(statearr_29250_29321[(2)] = null);

(statearr_29250_29321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (43))){
var state_29212__$1 = state_29212;
var statearr_29251_29322 = state_29212__$1;
(statearr_29251_29322[(2)] = null);

(statearr_29251_29322[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (29))){
var inst_29196 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29252_29323 = state_29212__$1;
(statearr_29252_29323[(2)] = inst_29196);

(statearr_29252_29323[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (44))){
var inst_29205 = (state_29212[(2)]);
var state_29212__$1 = (function (){var statearr_29253 = state_29212;
(statearr_29253[(28)] = inst_29205);

return statearr_29253;
})();
var statearr_29254_29324 = state_29212__$1;
(statearr_29254_29324[(2)] = null);

(statearr_29254_29324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (6))){
var inst_29144 = (state_29212[(29)]);
var inst_29143 = cljs.core.deref.call(null,cs);
var inst_29144__$1 = cljs.core.keys.call(null,inst_29143);
var inst_29145 = cljs.core.count.call(null,inst_29144__$1);
var inst_29146 = cljs.core.reset_BANG_.call(null,dctr,inst_29145);
var inst_29151 = cljs.core.seq.call(null,inst_29144__$1);
var inst_29152 = inst_29151;
var inst_29153 = null;
var inst_29154 = (0);
var inst_29155 = (0);
var state_29212__$1 = (function (){var statearr_29255 = state_29212;
(statearr_29255[(9)] = inst_29155);

(statearr_29255[(30)] = inst_29146);

(statearr_29255[(20)] = inst_29152);

(statearr_29255[(10)] = inst_29153);

(statearr_29255[(21)] = inst_29154);

(statearr_29255[(29)] = inst_29144__$1);

return statearr_29255;
})();
var statearr_29256_29325 = state_29212__$1;
(statearr_29256_29325[(2)] = null);

(statearr_29256_29325[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (28))){
var inst_29171 = (state_29212[(25)]);
var inst_29152 = (state_29212[(20)]);
var inst_29171__$1 = cljs.core.seq.call(null,inst_29152);
var state_29212__$1 = (function (){var statearr_29257 = state_29212;
(statearr_29257[(25)] = inst_29171__$1);

return statearr_29257;
})();
if(inst_29171__$1){
var statearr_29258_29326 = state_29212__$1;
(statearr_29258_29326[(1)] = (33));

} else {
var statearr_29259_29327 = state_29212__$1;
(statearr_29259_29327[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (25))){
var inst_29155 = (state_29212[(9)]);
var inst_29154 = (state_29212[(21)]);
var inst_29157 = (inst_29155 < inst_29154);
var inst_29158 = inst_29157;
var state_29212__$1 = state_29212;
if(cljs.core.truth_(inst_29158)){
var statearr_29260_29328 = state_29212__$1;
(statearr_29260_29328[(1)] = (27));

} else {
var statearr_29261_29329 = state_29212__$1;
(statearr_29261_29329[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (34))){
var state_29212__$1 = state_29212;
var statearr_29262_29330 = state_29212__$1;
(statearr_29262_29330[(2)] = null);

(statearr_29262_29330[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (17))){
var state_29212__$1 = state_29212;
var statearr_29263_29331 = state_29212__$1;
(statearr_29263_29331[(2)] = null);

(statearr_29263_29331[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (3))){
var inst_29210 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29212__$1,inst_29210);
} else {
if((state_val_29213 === (12))){
var inst_29139 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29264_29332 = state_29212__$1;
(statearr_29264_29332[(2)] = inst_29139);

(statearr_29264_29332[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (2))){
var state_29212__$1 = state_29212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29212__$1,(4),ch);
} else {
if((state_val_29213 === (23))){
var state_29212__$1 = state_29212;
var statearr_29265_29333 = state_29212__$1;
(statearr_29265_29333[(2)] = null);

(statearr_29265_29333[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (35))){
var inst_29194 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29266_29334 = state_29212__$1;
(statearr_29266_29334[(2)] = inst_29194);

(statearr_29266_29334[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (19))){
var inst_29111 = (state_29212[(7)]);
var inst_29115 = cljs.core.chunk_first.call(null,inst_29111);
var inst_29116 = cljs.core.chunk_rest.call(null,inst_29111);
var inst_29117 = cljs.core.count.call(null,inst_29115);
var inst_29089 = inst_29116;
var inst_29090 = inst_29115;
var inst_29091 = inst_29117;
var inst_29092 = (0);
var state_29212__$1 = (function (){var statearr_29267 = state_29212;
(statearr_29267[(14)] = inst_29091);

(statearr_29267[(15)] = inst_29090);

(statearr_29267[(16)] = inst_29089);

(statearr_29267[(17)] = inst_29092);

return statearr_29267;
})();
var statearr_29268_29335 = state_29212__$1;
(statearr_29268_29335[(2)] = null);

(statearr_29268_29335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (11))){
var inst_29111 = (state_29212[(7)]);
var inst_29089 = (state_29212[(16)]);
var inst_29111__$1 = cljs.core.seq.call(null,inst_29089);
var state_29212__$1 = (function (){var statearr_29269 = state_29212;
(statearr_29269[(7)] = inst_29111__$1);

return statearr_29269;
})();
if(inst_29111__$1){
var statearr_29270_29336 = state_29212__$1;
(statearr_29270_29336[(1)] = (16));

} else {
var statearr_29271_29337 = state_29212__$1;
(statearr_29271_29337[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (9))){
var inst_29141 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29272_29338 = state_29212__$1;
(statearr_29272_29338[(2)] = inst_29141);

(statearr_29272_29338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (5))){
var inst_29087 = cljs.core.deref.call(null,cs);
var inst_29088 = cljs.core.seq.call(null,inst_29087);
var inst_29089 = inst_29088;
var inst_29090 = null;
var inst_29091 = (0);
var inst_29092 = (0);
var state_29212__$1 = (function (){var statearr_29273 = state_29212;
(statearr_29273[(14)] = inst_29091);

(statearr_29273[(15)] = inst_29090);

(statearr_29273[(16)] = inst_29089);

(statearr_29273[(17)] = inst_29092);

return statearr_29273;
})();
var statearr_29274_29339 = state_29212__$1;
(statearr_29274_29339[(2)] = null);

(statearr_29274_29339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (14))){
var state_29212__$1 = state_29212;
var statearr_29275_29340 = state_29212__$1;
(statearr_29275_29340[(2)] = null);

(statearr_29275_29340[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (45))){
var inst_29202 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29276_29341 = state_29212__$1;
(statearr_29276_29341[(2)] = inst_29202);

(statearr_29276_29341[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (26))){
var inst_29144 = (state_29212[(29)]);
var inst_29198 = (state_29212[(2)]);
var inst_29199 = cljs.core.seq.call(null,inst_29144);
var state_29212__$1 = (function (){var statearr_29277 = state_29212;
(statearr_29277[(31)] = inst_29198);

return statearr_29277;
})();
if(inst_29199){
var statearr_29278_29342 = state_29212__$1;
(statearr_29278_29342[(1)] = (42));

} else {
var statearr_29279_29343 = state_29212__$1;
(statearr_29279_29343[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (16))){
var inst_29111 = (state_29212[(7)]);
var inst_29113 = cljs.core.chunked_seq_QMARK_.call(null,inst_29111);
var state_29212__$1 = state_29212;
if(inst_29113){
var statearr_29280_29344 = state_29212__$1;
(statearr_29280_29344[(1)] = (19));

} else {
var statearr_29281_29345 = state_29212__$1;
(statearr_29281_29345[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (38))){
var inst_29191 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29282_29346 = state_29212__$1;
(statearr_29282_29346[(2)] = inst_29191);

(statearr_29282_29346[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (30))){
var state_29212__$1 = state_29212;
var statearr_29283_29347 = state_29212__$1;
(statearr_29283_29347[(2)] = null);

(statearr_29283_29347[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (10))){
var inst_29090 = (state_29212[(15)]);
var inst_29092 = (state_29212[(17)]);
var inst_29100 = cljs.core._nth.call(null,inst_29090,inst_29092);
var inst_29101 = cljs.core.nth.call(null,inst_29100,(0),null);
var inst_29102 = cljs.core.nth.call(null,inst_29100,(1),null);
var state_29212__$1 = (function (){var statearr_29284 = state_29212;
(statearr_29284[(26)] = inst_29101);

return statearr_29284;
})();
if(cljs.core.truth_(inst_29102)){
var statearr_29285_29348 = state_29212__$1;
(statearr_29285_29348[(1)] = (13));

} else {
var statearr_29286_29349 = state_29212__$1;
(statearr_29286_29349[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (18))){
var inst_29137 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29287_29350 = state_29212__$1;
(statearr_29287_29350[(2)] = inst_29137);

(statearr_29287_29350[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (42))){
var state_29212__$1 = state_29212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29212__$1,(45),dchan);
} else {
if((state_val_29213 === (37))){
var inst_29171 = (state_29212[(25)]);
var inst_29180 = (state_29212[(23)]);
var inst_29080 = (state_29212[(11)]);
var inst_29180__$1 = cljs.core.first.call(null,inst_29171);
var inst_29181 = cljs.core.async.put_BANG_.call(null,inst_29180__$1,inst_29080,done);
var state_29212__$1 = (function (){var statearr_29288 = state_29212;
(statearr_29288[(23)] = inst_29180__$1);

return statearr_29288;
})();
if(cljs.core.truth_(inst_29181)){
var statearr_29289_29351 = state_29212__$1;
(statearr_29289_29351[(1)] = (39));

} else {
var statearr_29290_29352 = state_29212__$1;
(statearr_29290_29352[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (8))){
var inst_29091 = (state_29212[(14)]);
var inst_29092 = (state_29212[(17)]);
var inst_29094 = (inst_29092 < inst_29091);
var inst_29095 = inst_29094;
var state_29212__$1 = state_29212;
if(cljs.core.truth_(inst_29095)){
var statearr_29291_29353 = state_29212__$1;
(statearr_29291_29353[(1)] = (10));

} else {
var statearr_29292_29354 = state_29212__$1;
(statearr_29292_29354[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___29300,cs,m,dchan,dctr,done))
;
return ((function (switch__27865__auto__,c__27977__auto___29300,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__27866__auto__ = null;
var cljs$core$async$mult_$_state_machine__27866__auto____0 = (function (){
var statearr_29296 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29296[(0)] = cljs$core$async$mult_$_state_machine__27866__auto__);

(statearr_29296[(1)] = (1));

return statearr_29296;
});
var cljs$core$async$mult_$_state_machine__27866__auto____1 = (function (state_29212){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_29212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e29297){if((e29297 instanceof Object)){
var ex__27869__auto__ = e29297;
var statearr_29298_29355 = state_29212;
(statearr_29298_29355[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29356 = state_29212;
state_29212 = G__29356;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__27866__auto__ = function(state_29212){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__27866__auto____1.call(this,state_29212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__27866__auto____0;
cljs$core$async$mult_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__27866__auto____1;
return cljs$core$async$mult_$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___29300,cs,m,dchan,dctr,done))
})();
var state__27979__auto__ = (function (){var statearr_29299 = f__27978__auto__.call(null);
(statearr_29299[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___29300);

return statearr_29299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___29300,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args29357 = [];
var len__25820__auto___29360 = arguments.length;
var i__25821__auto___29361 = (0);
while(true){
if((i__25821__auto___29361 < len__25820__auto___29360)){
args29357.push((arguments[i__25821__auto___29361]));

var G__29362 = (i__25821__auto___29361 + (1));
i__25821__auto___29361 = G__29362;
continue;
} else {
}
break;
}

var G__29359 = args29357.length;
switch (G__29359) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29357.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,ch);
} else {
var m__25409__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,ch);
} else {
var m__25409__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m);
} else {
var m__25409__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,state_map);
} else {
var m__25409__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__25408__auto__ = (((m == null))?null:m);
var m__25409__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,m,mode);
} else {
var m__25409__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__25827__auto__ = [];
var len__25820__auto___29374 = arguments.length;
var i__25821__auto___29375 = (0);
while(true){
if((i__25821__auto___29375 < len__25820__auto___29374)){
args__25827__auto__.push((arguments[i__25821__auto___29375]));

var G__29376 = (i__25821__auto___29375 + (1));
i__25821__auto___29375 = G__29376;
continue;
} else {
}
break;
}

var argseq__25828__auto__ = ((((3) < args__25827__auto__.length))?(new cljs.core.IndexedSeq(args__25827__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__25828__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29368){
var map__29369 = p__29368;
var map__29369__$1 = ((((!((map__29369 == null)))?((((map__29369.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29369.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29369):map__29369);
var opts = map__29369__$1;
var statearr_29371_29377 = state;
(statearr_29371_29377[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__29369,map__29369__$1,opts){
return (function (val){
var statearr_29372_29378 = state;
(statearr_29372_29378[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__29369,map__29369__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_29373_29379 = state;
(statearr_29373_29379[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29364){
var G__29365 = cljs.core.first.call(null,seq29364);
var seq29364__$1 = cljs.core.next.call(null,seq29364);
var G__29366 = cljs.core.first.call(null,seq29364__$1);
var seq29364__$2 = cljs.core.next.call(null,seq29364__$1);
var G__29367 = cljs.core.first.call(null,seq29364__$2);
var seq29364__$3 = cljs.core.next.call(null,seq29364__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29365,G__29366,G__29367,seq29364__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async29545 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29545 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29546){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29546 = meta29546;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29547,meta29546__$1){
var self__ = this;
var _29547__$1 = this;
return (new cljs.core.async.t_cljs$core$async29545(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29546__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29547){
var self__ = this;
var _29547__$1 = this;
return self__.meta29546;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29546","meta29546",1727645276,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29545.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29545.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29545";

cljs.core.async.t_cljs$core$async29545.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async29545");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async29545 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async29545(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29546){
return (new cljs.core.async.t_cljs$core$async29545(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29546));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async29545(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__27977__auto___29710 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_29647){
var state_val_29648 = (state_29647[(1)]);
if((state_val_29648 === (7))){
var inst_29563 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
var statearr_29649_29711 = state_29647__$1;
(statearr_29649_29711[(2)] = inst_29563);

(statearr_29649_29711[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (20))){
var inst_29575 = (state_29647[(7)]);
var state_29647__$1 = state_29647;
var statearr_29650_29712 = state_29647__$1;
(statearr_29650_29712[(2)] = inst_29575);

(statearr_29650_29712[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (27))){
var state_29647__$1 = state_29647;
var statearr_29651_29713 = state_29647__$1;
(statearr_29651_29713[(2)] = null);

(statearr_29651_29713[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (1))){
var inst_29551 = (state_29647[(8)]);
var inst_29551__$1 = calc_state.call(null);
var inst_29553 = (inst_29551__$1 == null);
var inst_29554 = cljs.core.not.call(null,inst_29553);
var state_29647__$1 = (function (){var statearr_29652 = state_29647;
(statearr_29652[(8)] = inst_29551__$1);

return statearr_29652;
})();
if(inst_29554){
var statearr_29653_29714 = state_29647__$1;
(statearr_29653_29714[(1)] = (2));

} else {
var statearr_29654_29715 = state_29647__$1;
(statearr_29654_29715[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (24))){
var inst_29598 = (state_29647[(9)]);
var inst_29607 = (state_29647[(10)]);
var inst_29621 = (state_29647[(11)]);
var inst_29621__$1 = inst_29598.call(null,inst_29607);
var state_29647__$1 = (function (){var statearr_29655 = state_29647;
(statearr_29655[(11)] = inst_29621__$1);

return statearr_29655;
})();
if(cljs.core.truth_(inst_29621__$1)){
var statearr_29656_29716 = state_29647__$1;
(statearr_29656_29716[(1)] = (29));

} else {
var statearr_29657_29717 = state_29647__$1;
(statearr_29657_29717[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (4))){
var inst_29566 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29566)){
var statearr_29658_29718 = state_29647__$1;
(statearr_29658_29718[(1)] = (8));

} else {
var statearr_29659_29719 = state_29647__$1;
(statearr_29659_29719[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (15))){
var inst_29592 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29592)){
var statearr_29660_29720 = state_29647__$1;
(statearr_29660_29720[(1)] = (19));

} else {
var statearr_29661_29721 = state_29647__$1;
(statearr_29661_29721[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (21))){
var inst_29597 = (state_29647[(12)]);
var inst_29597__$1 = (state_29647[(2)]);
var inst_29598 = cljs.core.get.call(null,inst_29597__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29599 = cljs.core.get.call(null,inst_29597__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29600 = cljs.core.get.call(null,inst_29597__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29647__$1 = (function (){var statearr_29662 = state_29647;
(statearr_29662[(13)] = inst_29599);

(statearr_29662[(9)] = inst_29598);

(statearr_29662[(12)] = inst_29597__$1);

return statearr_29662;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29647__$1,(22),inst_29600);
} else {
if((state_val_29648 === (31))){
var inst_29629 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29629)){
var statearr_29663_29722 = state_29647__$1;
(statearr_29663_29722[(1)] = (32));

} else {
var statearr_29664_29723 = state_29647__$1;
(statearr_29664_29723[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (32))){
var inst_29606 = (state_29647[(14)]);
var state_29647__$1 = state_29647;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29647__$1,(35),out,inst_29606);
} else {
if((state_val_29648 === (33))){
var inst_29597 = (state_29647[(12)]);
var inst_29575 = inst_29597;
var state_29647__$1 = (function (){var statearr_29665 = state_29647;
(statearr_29665[(7)] = inst_29575);

return statearr_29665;
})();
var statearr_29666_29724 = state_29647__$1;
(statearr_29666_29724[(2)] = null);

(statearr_29666_29724[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (13))){
var inst_29575 = (state_29647[(7)]);
var inst_29582 = inst_29575.cljs$lang$protocol_mask$partition0$;
var inst_29583 = (inst_29582 & (64));
var inst_29584 = inst_29575.cljs$core$ISeq$;
var inst_29585 = (inst_29583) || (inst_29584);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29585)){
var statearr_29667_29725 = state_29647__$1;
(statearr_29667_29725[(1)] = (16));

} else {
var statearr_29668_29726 = state_29647__$1;
(statearr_29668_29726[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (22))){
var inst_29606 = (state_29647[(14)]);
var inst_29607 = (state_29647[(10)]);
var inst_29605 = (state_29647[(2)]);
var inst_29606__$1 = cljs.core.nth.call(null,inst_29605,(0),null);
var inst_29607__$1 = cljs.core.nth.call(null,inst_29605,(1),null);
var inst_29608 = (inst_29606__$1 == null);
var inst_29609 = cljs.core._EQ_.call(null,inst_29607__$1,change);
var inst_29610 = (inst_29608) || (inst_29609);
var state_29647__$1 = (function (){var statearr_29669 = state_29647;
(statearr_29669[(14)] = inst_29606__$1);

(statearr_29669[(10)] = inst_29607__$1);

return statearr_29669;
})();
if(cljs.core.truth_(inst_29610)){
var statearr_29670_29727 = state_29647__$1;
(statearr_29670_29727[(1)] = (23));

} else {
var statearr_29671_29728 = state_29647__$1;
(statearr_29671_29728[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (36))){
var inst_29597 = (state_29647[(12)]);
var inst_29575 = inst_29597;
var state_29647__$1 = (function (){var statearr_29672 = state_29647;
(statearr_29672[(7)] = inst_29575);

return statearr_29672;
})();
var statearr_29673_29729 = state_29647__$1;
(statearr_29673_29729[(2)] = null);

(statearr_29673_29729[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (29))){
var inst_29621 = (state_29647[(11)]);
var state_29647__$1 = state_29647;
var statearr_29674_29730 = state_29647__$1;
(statearr_29674_29730[(2)] = inst_29621);

(statearr_29674_29730[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (6))){
var state_29647__$1 = state_29647;
var statearr_29675_29731 = state_29647__$1;
(statearr_29675_29731[(2)] = false);

(statearr_29675_29731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (28))){
var inst_29617 = (state_29647[(2)]);
var inst_29618 = calc_state.call(null);
var inst_29575 = inst_29618;
var state_29647__$1 = (function (){var statearr_29676 = state_29647;
(statearr_29676[(15)] = inst_29617);

(statearr_29676[(7)] = inst_29575);

return statearr_29676;
})();
var statearr_29677_29732 = state_29647__$1;
(statearr_29677_29732[(2)] = null);

(statearr_29677_29732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (25))){
var inst_29643 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
var statearr_29678_29733 = state_29647__$1;
(statearr_29678_29733[(2)] = inst_29643);

(statearr_29678_29733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (34))){
var inst_29641 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
var statearr_29679_29734 = state_29647__$1;
(statearr_29679_29734[(2)] = inst_29641);

(statearr_29679_29734[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (17))){
var state_29647__$1 = state_29647;
var statearr_29680_29735 = state_29647__$1;
(statearr_29680_29735[(2)] = false);

(statearr_29680_29735[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (3))){
var state_29647__$1 = state_29647;
var statearr_29681_29736 = state_29647__$1;
(statearr_29681_29736[(2)] = false);

(statearr_29681_29736[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (12))){
var inst_29645 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29647__$1,inst_29645);
} else {
if((state_val_29648 === (2))){
var inst_29551 = (state_29647[(8)]);
var inst_29556 = inst_29551.cljs$lang$protocol_mask$partition0$;
var inst_29557 = (inst_29556 & (64));
var inst_29558 = inst_29551.cljs$core$ISeq$;
var inst_29559 = (inst_29557) || (inst_29558);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29559)){
var statearr_29682_29737 = state_29647__$1;
(statearr_29682_29737[(1)] = (5));

} else {
var statearr_29683_29738 = state_29647__$1;
(statearr_29683_29738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (23))){
var inst_29606 = (state_29647[(14)]);
var inst_29612 = (inst_29606 == null);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29612)){
var statearr_29684_29739 = state_29647__$1;
(statearr_29684_29739[(1)] = (26));

} else {
var statearr_29685_29740 = state_29647__$1;
(statearr_29685_29740[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (35))){
var inst_29632 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
if(cljs.core.truth_(inst_29632)){
var statearr_29686_29741 = state_29647__$1;
(statearr_29686_29741[(1)] = (36));

} else {
var statearr_29687_29742 = state_29647__$1;
(statearr_29687_29742[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (19))){
var inst_29575 = (state_29647[(7)]);
var inst_29594 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29575);
var state_29647__$1 = state_29647;
var statearr_29688_29743 = state_29647__$1;
(statearr_29688_29743[(2)] = inst_29594);

(statearr_29688_29743[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (11))){
var inst_29575 = (state_29647[(7)]);
var inst_29579 = (inst_29575 == null);
var inst_29580 = cljs.core.not.call(null,inst_29579);
var state_29647__$1 = state_29647;
if(inst_29580){
var statearr_29689_29744 = state_29647__$1;
(statearr_29689_29744[(1)] = (13));

} else {
var statearr_29690_29745 = state_29647__$1;
(statearr_29690_29745[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (9))){
var inst_29551 = (state_29647[(8)]);
var state_29647__$1 = state_29647;
var statearr_29691_29746 = state_29647__$1;
(statearr_29691_29746[(2)] = inst_29551);

(statearr_29691_29746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (5))){
var state_29647__$1 = state_29647;
var statearr_29692_29747 = state_29647__$1;
(statearr_29692_29747[(2)] = true);

(statearr_29692_29747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (14))){
var state_29647__$1 = state_29647;
var statearr_29693_29748 = state_29647__$1;
(statearr_29693_29748[(2)] = false);

(statearr_29693_29748[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (26))){
var inst_29607 = (state_29647[(10)]);
var inst_29614 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_29607);
var state_29647__$1 = state_29647;
var statearr_29694_29749 = state_29647__$1;
(statearr_29694_29749[(2)] = inst_29614);

(statearr_29694_29749[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (16))){
var state_29647__$1 = state_29647;
var statearr_29695_29750 = state_29647__$1;
(statearr_29695_29750[(2)] = true);

(statearr_29695_29750[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (38))){
var inst_29637 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
var statearr_29696_29751 = state_29647__$1;
(statearr_29696_29751[(2)] = inst_29637);

(statearr_29696_29751[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (30))){
var inst_29599 = (state_29647[(13)]);
var inst_29598 = (state_29647[(9)]);
var inst_29607 = (state_29647[(10)]);
var inst_29624 = cljs.core.empty_QMARK_.call(null,inst_29598);
var inst_29625 = inst_29599.call(null,inst_29607);
var inst_29626 = cljs.core.not.call(null,inst_29625);
var inst_29627 = (inst_29624) && (inst_29626);
var state_29647__$1 = state_29647;
var statearr_29697_29752 = state_29647__$1;
(statearr_29697_29752[(2)] = inst_29627);

(statearr_29697_29752[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (10))){
var inst_29551 = (state_29647[(8)]);
var inst_29571 = (state_29647[(2)]);
var inst_29572 = cljs.core.get.call(null,inst_29571,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29573 = cljs.core.get.call(null,inst_29571,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29574 = cljs.core.get.call(null,inst_29571,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29575 = inst_29551;
var state_29647__$1 = (function (){var statearr_29698 = state_29647;
(statearr_29698[(7)] = inst_29575);

(statearr_29698[(16)] = inst_29572);

(statearr_29698[(17)] = inst_29573);

(statearr_29698[(18)] = inst_29574);

return statearr_29698;
})();
var statearr_29699_29753 = state_29647__$1;
(statearr_29699_29753[(2)] = null);

(statearr_29699_29753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (18))){
var inst_29589 = (state_29647[(2)]);
var state_29647__$1 = state_29647;
var statearr_29700_29754 = state_29647__$1;
(statearr_29700_29754[(2)] = inst_29589);

(statearr_29700_29754[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (37))){
var state_29647__$1 = state_29647;
var statearr_29701_29755 = state_29647__$1;
(statearr_29701_29755[(2)] = null);

(statearr_29701_29755[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29648 === (8))){
var inst_29551 = (state_29647[(8)]);
var inst_29568 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29551);
var state_29647__$1 = state_29647;
var statearr_29702_29756 = state_29647__$1;
(statearr_29702_29756[(2)] = inst_29568);

(statearr_29702_29756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__27865__auto__,c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__27866__auto__ = null;
var cljs$core$async$mix_$_state_machine__27866__auto____0 = (function (){
var statearr_29706 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29706[(0)] = cljs$core$async$mix_$_state_machine__27866__auto__);

(statearr_29706[(1)] = (1));

return statearr_29706;
});
var cljs$core$async$mix_$_state_machine__27866__auto____1 = (function (state_29647){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_29647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e29707){if((e29707 instanceof Object)){
var ex__27869__auto__ = e29707;
var statearr_29708_29757 = state_29647;
(statearr_29708_29757[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29647);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29707;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29758 = state_29647;
state_29647 = G__29758;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__27866__auto__ = function(state_29647){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__27866__auto____1.call(this,state_29647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__27866__auto____0;
cljs$core$async$mix_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__27866__auto____1;
return cljs$core$async$mix_$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__27979__auto__ = (function (){var statearr_29709 = f__27978__auto__.call(null);
(statearr_29709[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___29710);

return statearr_29709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___29710,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__25408__auto__ = (((p == null))?null:p);
var m__25409__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__25409__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__25408__auto__ = (((p == null))?null:p);
var m__25409__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,p,v,ch);
} else {
var m__25409__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args29759 = [];
var len__25820__auto___29762 = arguments.length;
var i__25821__auto___29763 = (0);
while(true){
if((i__25821__auto___29763 < len__25820__auto___29762)){
args29759.push((arguments[i__25821__auto___29763]));

var G__29764 = (i__25821__auto___29763 + (1));
i__25821__auto___29763 = G__29764;
continue;
} else {
}
break;
}

var G__29761 = args29759.length;
switch (G__29761) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29759.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__25408__auto__ = (((p == null))?null:p);
var m__25409__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,p);
} else {
var m__25409__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__25408__auto__ = (((p == null))?null:p);
var m__25409__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__25408__auto__)]);
if(!((m__25409__auto__ == null))){
return m__25409__auto__.call(null,p,v);
} else {
var m__25409__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__25409__auto____$1 == null))){
return m__25409__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args29767 = [];
var len__25820__auto___29892 = arguments.length;
var i__25821__auto___29893 = (0);
while(true){
if((i__25821__auto___29893 < len__25820__auto___29892)){
args29767.push((arguments[i__25821__auto___29893]));

var G__29894 = (i__25821__auto___29893 + (1));
i__25821__auto___29893 = G__29894;
continue;
} else {
}
break;
}

var G__29769 = args29767.length;
switch (G__29769) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29767.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__24745__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__24745__auto__,mults){
return (function (p1__29766_SHARP_){
if(cljs.core.truth_(p1__29766_SHARP_.call(null,topic))){
return p1__29766_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__29766_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__24745__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async29770 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29770 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29771){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29771 = meta29771;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_29772,meta29771__$1){
var self__ = this;
var _29772__$1 = this;
return (new cljs.core.async.t_cljs$core$async29770(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29771__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_29772){
var self__ = this;
var _29772__$1 = this;
return self__.meta29771;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29771","meta29771",1491791471,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29770.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29770.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29770";

cljs.core.async.t_cljs$core$async29770.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async29770");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async29770 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async29770(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29771){
return (new cljs.core.async.t_cljs$core$async29770(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29771));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async29770(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__27977__auto___29896 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___29896,mults,ensure_mult,p){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___29896,mults,ensure_mult,p){
return (function (state_29844){
var state_val_29845 = (state_29844[(1)]);
if((state_val_29845 === (7))){
var inst_29840 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29846_29897 = state_29844__$1;
(statearr_29846_29897[(2)] = inst_29840);

(statearr_29846_29897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (20))){
var state_29844__$1 = state_29844;
var statearr_29847_29898 = state_29844__$1;
(statearr_29847_29898[(2)] = null);

(statearr_29847_29898[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (1))){
var state_29844__$1 = state_29844;
var statearr_29848_29899 = state_29844__$1;
(statearr_29848_29899[(2)] = null);

(statearr_29848_29899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (24))){
var inst_29823 = (state_29844[(7)]);
var inst_29832 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_29823);
var state_29844__$1 = state_29844;
var statearr_29849_29900 = state_29844__$1;
(statearr_29849_29900[(2)] = inst_29832);

(statearr_29849_29900[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (4))){
var inst_29775 = (state_29844[(8)]);
var inst_29775__$1 = (state_29844[(2)]);
var inst_29776 = (inst_29775__$1 == null);
var state_29844__$1 = (function (){var statearr_29850 = state_29844;
(statearr_29850[(8)] = inst_29775__$1);

return statearr_29850;
})();
if(cljs.core.truth_(inst_29776)){
var statearr_29851_29901 = state_29844__$1;
(statearr_29851_29901[(1)] = (5));

} else {
var statearr_29852_29902 = state_29844__$1;
(statearr_29852_29902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (15))){
var inst_29817 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29853_29903 = state_29844__$1;
(statearr_29853_29903[(2)] = inst_29817);

(statearr_29853_29903[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (21))){
var inst_29837 = (state_29844[(2)]);
var state_29844__$1 = (function (){var statearr_29854 = state_29844;
(statearr_29854[(9)] = inst_29837);

return statearr_29854;
})();
var statearr_29855_29904 = state_29844__$1;
(statearr_29855_29904[(2)] = null);

(statearr_29855_29904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (13))){
var inst_29799 = (state_29844[(10)]);
var inst_29801 = cljs.core.chunked_seq_QMARK_.call(null,inst_29799);
var state_29844__$1 = state_29844;
if(inst_29801){
var statearr_29856_29905 = state_29844__$1;
(statearr_29856_29905[(1)] = (16));

} else {
var statearr_29857_29906 = state_29844__$1;
(statearr_29857_29906[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (22))){
var inst_29829 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
if(cljs.core.truth_(inst_29829)){
var statearr_29858_29907 = state_29844__$1;
(statearr_29858_29907[(1)] = (23));

} else {
var statearr_29859_29908 = state_29844__$1;
(statearr_29859_29908[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (6))){
var inst_29775 = (state_29844[(8)]);
var inst_29823 = (state_29844[(7)]);
var inst_29825 = (state_29844[(11)]);
var inst_29823__$1 = topic_fn.call(null,inst_29775);
var inst_29824 = cljs.core.deref.call(null,mults);
var inst_29825__$1 = cljs.core.get.call(null,inst_29824,inst_29823__$1);
var state_29844__$1 = (function (){var statearr_29860 = state_29844;
(statearr_29860[(7)] = inst_29823__$1);

(statearr_29860[(11)] = inst_29825__$1);

return statearr_29860;
})();
if(cljs.core.truth_(inst_29825__$1)){
var statearr_29861_29909 = state_29844__$1;
(statearr_29861_29909[(1)] = (19));

} else {
var statearr_29862_29910 = state_29844__$1;
(statearr_29862_29910[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (25))){
var inst_29834 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29863_29911 = state_29844__$1;
(statearr_29863_29911[(2)] = inst_29834);

(statearr_29863_29911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (17))){
var inst_29799 = (state_29844[(10)]);
var inst_29808 = cljs.core.first.call(null,inst_29799);
var inst_29809 = cljs.core.async.muxch_STAR_.call(null,inst_29808);
var inst_29810 = cljs.core.async.close_BANG_.call(null,inst_29809);
var inst_29811 = cljs.core.next.call(null,inst_29799);
var inst_29785 = inst_29811;
var inst_29786 = null;
var inst_29787 = (0);
var inst_29788 = (0);
var state_29844__$1 = (function (){var statearr_29864 = state_29844;
(statearr_29864[(12)] = inst_29788);

(statearr_29864[(13)] = inst_29810);

(statearr_29864[(14)] = inst_29787);

(statearr_29864[(15)] = inst_29785);

(statearr_29864[(16)] = inst_29786);

return statearr_29864;
})();
var statearr_29865_29912 = state_29844__$1;
(statearr_29865_29912[(2)] = null);

(statearr_29865_29912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (3))){
var inst_29842 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29844__$1,inst_29842);
} else {
if((state_val_29845 === (12))){
var inst_29819 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29866_29913 = state_29844__$1;
(statearr_29866_29913[(2)] = inst_29819);

(statearr_29866_29913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (2))){
var state_29844__$1 = state_29844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29844__$1,(4),ch);
} else {
if((state_val_29845 === (23))){
var state_29844__$1 = state_29844;
var statearr_29867_29914 = state_29844__$1;
(statearr_29867_29914[(2)] = null);

(statearr_29867_29914[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (19))){
var inst_29775 = (state_29844[(8)]);
var inst_29825 = (state_29844[(11)]);
var inst_29827 = cljs.core.async.muxch_STAR_.call(null,inst_29825);
var state_29844__$1 = state_29844;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29844__$1,(22),inst_29827,inst_29775);
} else {
if((state_val_29845 === (11))){
var inst_29799 = (state_29844[(10)]);
var inst_29785 = (state_29844[(15)]);
var inst_29799__$1 = cljs.core.seq.call(null,inst_29785);
var state_29844__$1 = (function (){var statearr_29868 = state_29844;
(statearr_29868[(10)] = inst_29799__$1);

return statearr_29868;
})();
if(inst_29799__$1){
var statearr_29869_29915 = state_29844__$1;
(statearr_29869_29915[(1)] = (13));

} else {
var statearr_29870_29916 = state_29844__$1;
(statearr_29870_29916[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (9))){
var inst_29821 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29871_29917 = state_29844__$1;
(statearr_29871_29917[(2)] = inst_29821);

(statearr_29871_29917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (5))){
var inst_29782 = cljs.core.deref.call(null,mults);
var inst_29783 = cljs.core.vals.call(null,inst_29782);
var inst_29784 = cljs.core.seq.call(null,inst_29783);
var inst_29785 = inst_29784;
var inst_29786 = null;
var inst_29787 = (0);
var inst_29788 = (0);
var state_29844__$1 = (function (){var statearr_29872 = state_29844;
(statearr_29872[(12)] = inst_29788);

(statearr_29872[(14)] = inst_29787);

(statearr_29872[(15)] = inst_29785);

(statearr_29872[(16)] = inst_29786);

return statearr_29872;
})();
var statearr_29873_29918 = state_29844__$1;
(statearr_29873_29918[(2)] = null);

(statearr_29873_29918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (14))){
var state_29844__$1 = state_29844;
var statearr_29877_29919 = state_29844__$1;
(statearr_29877_29919[(2)] = null);

(statearr_29877_29919[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (16))){
var inst_29799 = (state_29844[(10)]);
var inst_29803 = cljs.core.chunk_first.call(null,inst_29799);
var inst_29804 = cljs.core.chunk_rest.call(null,inst_29799);
var inst_29805 = cljs.core.count.call(null,inst_29803);
var inst_29785 = inst_29804;
var inst_29786 = inst_29803;
var inst_29787 = inst_29805;
var inst_29788 = (0);
var state_29844__$1 = (function (){var statearr_29878 = state_29844;
(statearr_29878[(12)] = inst_29788);

(statearr_29878[(14)] = inst_29787);

(statearr_29878[(15)] = inst_29785);

(statearr_29878[(16)] = inst_29786);

return statearr_29878;
})();
var statearr_29879_29920 = state_29844__$1;
(statearr_29879_29920[(2)] = null);

(statearr_29879_29920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (10))){
var inst_29788 = (state_29844[(12)]);
var inst_29787 = (state_29844[(14)]);
var inst_29785 = (state_29844[(15)]);
var inst_29786 = (state_29844[(16)]);
var inst_29793 = cljs.core._nth.call(null,inst_29786,inst_29788);
var inst_29794 = cljs.core.async.muxch_STAR_.call(null,inst_29793);
var inst_29795 = cljs.core.async.close_BANG_.call(null,inst_29794);
var inst_29796 = (inst_29788 + (1));
var tmp29874 = inst_29787;
var tmp29875 = inst_29785;
var tmp29876 = inst_29786;
var inst_29785__$1 = tmp29875;
var inst_29786__$1 = tmp29876;
var inst_29787__$1 = tmp29874;
var inst_29788__$1 = inst_29796;
var state_29844__$1 = (function (){var statearr_29880 = state_29844;
(statearr_29880[(12)] = inst_29788__$1);

(statearr_29880[(17)] = inst_29795);

(statearr_29880[(14)] = inst_29787__$1);

(statearr_29880[(15)] = inst_29785__$1);

(statearr_29880[(16)] = inst_29786__$1);

return statearr_29880;
})();
var statearr_29881_29921 = state_29844__$1;
(statearr_29881_29921[(2)] = null);

(statearr_29881_29921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (18))){
var inst_29814 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29882_29922 = state_29844__$1;
(statearr_29882_29922[(2)] = inst_29814);

(statearr_29882_29922[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (8))){
var inst_29788 = (state_29844[(12)]);
var inst_29787 = (state_29844[(14)]);
var inst_29790 = (inst_29788 < inst_29787);
var inst_29791 = inst_29790;
var state_29844__$1 = state_29844;
if(cljs.core.truth_(inst_29791)){
var statearr_29883_29923 = state_29844__$1;
(statearr_29883_29923[(1)] = (10));

} else {
var statearr_29884_29924 = state_29844__$1;
(statearr_29884_29924[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___29896,mults,ensure_mult,p))
;
return ((function (switch__27865__auto__,c__27977__auto___29896,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_29888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29888[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_29888[(1)] = (1));

return statearr_29888;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_29844){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_29844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e29889){if((e29889 instanceof Object)){
var ex__27869__auto__ = e29889;
var statearr_29890_29925 = state_29844;
(statearr_29890_29925[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29844);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29926 = state_29844;
state_29844 = G__29926;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_29844){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_29844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___29896,mults,ensure_mult,p))
})();
var state__27979__auto__ = (function (){var statearr_29891 = f__27978__auto__.call(null);
(statearr_29891[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___29896);

return statearr_29891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___29896,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args29927 = [];
var len__25820__auto___29930 = arguments.length;
var i__25821__auto___29931 = (0);
while(true){
if((i__25821__auto___29931 < len__25820__auto___29930)){
args29927.push((arguments[i__25821__auto___29931]));

var G__29932 = (i__25821__auto___29931 + (1));
i__25821__auto___29931 = G__29932;
continue;
} else {
}
break;
}

var G__29929 = args29927.length;
switch (G__29929) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29927.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args29934 = [];
var len__25820__auto___29937 = arguments.length;
var i__25821__auto___29938 = (0);
while(true){
if((i__25821__auto___29938 < len__25820__auto___29937)){
args29934.push((arguments[i__25821__auto___29938]));

var G__29939 = (i__25821__auto___29938 + (1));
i__25821__auto___29938 = G__29939;
continue;
} else {
}
break;
}

var G__29936 = args29934.length;
switch (G__29936) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29934.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args29941 = [];
var len__25820__auto___30012 = arguments.length;
var i__25821__auto___30013 = (0);
while(true){
if((i__25821__auto___30013 < len__25820__auto___30012)){
args29941.push((arguments[i__25821__auto___30013]));

var G__30014 = (i__25821__auto___30013 + (1));
i__25821__auto___30013 = G__30014;
continue;
} else {
}
break;
}

var G__29943 = args29941.length;
switch (G__29943) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29941.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__27977__auto___30016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_29982){
var state_val_29983 = (state_29982[(1)]);
if((state_val_29983 === (7))){
var state_29982__$1 = state_29982;
var statearr_29984_30017 = state_29982__$1;
(statearr_29984_30017[(2)] = null);

(statearr_29984_30017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (1))){
var state_29982__$1 = state_29982;
var statearr_29985_30018 = state_29982__$1;
(statearr_29985_30018[(2)] = null);

(statearr_29985_30018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (4))){
var inst_29946 = (state_29982[(7)]);
var inst_29948 = (inst_29946 < cnt);
var state_29982__$1 = state_29982;
if(cljs.core.truth_(inst_29948)){
var statearr_29986_30019 = state_29982__$1;
(statearr_29986_30019[(1)] = (6));

} else {
var statearr_29987_30020 = state_29982__$1;
(statearr_29987_30020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (15))){
var inst_29978 = (state_29982[(2)]);
var state_29982__$1 = state_29982;
var statearr_29988_30021 = state_29982__$1;
(statearr_29988_30021[(2)] = inst_29978);

(statearr_29988_30021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (13))){
var inst_29971 = cljs.core.async.close_BANG_.call(null,out);
var state_29982__$1 = state_29982;
var statearr_29989_30022 = state_29982__$1;
(statearr_29989_30022[(2)] = inst_29971);

(statearr_29989_30022[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (6))){
var state_29982__$1 = state_29982;
var statearr_29990_30023 = state_29982__$1;
(statearr_29990_30023[(2)] = null);

(statearr_29990_30023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (3))){
var inst_29980 = (state_29982[(2)]);
var state_29982__$1 = state_29982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29982__$1,inst_29980);
} else {
if((state_val_29983 === (12))){
var inst_29968 = (state_29982[(8)]);
var inst_29968__$1 = (state_29982[(2)]);
var inst_29969 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_29968__$1);
var state_29982__$1 = (function (){var statearr_29991 = state_29982;
(statearr_29991[(8)] = inst_29968__$1);

return statearr_29991;
})();
if(cljs.core.truth_(inst_29969)){
var statearr_29992_30024 = state_29982__$1;
(statearr_29992_30024[(1)] = (13));

} else {
var statearr_29993_30025 = state_29982__$1;
(statearr_29993_30025[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (2))){
var inst_29945 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_29946 = (0);
var state_29982__$1 = (function (){var statearr_29994 = state_29982;
(statearr_29994[(7)] = inst_29946);

(statearr_29994[(9)] = inst_29945);

return statearr_29994;
})();
var statearr_29995_30026 = state_29982__$1;
(statearr_29995_30026[(2)] = null);

(statearr_29995_30026[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (11))){
var inst_29946 = (state_29982[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_29982,(10),Object,null,(9));
var inst_29955 = chs__$1.call(null,inst_29946);
var inst_29956 = done.call(null,inst_29946);
var inst_29957 = cljs.core.async.take_BANG_.call(null,inst_29955,inst_29956);
var state_29982__$1 = state_29982;
var statearr_29996_30027 = state_29982__$1;
(statearr_29996_30027[(2)] = inst_29957);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29982__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (9))){
var inst_29946 = (state_29982[(7)]);
var inst_29959 = (state_29982[(2)]);
var inst_29960 = (inst_29946 + (1));
var inst_29946__$1 = inst_29960;
var state_29982__$1 = (function (){var statearr_29997 = state_29982;
(statearr_29997[(7)] = inst_29946__$1);

(statearr_29997[(10)] = inst_29959);

return statearr_29997;
})();
var statearr_29998_30028 = state_29982__$1;
(statearr_29998_30028[(2)] = null);

(statearr_29998_30028[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (5))){
var inst_29966 = (state_29982[(2)]);
var state_29982__$1 = (function (){var statearr_29999 = state_29982;
(statearr_29999[(11)] = inst_29966);

return statearr_29999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29982__$1,(12),dchan);
} else {
if((state_val_29983 === (14))){
var inst_29968 = (state_29982[(8)]);
var inst_29973 = cljs.core.apply.call(null,f,inst_29968);
var state_29982__$1 = state_29982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29982__$1,(16),out,inst_29973);
} else {
if((state_val_29983 === (16))){
var inst_29975 = (state_29982[(2)]);
var state_29982__$1 = (function (){var statearr_30000 = state_29982;
(statearr_30000[(12)] = inst_29975);

return statearr_30000;
})();
var statearr_30001_30029 = state_29982__$1;
(statearr_30001_30029[(2)] = null);

(statearr_30001_30029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (10))){
var inst_29950 = (state_29982[(2)]);
var inst_29951 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_29982__$1 = (function (){var statearr_30002 = state_29982;
(statearr_30002[(13)] = inst_29950);

return statearr_30002;
})();
var statearr_30003_30030 = state_29982__$1;
(statearr_30003_30030[(2)] = inst_29951);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29982__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29983 === (8))){
var inst_29964 = (state_29982[(2)]);
var state_29982__$1 = state_29982;
var statearr_30004_30031 = state_29982__$1;
(statearr_30004_30031[(2)] = inst_29964);

(statearr_30004_30031[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__27865__auto__,c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30008[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30008[(1)] = (1));

return statearr_30008;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_29982){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_29982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30009){if((e30009 instanceof Object)){
var ex__27869__auto__ = e30009;
var statearr_30010_30032 = state_29982;
(statearr_30010_30032[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30033 = state_29982;
state_29982 = G__30033;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_29982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_29982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__27979__auto__ = (function (){var statearr_30011 = f__27978__auto__.call(null);
(statearr_30011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30016);

return statearr_30011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30016,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args30035 = [];
var len__25820__auto___30093 = arguments.length;
var i__25821__auto___30094 = (0);
while(true){
if((i__25821__auto___30094 < len__25820__auto___30093)){
args30035.push((arguments[i__25821__auto___30094]));

var G__30095 = (i__25821__auto___30094 + (1));
i__25821__auto___30094 = G__30095;
continue;
} else {
}
break;
}

var G__30037 = args30035.length;
switch (G__30037) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30035.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30097 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30097,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30097,out){
return (function (state_30069){
var state_val_30070 = (state_30069[(1)]);
if((state_val_30070 === (7))){
var inst_30049 = (state_30069[(7)]);
var inst_30048 = (state_30069[(8)]);
var inst_30048__$1 = (state_30069[(2)]);
var inst_30049__$1 = cljs.core.nth.call(null,inst_30048__$1,(0),null);
var inst_30050 = cljs.core.nth.call(null,inst_30048__$1,(1),null);
var inst_30051 = (inst_30049__$1 == null);
var state_30069__$1 = (function (){var statearr_30071 = state_30069;
(statearr_30071[(9)] = inst_30050);

(statearr_30071[(7)] = inst_30049__$1);

(statearr_30071[(8)] = inst_30048__$1);

return statearr_30071;
})();
if(cljs.core.truth_(inst_30051)){
var statearr_30072_30098 = state_30069__$1;
(statearr_30072_30098[(1)] = (8));

} else {
var statearr_30073_30099 = state_30069__$1;
(statearr_30073_30099[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (1))){
var inst_30038 = cljs.core.vec.call(null,chs);
var inst_30039 = inst_30038;
var state_30069__$1 = (function (){var statearr_30074 = state_30069;
(statearr_30074[(10)] = inst_30039);

return statearr_30074;
})();
var statearr_30075_30100 = state_30069__$1;
(statearr_30075_30100[(2)] = null);

(statearr_30075_30100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (4))){
var inst_30039 = (state_30069[(10)]);
var state_30069__$1 = state_30069;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30069__$1,(7),inst_30039);
} else {
if((state_val_30070 === (6))){
var inst_30065 = (state_30069[(2)]);
var state_30069__$1 = state_30069;
var statearr_30076_30101 = state_30069__$1;
(statearr_30076_30101[(2)] = inst_30065);

(statearr_30076_30101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (3))){
var inst_30067 = (state_30069[(2)]);
var state_30069__$1 = state_30069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30069__$1,inst_30067);
} else {
if((state_val_30070 === (2))){
var inst_30039 = (state_30069[(10)]);
var inst_30041 = cljs.core.count.call(null,inst_30039);
var inst_30042 = (inst_30041 > (0));
var state_30069__$1 = state_30069;
if(cljs.core.truth_(inst_30042)){
var statearr_30078_30102 = state_30069__$1;
(statearr_30078_30102[(1)] = (4));

} else {
var statearr_30079_30103 = state_30069__$1;
(statearr_30079_30103[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (11))){
var inst_30039 = (state_30069[(10)]);
var inst_30058 = (state_30069[(2)]);
var tmp30077 = inst_30039;
var inst_30039__$1 = tmp30077;
var state_30069__$1 = (function (){var statearr_30080 = state_30069;
(statearr_30080[(10)] = inst_30039__$1);

(statearr_30080[(11)] = inst_30058);

return statearr_30080;
})();
var statearr_30081_30104 = state_30069__$1;
(statearr_30081_30104[(2)] = null);

(statearr_30081_30104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (9))){
var inst_30049 = (state_30069[(7)]);
var state_30069__$1 = state_30069;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30069__$1,(11),out,inst_30049);
} else {
if((state_val_30070 === (5))){
var inst_30063 = cljs.core.async.close_BANG_.call(null,out);
var state_30069__$1 = state_30069;
var statearr_30082_30105 = state_30069__$1;
(statearr_30082_30105[(2)] = inst_30063);

(statearr_30082_30105[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (10))){
var inst_30061 = (state_30069[(2)]);
var state_30069__$1 = state_30069;
var statearr_30083_30106 = state_30069__$1;
(statearr_30083_30106[(2)] = inst_30061);

(statearr_30083_30106[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30070 === (8))){
var inst_30050 = (state_30069[(9)]);
var inst_30039 = (state_30069[(10)]);
var inst_30049 = (state_30069[(7)]);
var inst_30048 = (state_30069[(8)]);
var inst_30053 = (function (){var cs = inst_30039;
var vec__30044 = inst_30048;
var v = inst_30049;
var c = inst_30050;
return ((function (cs,vec__30044,v,c,inst_30050,inst_30039,inst_30049,inst_30048,state_val_30070,c__27977__auto___30097,out){
return (function (p1__30034_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__30034_SHARP_);
});
;})(cs,vec__30044,v,c,inst_30050,inst_30039,inst_30049,inst_30048,state_val_30070,c__27977__auto___30097,out))
})();
var inst_30054 = cljs.core.filterv.call(null,inst_30053,inst_30039);
var inst_30039__$1 = inst_30054;
var state_30069__$1 = (function (){var statearr_30084 = state_30069;
(statearr_30084[(10)] = inst_30039__$1);

return statearr_30084;
})();
var statearr_30085_30107 = state_30069__$1;
(statearr_30085_30107[(2)] = null);

(statearr_30085_30107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30097,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30097,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30089 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30089[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30089[(1)] = (1));

return statearr_30089;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30069){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30090){if((e30090 instanceof Object)){
var ex__27869__auto__ = e30090;
var statearr_30091_30108 = state_30069;
(statearr_30091_30108[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30069);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30090;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30109 = state_30069;
state_30069 = G__30109;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30069){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30097,out))
})();
var state__27979__auto__ = (function (){var statearr_30092 = f__27978__auto__.call(null);
(statearr_30092[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30097);

return statearr_30092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30097,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args30110 = [];
var len__25820__auto___30159 = arguments.length;
var i__25821__auto___30160 = (0);
while(true){
if((i__25821__auto___30160 < len__25820__auto___30159)){
args30110.push((arguments[i__25821__auto___30160]));

var G__30161 = (i__25821__auto___30160 + (1));
i__25821__auto___30160 = G__30161;
continue;
} else {
}
break;
}

var G__30112 = args30110.length;
switch (G__30112) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30110.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30163 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30163,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30163,out){
return (function (state_30136){
var state_val_30137 = (state_30136[(1)]);
if((state_val_30137 === (7))){
var inst_30118 = (state_30136[(7)]);
var inst_30118__$1 = (state_30136[(2)]);
var inst_30119 = (inst_30118__$1 == null);
var inst_30120 = cljs.core.not.call(null,inst_30119);
var state_30136__$1 = (function (){var statearr_30138 = state_30136;
(statearr_30138[(7)] = inst_30118__$1);

return statearr_30138;
})();
if(inst_30120){
var statearr_30139_30164 = state_30136__$1;
(statearr_30139_30164[(1)] = (8));

} else {
var statearr_30140_30165 = state_30136__$1;
(statearr_30140_30165[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (1))){
var inst_30113 = (0);
var state_30136__$1 = (function (){var statearr_30141 = state_30136;
(statearr_30141[(8)] = inst_30113);

return statearr_30141;
})();
var statearr_30142_30166 = state_30136__$1;
(statearr_30142_30166[(2)] = null);

(statearr_30142_30166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (4))){
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30136__$1,(7),ch);
} else {
if((state_val_30137 === (6))){
var inst_30131 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
var statearr_30143_30167 = state_30136__$1;
(statearr_30143_30167[(2)] = inst_30131);

(statearr_30143_30167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (3))){
var inst_30133 = (state_30136[(2)]);
var inst_30134 = cljs.core.async.close_BANG_.call(null,out);
var state_30136__$1 = (function (){var statearr_30144 = state_30136;
(statearr_30144[(9)] = inst_30133);

return statearr_30144;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30136__$1,inst_30134);
} else {
if((state_val_30137 === (2))){
var inst_30113 = (state_30136[(8)]);
var inst_30115 = (inst_30113 < n);
var state_30136__$1 = state_30136;
if(cljs.core.truth_(inst_30115)){
var statearr_30145_30168 = state_30136__$1;
(statearr_30145_30168[(1)] = (4));

} else {
var statearr_30146_30169 = state_30136__$1;
(statearr_30146_30169[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (11))){
var inst_30113 = (state_30136[(8)]);
var inst_30123 = (state_30136[(2)]);
var inst_30124 = (inst_30113 + (1));
var inst_30113__$1 = inst_30124;
var state_30136__$1 = (function (){var statearr_30147 = state_30136;
(statearr_30147[(10)] = inst_30123);

(statearr_30147[(8)] = inst_30113__$1);

return statearr_30147;
})();
var statearr_30148_30170 = state_30136__$1;
(statearr_30148_30170[(2)] = null);

(statearr_30148_30170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (9))){
var state_30136__$1 = state_30136;
var statearr_30149_30171 = state_30136__$1;
(statearr_30149_30171[(2)] = null);

(statearr_30149_30171[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (5))){
var state_30136__$1 = state_30136;
var statearr_30150_30172 = state_30136__$1;
(statearr_30150_30172[(2)] = null);

(statearr_30150_30172[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (10))){
var inst_30128 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
var statearr_30151_30173 = state_30136__$1;
(statearr_30151_30173[(2)] = inst_30128);

(statearr_30151_30173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30137 === (8))){
var inst_30118 = (state_30136[(7)]);
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30136__$1,(11),out,inst_30118);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30163,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30163,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30155 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30155[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30155[(1)] = (1));

return statearr_30155;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30136){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30136);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30156){if((e30156 instanceof Object)){
var ex__27869__auto__ = e30156;
var statearr_30157_30174 = state_30136;
(statearr_30157_30174[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30156;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30175 = state_30136;
state_30136 = G__30175;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30136){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30163,out))
})();
var state__27979__auto__ = (function (){var statearr_30158 = f__27978__auto__.call(null);
(statearr_30158[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30163);

return statearr_30158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30163,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async30183 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30183 = (function (map_LT_,f,ch,meta30184){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30184 = meta30184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30185,meta30184__$1){
var self__ = this;
var _30185__$1 = this;
return (new cljs.core.async.t_cljs$core$async30183(self__.map_LT_,self__.f,self__.ch,meta30184__$1));
});

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30185){
var self__ = this;
var _30185__$1 = this;
return self__.meta30184;
});

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async30186 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30186 = (function (map_LT_,f,ch,meta30184,_,fn1,meta30187){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30184 = meta30184;
this._ = _;
this.fn1 = fn1;
this.meta30187 = meta30187;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_30188,meta30187__$1){
var self__ = this;
var _30188__$1 = this;
return (new cljs.core.async.t_cljs$core$async30186(self__.map_LT_,self__.f,self__.ch,self__.meta30184,self__._,self__.fn1,meta30187__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_30188){
var self__ = this;
var _30188__$1 = this;
return self__.meta30187;
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__30176_SHARP_){
return f1.call(null,(((p1__30176_SHARP_ == null))?null:self__.f.call(null,p1__30176_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30184","meta30184",-317167581,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30183","cljs.core.async/t_cljs$core$async30183",-1606872524,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30187","meta30187",810632389,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async30186.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30186.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30186";

cljs.core.async.t_cljs$core$async30186.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async30186");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async30186 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30186(map_LT___$1,f__$1,ch__$1,meta30184__$1,___$2,fn1__$1,meta30187){
return (new cljs.core.async.t_cljs$core$async30186(map_LT___$1,f__$1,ch__$1,meta30184__$1,___$2,fn1__$1,meta30187));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async30186(self__.map_LT_,self__.f,self__.ch,self__.meta30184,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__24733__auto__ = ret;
if(cljs.core.truth_(and__24733__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__24733__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30183.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async30183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30184","meta30184",-317167581,null)], null);
});

cljs.core.async.t_cljs$core$async30183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30183";

cljs.core.async.t_cljs$core$async30183.cljs$lang$ctorPrWriter = (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async30183");
});

cljs.core.async.__GT_t_cljs$core$async30183 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30183(map_LT___$1,f__$1,ch__$1,meta30184){
return (new cljs.core.async.t_cljs$core$async30183(map_LT___$1,f__$1,ch__$1,meta30184));
});

}

return (new cljs.core.async.t_cljs$core$async30183(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async30192 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30192 = (function (map_GT_,f,ch,meta30193){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta30193 = meta30193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30194,meta30193__$1){
var self__ = this;
var _30194__$1 = this;
return (new cljs.core.async.t_cljs$core$async30192(self__.map_GT_,self__.f,self__.ch,meta30193__$1));
});

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30194){
var self__ = this;
var _30194__$1 = this;
return self__.meta30193;
});

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async30192.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30193","meta30193",1761183619,null)], null);
});

cljs.core.async.t_cljs$core$async30192.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30192.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30192";

cljs.core.async.t_cljs$core$async30192.cljs$lang$ctorPrWriter = (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async30192");
});

cljs.core.async.__GT_t_cljs$core$async30192 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30192(map_GT___$1,f__$1,ch__$1,meta30193){
return (new cljs.core.async.t_cljs$core$async30192(map_GT___$1,f__$1,ch__$1,meta30193));
});

}

return (new cljs.core.async.t_cljs$core$async30192(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async30198 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30198 = (function (filter_GT_,p,ch,meta30199){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta30199 = meta30199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30200,meta30199__$1){
var self__ = this;
var _30200__$1 = this;
return (new cljs.core.async.t_cljs$core$async30198(self__.filter_GT_,self__.p,self__.ch,meta30199__$1));
});

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30200){
var self__ = this;
var _30200__$1 = this;
return self__.meta30199;
});

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30198.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async30198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30199","meta30199",-1397362029,null)], null);
});

cljs.core.async.t_cljs$core$async30198.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30198";

cljs.core.async.t_cljs$core$async30198.cljs$lang$ctorPrWriter = (function (this__25351__auto__,writer__25352__auto__,opt__25353__auto__){
return cljs.core._write.call(null,writer__25352__auto__,"cljs.core.async/t_cljs$core$async30198");
});

cljs.core.async.__GT_t_cljs$core$async30198 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30198(filter_GT___$1,p__$1,ch__$1,meta30199){
return (new cljs.core.async.t_cljs$core$async30198(filter_GT___$1,p__$1,ch__$1,meta30199));
});

}

return (new cljs.core.async.t_cljs$core$async30198(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args30201 = [];
var len__25820__auto___30245 = arguments.length;
var i__25821__auto___30246 = (0);
while(true){
if((i__25821__auto___30246 < len__25820__auto___30245)){
args30201.push((arguments[i__25821__auto___30246]));

var G__30247 = (i__25821__auto___30246 + (1));
i__25821__auto___30246 = G__30247;
continue;
} else {
}
break;
}

var G__30203 = args30201.length;
switch (G__30203) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30201.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30249 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30249,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30249,out){
return (function (state_30224){
var state_val_30225 = (state_30224[(1)]);
if((state_val_30225 === (7))){
var inst_30220 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
var statearr_30226_30250 = state_30224__$1;
(statearr_30226_30250[(2)] = inst_30220);

(statearr_30226_30250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (1))){
var state_30224__$1 = state_30224;
var statearr_30227_30251 = state_30224__$1;
(statearr_30227_30251[(2)] = null);

(statearr_30227_30251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (4))){
var inst_30206 = (state_30224[(7)]);
var inst_30206__$1 = (state_30224[(2)]);
var inst_30207 = (inst_30206__$1 == null);
var state_30224__$1 = (function (){var statearr_30228 = state_30224;
(statearr_30228[(7)] = inst_30206__$1);

return statearr_30228;
})();
if(cljs.core.truth_(inst_30207)){
var statearr_30229_30252 = state_30224__$1;
(statearr_30229_30252[(1)] = (5));

} else {
var statearr_30230_30253 = state_30224__$1;
(statearr_30230_30253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (6))){
var inst_30206 = (state_30224[(7)]);
var inst_30211 = p.call(null,inst_30206);
var state_30224__$1 = state_30224;
if(cljs.core.truth_(inst_30211)){
var statearr_30231_30254 = state_30224__$1;
(statearr_30231_30254[(1)] = (8));

} else {
var statearr_30232_30255 = state_30224__$1;
(statearr_30232_30255[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (3))){
var inst_30222 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30224__$1,inst_30222);
} else {
if((state_val_30225 === (2))){
var state_30224__$1 = state_30224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30224__$1,(4),ch);
} else {
if((state_val_30225 === (11))){
var inst_30214 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
var statearr_30233_30256 = state_30224__$1;
(statearr_30233_30256[(2)] = inst_30214);

(statearr_30233_30256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (9))){
var state_30224__$1 = state_30224;
var statearr_30234_30257 = state_30224__$1;
(statearr_30234_30257[(2)] = null);

(statearr_30234_30257[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (5))){
var inst_30209 = cljs.core.async.close_BANG_.call(null,out);
var state_30224__$1 = state_30224;
var statearr_30235_30258 = state_30224__$1;
(statearr_30235_30258[(2)] = inst_30209);

(statearr_30235_30258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (10))){
var inst_30217 = (state_30224[(2)]);
var state_30224__$1 = (function (){var statearr_30236 = state_30224;
(statearr_30236[(8)] = inst_30217);

return statearr_30236;
})();
var statearr_30237_30259 = state_30224__$1;
(statearr_30237_30259[(2)] = null);

(statearr_30237_30259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30225 === (8))){
var inst_30206 = (state_30224[(7)]);
var state_30224__$1 = state_30224;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30224__$1,(11),out,inst_30206);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30249,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30249,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30241 = [null,null,null,null,null,null,null,null,null];
(statearr_30241[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30241[(1)] = (1));

return statearr_30241;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30224){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30242){if((e30242 instanceof Object)){
var ex__27869__auto__ = e30242;
var statearr_30243_30260 = state_30224;
(statearr_30243_30260[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30224);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30261 = state_30224;
state_30224 = G__30261;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30224){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30249,out))
})();
var state__27979__auto__ = (function (){var statearr_30244 = f__27978__auto__.call(null);
(statearr_30244[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30249);

return statearr_30244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30249,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args30262 = [];
var len__25820__auto___30265 = arguments.length;
var i__25821__auto___30266 = (0);
while(true){
if((i__25821__auto___30266 < len__25820__auto___30265)){
args30262.push((arguments[i__25821__auto___30266]));

var G__30267 = (i__25821__auto___30266 + (1));
i__25821__auto___30266 = G__30267;
continue;
} else {
}
break;
}

var G__30264 = args30262.length;
switch (G__30264) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30262.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__){
return (function (state_30434){
var state_val_30435 = (state_30434[(1)]);
if((state_val_30435 === (7))){
var inst_30430 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30436_30477 = state_30434__$1;
(statearr_30436_30477[(2)] = inst_30430);

(statearr_30436_30477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (20))){
var inst_30400 = (state_30434[(7)]);
var inst_30411 = (state_30434[(2)]);
var inst_30412 = cljs.core.next.call(null,inst_30400);
var inst_30386 = inst_30412;
var inst_30387 = null;
var inst_30388 = (0);
var inst_30389 = (0);
var state_30434__$1 = (function (){var statearr_30437 = state_30434;
(statearr_30437[(8)] = inst_30387);

(statearr_30437[(9)] = inst_30389);

(statearr_30437[(10)] = inst_30388);

(statearr_30437[(11)] = inst_30411);

(statearr_30437[(12)] = inst_30386);

return statearr_30437;
})();
var statearr_30438_30478 = state_30434__$1;
(statearr_30438_30478[(2)] = null);

(statearr_30438_30478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (1))){
var state_30434__$1 = state_30434;
var statearr_30439_30479 = state_30434__$1;
(statearr_30439_30479[(2)] = null);

(statearr_30439_30479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (4))){
var inst_30375 = (state_30434[(13)]);
var inst_30375__$1 = (state_30434[(2)]);
var inst_30376 = (inst_30375__$1 == null);
var state_30434__$1 = (function (){var statearr_30440 = state_30434;
(statearr_30440[(13)] = inst_30375__$1);

return statearr_30440;
})();
if(cljs.core.truth_(inst_30376)){
var statearr_30441_30480 = state_30434__$1;
(statearr_30441_30480[(1)] = (5));

} else {
var statearr_30442_30481 = state_30434__$1;
(statearr_30442_30481[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (15))){
var state_30434__$1 = state_30434;
var statearr_30446_30482 = state_30434__$1;
(statearr_30446_30482[(2)] = null);

(statearr_30446_30482[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (21))){
var state_30434__$1 = state_30434;
var statearr_30447_30483 = state_30434__$1;
(statearr_30447_30483[(2)] = null);

(statearr_30447_30483[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (13))){
var inst_30387 = (state_30434[(8)]);
var inst_30389 = (state_30434[(9)]);
var inst_30388 = (state_30434[(10)]);
var inst_30386 = (state_30434[(12)]);
var inst_30396 = (state_30434[(2)]);
var inst_30397 = (inst_30389 + (1));
var tmp30443 = inst_30387;
var tmp30444 = inst_30388;
var tmp30445 = inst_30386;
var inst_30386__$1 = tmp30445;
var inst_30387__$1 = tmp30443;
var inst_30388__$1 = tmp30444;
var inst_30389__$1 = inst_30397;
var state_30434__$1 = (function (){var statearr_30448 = state_30434;
(statearr_30448[(8)] = inst_30387__$1);

(statearr_30448[(9)] = inst_30389__$1);

(statearr_30448[(10)] = inst_30388__$1);

(statearr_30448[(14)] = inst_30396);

(statearr_30448[(12)] = inst_30386__$1);

return statearr_30448;
})();
var statearr_30449_30484 = state_30434__$1;
(statearr_30449_30484[(2)] = null);

(statearr_30449_30484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (22))){
var state_30434__$1 = state_30434;
var statearr_30450_30485 = state_30434__$1;
(statearr_30450_30485[(2)] = null);

(statearr_30450_30485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (6))){
var inst_30375 = (state_30434[(13)]);
var inst_30384 = f.call(null,inst_30375);
var inst_30385 = cljs.core.seq.call(null,inst_30384);
var inst_30386 = inst_30385;
var inst_30387 = null;
var inst_30388 = (0);
var inst_30389 = (0);
var state_30434__$1 = (function (){var statearr_30451 = state_30434;
(statearr_30451[(8)] = inst_30387);

(statearr_30451[(9)] = inst_30389);

(statearr_30451[(10)] = inst_30388);

(statearr_30451[(12)] = inst_30386);

return statearr_30451;
})();
var statearr_30452_30486 = state_30434__$1;
(statearr_30452_30486[(2)] = null);

(statearr_30452_30486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (17))){
var inst_30400 = (state_30434[(7)]);
var inst_30404 = cljs.core.chunk_first.call(null,inst_30400);
var inst_30405 = cljs.core.chunk_rest.call(null,inst_30400);
var inst_30406 = cljs.core.count.call(null,inst_30404);
var inst_30386 = inst_30405;
var inst_30387 = inst_30404;
var inst_30388 = inst_30406;
var inst_30389 = (0);
var state_30434__$1 = (function (){var statearr_30453 = state_30434;
(statearr_30453[(8)] = inst_30387);

(statearr_30453[(9)] = inst_30389);

(statearr_30453[(10)] = inst_30388);

(statearr_30453[(12)] = inst_30386);

return statearr_30453;
})();
var statearr_30454_30487 = state_30434__$1;
(statearr_30454_30487[(2)] = null);

(statearr_30454_30487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (3))){
var inst_30432 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30434__$1,inst_30432);
} else {
if((state_val_30435 === (12))){
var inst_30420 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30455_30488 = state_30434__$1;
(statearr_30455_30488[(2)] = inst_30420);

(statearr_30455_30488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (2))){
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30434__$1,(4),in$);
} else {
if((state_val_30435 === (23))){
var inst_30428 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30456_30489 = state_30434__$1;
(statearr_30456_30489[(2)] = inst_30428);

(statearr_30456_30489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (19))){
var inst_30415 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30457_30490 = state_30434__$1;
(statearr_30457_30490[(2)] = inst_30415);

(statearr_30457_30490[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (11))){
var inst_30400 = (state_30434[(7)]);
var inst_30386 = (state_30434[(12)]);
var inst_30400__$1 = cljs.core.seq.call(null,inst_30386);
var state_30434__$1 = (function (){var statearr_30458 = state_30434;
(statearr_30458[(7)] = inst_30400__$1);

return statearr_30458;
})();
if(inst_30400__$1){
var statearr_30459_30491 = state_30434__$1;
(statearr_30459_30491[(1)] = (14));

} else {
var statearr_30460_30492 = state_30434__$1;
(statearr_30460_30492[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (9))){
var inst_30422 = (state_30434[(2)]);
var inst_30423 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_30434__$1 = (function (){var statearr_30461 = state_30434;
(statearr_30461[(15)] = inst_30422);

return statearr_30461;
})();
if(cljs.core.truth_(inst_30423)){
var statearr_30462_30493 = state_30434__$1;
(statearr_30462_30493[(1)] = (21));

} else {
var statearr_30463_30494 = state_30434__$1;
(statearr_30463_30494[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (5))){
var inst_30378 = cljs.core.async.close_BANG_.call(null,out);
var state_30434__$1 = state_30434;
var statearr_30464_30495 = state_30434__$1;
(statearr_30464_30495[(2)] = inst_30378);

(statearr_30464_30495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (14))){
var inst_30400 = (state_30434[(7)]);
var inst_30402 = cljs.core.chunked_seq_QMARK_.call(null,inst_30400);
var state_30434__$1 = state_30434;
if(inst_30402){
var statearr_30465_30496 = state_30434__$1;
(statearr_30465_30496[(1)] = (17));

} else {
var statearr_30466_30497 = state_30434__$1;
(statearr_30466_30497[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (16))){
var inst_30418 = (state_30434[(2)]);
var state_30434__$1 = state_30434;
var statearr_30467_30498 = state_30434__$1;
(statearr_30467_30498[(2)] = inst_30418);

(statearr_30467_30498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30435 === (10))){
var inst_30387 = (state_30434[(8)]);
var inst_30389 = (state_30434[(9)]);
var inst_30394 = cljs.core._nth.call(null,inst_30387,inst_30389);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30434__$1,(13),out,inst_30394);
} else {
if((state_val_30435 === (18))){
var inst_30400 = (state_30434[(7)]);
var inst_30409 = cljs.core.first.call(null,inst_30400);
var state_30434__$1 = state_30434;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30434__$1,(20),out,inst_30409);
} else {
if((state_val_30435 === (8))){
var inst_30389 = (state_30434[(9)]);
var inst_30388 = (state_30434[(10)]);
var inst_30391 = (inst_30389 < inst_30388);
var inst_30392 = inst_30391;
var state_30434__$1 = state_30434;
if(cljs.core.truth_(inst_30392)){
var statearr_30468_30499 = state_30434__$1;
(statearr_30468_30499[(1)] = (10));

} else {
var statearr_30469_30500 = state_30434__$1;
(statearr_30469_30500[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__))
;
return ((function (switch__27865__auto__,c__27977__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____0 = (function (){
var statearr_30473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30473[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__);

(statearr_30473[(1)] = (1));

return statearr_30473;
});
var cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____1 = (function (state_30434){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30474){if((e30474 instanceof Object)){
var ex__27869__auto__ = e30474;
var statearr_30475_30501 = state_30434;
(statearr_30475_30501[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30434);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30474;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30502 = state_30434;
state_30434 = G__30502;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__ = function(state_30434){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____1.call(this,state_30434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__27866__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__))
})();
var state__27979__auto__ = (function (){var statearr_30476 = f__27978__auto__.call(null);
(statearr_30476[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_30476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__))
);

return c__27977__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args30503 = [];
var len__25820__auto___30506 = arguments.length;
var i__25821__auto___30507 = (0);
while(true){
if((i__25821__auto___30507 < len__25820__auto___30506)){
args30503.push((arguments[i__25821__auto___30507]));

var G__30508 = (i__25821__auto___30507 + (1));
i__25821__auto___30507 = G__30508;
continue;
} else {
}
break;
}

var G__30505 = args30503.length;
switch (G__30505) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30503.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args30510 = [];
var len__25820__auto___30513 = arguments.length;
var i__25821__auto___30514 = (0);
while(true){
if((i__25821__auto___30514 < len__25820__auto___30513)){
args30510.push((arguments[i__25821__auto___30514]));

var G__30515 = (i__25821__auto___30514 + (1));
i__25821__auto___30514 = G__30515;
continue;
} else {
}
break;
}

var G__30512 = args30510.length;
switch (G__30512) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30510.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args30517 = [];
var len__25820__auto___30568 = arguments.length;
var i__25821__auto___30569 = (0);
while(true){
if((i__25821__auto___30569 < len__25820__auto___30568)){
args30517.push((arguments[i__25821__auto___30569]));

var G__30570 = (i__25821__auto___30569 + (1));
i__25821__auto___30569 = G__30570;
continue;
} else {
}
break;
}

var G__30519 = args30517.length;
switch (G__30519) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30517.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30572 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30572,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30572,out){
return (function (state_30543){
var state_val_30544 = (state_30543[(1)]);
if((state_val_30544 === (7))){
var inst_30538 = (state_30543[(2)]);
var state_30543__$1 = state_30543;
var statearr_30545_30573 = state_30543__$1;
(statearr_30545_30573[(2)] = inst_30538);

(statearr_30545_30573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (1))){
var inst_30520 = null;
var state_30543__$1 = (function (){var statearr_30546 = state_30543;
(statearr_30546[(7)] = inst_30520);

return statearr_30546;
})();
var statearr_30547_30574 = state_30543__$1;
(statearr_30547_30574[(2)] = null);

(statearr_30547_30574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (4))){
var inst_30523 = (state_30543[(8)]);
var inst_30523__$1 = (state_30543[(2)]);
var inst_30524 = (inst_30523__$1 == null);
var inst_30525 = cljs.core.not.call(null,inst_30524);
var state_30543__$1 = (function (){var statearr_30548 = state_30543;
(statearr_30548[(8)] = inst_30523__$1);

return statearr_30548;
})();
if(inst_30525){
var statearr_30549_30575 = state_30543__$1;
(statearr_30549_30575[(1)] = (5));

} else {
var statearr_30550_30576 = state_30543__$1;
(statearr_30550_30576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (6))){
var state_30543__$1 = state_30543;
var statearr_30551_30577 = state_30543__$1;
(statearr_30551_30577[(2)] = null);

(statearr_30551_30577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (3))){
var inst_30540 = (state_30543[(2)]);
var inst_30541 = cljs.core.async.close_BANG_.call(null,out);
var state_30543__$1 = (function (){var statearr_30552 = state_30543;
(statearr_30552[(9)] = inst_30540);

return statearr_30552;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30543__$1,inst_30541);
} else {
if((state_val_30544 === (2))){
var state_30543__$1 = state_30543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30543__$1,(4),ch);
} else {
if((state_val_30544 === (11))){
var inst_30523 = (state_30543[(8)]);
var inst_30532 = (state_30543[(2)]);
var inst_30520 = inst_30523;
var state_30543__$1 = (function (){var statearr_30553 = state_30543;
(statearr_30553[(7)] = inst_30520);

(statearr_30553[(10)] = inst_30532);

return statearr_30553;
})();
var statearr_30554_30578 = state_30543__$1;
(statearr_30554_30578[(2)] = null);

(statearr_30554_30578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (9))){
var inst_30523 = (state_30543[(8)]);
var state_30543__$1 = state_30543;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30543__$1,(11),out,inst_30523);
} else {
if((state_val_30544 === (5))){
var inst_30523 = (state_30543[(8)]);
var inst_30520 = (state_30543[(7)]);
var inst_30527 = cljs.core._EQ_.call(null,inst_30523,inst_30520);
var state_30543__$1 = state_30543;
if(inst_30527){
var statearr_30556_30579 = state_30543__$1;
(statearr_30556_30579[(1)] = (8));

} else {
var statearr_30557_30580 = state_30543__$1;
(statearr_30557_30580[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (10))){
var inst_30535 = (state_30543[(2)]);
var state_30543__$1 = state_30543;
var statearr_30558_30581 = state_30543__$1;
(statearr_30558_30581[(2)] = inst_30535);

(statearr_30558_30581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30544 === (8))){
var inst_30520 = (state_30543[(7)]);
var tmp30555 = inst_30520;
var inst_30520__$1 = tmp30555;
var state_30543__$1 = (function (){var statearr_30559 = state_30543;
(statearr_30559[(7)] = inst_30520__$1);

return statearr_30559;
})();
var statearr_30560_30582 = state_30543__$1;
(statearr_30560_30582[(2)] = null);

(statearr_30560_30582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30572,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30572,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30564 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30564[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30564[(1)] = (1));

return statearr_30564;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30543){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30565){if((e30565 instanceof Object)){
var ex__27869__auto__ = e30565;
var statearr_30566_30583 = state_30543;
(statearr_30566_30583[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30543);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30584 = state_30543;
state_30543 = G__30584;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30572,out))
})();
var state__27979__auto__ = (function (){var statearr_30567 = f__27978__auto__.call(null);
(statearr_30567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30572);

return statearr_30567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30572,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args30585 = [];
var len__25820__auto___30655 = arguments.length;
var i__25821__auto___30656 = (0);
while(true){
if((i__25821__auto___30656 < len__25820__auto___30655)){
args30585.push((arguments[i__25821__auto___30656]));

var G__30657 = (i__25821__auto___30656 + (1));
i__25821__auto___30656 = G__30657;
continue;
} else {
}
break;
}

var G__30587 = args30585.length;
switch (G__30587) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30585.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30659 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30659,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30659,out){
return (function (state_30625){
var state_val_30626 = (state_30625[(1)]);
if((state_val_30626 === (7))){
var inst_30621 = (state_30625[(2)]);
var state_30625__$1 = state_30625;
var statearr_30627_30660 = state_30625__$1;
(statearr_30627_30660[(2)] = inst_30621);

(statearr_30627_30660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (1))){
var inst_30588 = (new Array(n));
var inst_30589 = inst_30588;
var inst_30590 = (0);
var state_30625__$1 = (function (){var statearr_30628 = state_30625;
(statearr_30628[(7)] = inst_30590);

(statearr_30628[(8)] = inst_30589);

return statearr_30628;
})();
var statearr_30629_30661 = state_30625__$1;
(statearr_30629_30661[(2)] = null);

(statearr_30629_30661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (4))){
var inst_30593 = (state_30625[(9)]);
var inst_30593__$1 = (state_30625[(2)]);
var inst_30594 = (inst_30593__$1 == null);
var inst_30595 = cljs.core.not.call(null,inst_30594);
var state_30625__$1 = (function (){var statearr_30630 = state_30625;
(statearr_30630[(9)] = inst_30593__$1);

return statearr_30630;
})();
if(inst_30595){
var statearr_30631_30662 = state_30625__$1;
(statearr_30631_30662[(1)] = (5));

} else {
var statearr_30632_30663 = state_30625__$1;
(statearr_30632_30663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (15))){
var inst_30615 = (state_30625[(2)]);
var state_30625__$1 = state_30625;
var statearr_30633_30664 = state_30625__$1;
(statearr_30633_30664[(2)] = inst_30615);

(statearr_30633_30664[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (13))){
var state_30625__$1 = state_30625;
var statearr_30634_30665 = state_30625__$1;
(statearr_30634_30665[(2)] = null);

(statearr_30634_30665[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (6))){
var inst_30590 = (state_30625[(7)]);
var inst_30611 = (inst_30590 > (0));
var state_30625__$1 = state_30625;
if(cljs.core.truth_(inst_30611)){
var statearr_30635_30666 = state_30625__$1;
(statearr_30635_30666[(1)] = (12));

} else {
var statearr_30636_30667 = state_30625__$1;
(statearr_30636_30667[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (3))){
var inst_30623 = (state_30625[(2)]);
var state_30625__$1 = state_30625;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30625__$1,inst_30623);
} else {
if((state_val_30626 === (12))){
var inst_30589 = (state_30625[(8)]);
var inst_30613 = cljs.core.vec.call(null,inst_30589);
var state_30625__$1 = state_30625;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30625__$1,(15),out,inst_30613);
} else {
if((state_val_30626 === (2))){
var state_30625__$1 = state_30625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30625__$1,(4),ch);
} else {
if((state_val_30626 === (11))){
var inst_30605 = (state_30625[(2)]);
var inst_30606 = (new Array(n));
var inst_30589 = inst_30606;
var inst_30590 = (0);
var state_30625__$1 = (function (){var statearr_30637 = state_30625;
(statearr_30637[(10)] = inst_30605);

(statearr_30637[(7)] = inst_30590);

(statearr_30637[(8)] = inst_30589);

return statearr_30637;
})();
var statearr_30638_30668 = state_30625__$1;
(statearr_30638_30668[(2)] = null);

(statearr_30638_30668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (9))){
var inst_30589 = (state_30625[(8)]);
var inst_30603 = cljs.core.vec.call(null,inst_30589);
var state_30625__$1 = state_30625;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30625__$1,(11),out,inst_30603);
} else {
if((state_val_30626 === (5))){
var inst_30598 = (state_30625[(11)]);
var inst_30590 = (state_30625[(7)]);
var inst_30593 = (state_30625[(9)]);
var inst_30589 = (state_30625[(8)]);
var inst_30597 = (inst_30589[inst_30590] = inst_30593);
var inst_30598__$1 = (inst_30590 + (1));
var inst_30599 = (inst_30598__$1 < n);
var state_30625__$1 = (function (){var statearr_30639 = state_30625;
(statearr_30639[(11)] = inst_30598__$1);

(statearr_30639[(12)] = inst_30597);

return statearr_30639;
})();
if(cljs.core.truth_(inst_30599)){
var statearr_30640_30669 = state_30625__$1;
(statearr_30640_30669[(1)] = (8));

} else {
var statearr_30641_30670 = state_30625__$1;
(statearr_30641_30670[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (14))){
var inst_30618 = (state_30625[(2)]);
var inst_30619 = cljs.core.async.close_BANG_.call(null,out);
var state_30625__$1 = (function (){var statearr_30643 = state_30625;
(statearr_30643[(13)] = inst_30618);

return statearr_30643;
})();
var statearr_30644_30671 = state_30625__$1;
(statearr_30644_30671[(2)] = inst_30619);

(statearr_30644_30671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (10))){
var inst_30609 = (state_30625[(2)]);
var state_30625__$1 = state_30625;
var statearr_30645_30672 = state_30625__$1;
(statearr_30645_30672[(2)] = inst_30609);

(statearr_30645_30672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30626 === (8))){
var inst_30598 = (state_30625[(11)]);
var inst_30589 = (state_30625[(8)]);
var tmp30642 = inst_30589;
var inst_30589__$1 = tmp30642;
var inst_30590 = inst_30598;
var state_30625__$1 = (function (){var statearr_30646 = state_30625;
(statearr_30646[(7)] = inst_30590);

(statearr_30646[(8)] = inst_30589__$1);

return statearr_30646;
})();
var statearr_30647_30673 = state_30625__$1;
(statearr_30647_30673[(2)] = null);

(statearr_30647_30673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30659,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30659,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30651[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30651[(1)] = (1));

return statearr_30651;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30625){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30652){if((e30652 instanceof Object)){
var ex__27869__auto__ = e30652;
var statearr_30653_30674 = state_30625;
(statearr_30653_30674[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30625);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30675 = state_30625;
state_30625 = G__30675;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30625){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30659,out))
})();
var state__27979__auto__ = (function (){var statearr_30654 = f__27978__auto__.call(null);
(statearr_30654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30659);

return statearr_30654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30659,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args30676 = [];
var len__25820__auto___30750 = arguments.length;
var i__25821__auto___30751 = (0);
while(true){
if((i__25821__auto___30751 < len__25820__auto___30750)){
args30676.push((arguments[i__25821__auto___30751]));

var G__30752 = (i__25821__auto___30751 + (1));
i__25821__auto___30751 = G__30752;
continue;
} else {
}
break;
}

var G__30678 = args30676.length;
switch (G__30678) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30676.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__27977__auto___30754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___30754,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___30754,out){
return (function (state_30720){
var state_val_30721 = (state_30720[(1)]);
if((state_val_30721 === (7))){
var inst_30716 = (state_30720[(2)]);
var state_30720__$1 = state_30720;
var statearr_30722_30755 = state_30720__$1;
(statearr_30722_30755[(2)] = inst_30716);

(statearr_30722_30755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (1))){
var inst_30679 = [];
var inst_30680 = inst_30679;
var inst_30681 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30720__$1 = (function (){var statearr_30723 = state_30720;
(statearr_30723[(7)] = inst_30681);

(statearr_30723[(8)] = inst_30680);

return statearr_30723;
})();
var statearr_30724_30756 = state_30720__$1;
(statearr_30724_30756[(2)] = null);

(statearr_30724_30756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (4))){
var inst_30684 = (state_30720[(9)]);
var inst_30684__$1 = (state_30720[(2)]);
var inst_30685 = (inst_30684__$1 == null);
var inst_30686 = cljs.core.not.call(null,inst_30685);
var state_30720__$1 = (function (){var statearr_30725 = state_30720;
(statearr_30725[(9)] = inst_30684__$1);

return statearr_30725;
})();
if(inst_30686){
var statearr_30726_30757 = state_30720__$1;
(statearr_30726_30757[(1)] = (5));

} else {
var statearr_30727_30758 = state_30720__$1;
(statearr_30727_30758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (15))){
var inst_30710 = (state_30720[(2)]);
var state_30720__$1 = state_30720;
var statearr_30728_30759 = state_30720__$1;
(statearr_30728_30759[(2)] = inst_30710);

(statearr_30728_30759[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (13))){
var state_30720__$1 = state_30720;
var statearr_30729_30760 = state_30720__$1;
(statearr_30729_30760[(2)] = null);

(statearr_30729_30760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (6))){
var inst_30680 = (state_30720[(8)]);
var inst_30705 = inst_30680.length;
var inst_30706 = (inst_30705 > (0));
var state_30720__$1 = state_30720;
if(cljs.core.truth_(inst_30706)){
var statearr_30730_30761 = state_30720__$1;
(statearr_30730_30761[(1)] = (12));

} else {
var statearr_30731_30762 = state_30720__$1;
(statearr_30731_30762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (3))){
var inst_30718 = (state_30720[(2)]);
var state_30720__$1 = state_30720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30720__$1,inst_30718);
} else {
if((state_val_30721 === (12))){
var inst_30680 = (state_30720[(8)]);
var inst_30708 = cljs.core.vec.call(null,inst_30680);
var state_30720__$1 = state_30720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30720__$1,(15),out,inst_30708);
} else {
if((state_val_30721 === (2))){
var state_30720__$1 = state_30720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30720__$1,(4),ch);
} else {
if((state_val_30721 === (11))){
var inst_30684 = (state_30720[(9)]);
var inst_30688 = (state_30720[(10)]);
var inst_30698 = (state_30720[(2)]);
var inst_30699 = [];
var inst_30700 = inst_30699.push(inst_30684);
var inst_30680 = inst_30699;
var inst_30681 = inst_30688;
var state_30720__$1 = (function (){var statearr_30732 = state_30720;
(statearr_30732[(11)] = inst_30698);

(statearr_30732[(12)] = inst_30700);

(statearr_30732[(7)] = inst_30681);

(statearr_30732[(8)] = inst_30680);

return statearr_30732;
})();
var statearr_30733_30763 = state_30720__$1;
(statearr_30733_30763[(2)] = null);

(statearr_30733_30763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (9))){
var inst_30680 = (state_30720[(8)]);
var inst_30696 = cljs.core.vec.call(null,inst_30680);
var state_30720__$1 = state_30720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30720__$1,(11),out,inst_30696);
} else {
if((state_val_30721 === (5))){
var inst_30684 = (state_30720[(9)]);
var inst_30688 = (state_30720[(10)]);
var inst_30681 = (state_30720[(7)]);
var inst_30688__$1 = f.call(null,inst_30684);
var inst_30689 = cljs.core._EQ_.call(null,inst_30688__$1,inst_30681);
var inst_30690 = cljs.core.keyword_identical_QMARK_.call(null,inst_30681,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30691 = (inst_30689) || (inst_30690);
var state_30720__$1 = (function (){var statearr_30734 = state_30720;
(statearr_30734[(10)] = inst_30688__$1);

return statearr_30734;
})();
if(cljs.core.truth_(inst_30691)){
var statearr_30735_30764 = state_30720__$1;
(statearr_30735_30764[(1)] = (8));

} else {
var statearr_30736_30765 = state_30720__$1;
(statearr_30736_30765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (14))){
var inst_30713 = (state_30720[(2)]);
var inst_30714 = cljs.core.async.close_BANG_.call(null,out);
var state_30720__$1 = (function (){var statearr_30738 = state_30720;
(statearr_30738[(13)] = inst_30713);

return statearr_30738;
})();
var statearr_30739_30766 = state_30720__$1;
(statearr_30739_30766[(2)] = inst_30714);

(statearr_30739_30766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (10))){
var inst_30703 = (state_30720[(2)]);
var state_30720__$1 = state_30720;
var statearr_30740_30767 = state_30720__$1;
(statearr_30740_30767[(2)] = inst_30703);

(statearr_30740_30767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30721 === (8))){
var inst_30684 = (state_30720[(9)]);
var inst_30688 = (state_30720[(10)]);
var inst_30680 = (state_30720[(8)]);
var inst_30693 = inst_30680.push(inst_30684);
var tmp30737 = inst_30680;
var inst_30680__$1 = tmp30737;
var inst_30681 = inst_30688;
var state_30720__$1 = (function (){var statearr_30741 = state_30720;
(statearr_30741[(7)] = inst_30681);

(statearr_30741[(14)] = inst_30693);

(statearr_30741[(8)] = inst_30680__$1);

return statearr_30741;
})();
var statearr_30742_30768 = state_30720__$1;
(statearr_30742_30768[(2)] = null);

(statearr_30742_30768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto___30754,out))
;
return ((function (switch__27865__auto__,c__27977__auto___30754,out){
return (function() {
var cljs$core$async$state_machine__27866__auto__ = null;
var cljs$core$async$state_machine__27866__auto____0 = (function (){
var statearr_30746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30746[(0)] = cljs$core$async$state_machine__27866__auto__);

(statearr_30746[(1)] = (1));

return statearr_30746;
});
var cljs$core$async$state_machine__27866__auto____1 = (function (state_30720){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_30720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e30747){if((e30747 instanceof Object)){
var ex__27869__auto__ = e30747;
var statearr_30748_30769 = state_30720;
(statearr_30748_30769[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30770 = state_30720;
state_30720 = G__30770;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
cljs$core$async$state_machine__27866__auto__ = function(state_30720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27866__auto____1.call(this,state_30720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27866__auto____0;
cljs$core$async$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27866__auto____1;
return cljs$core$async$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___30754,out))
})();
var state__27979__auto__ = (function (){var statearr_30749 = f__27978__auto__.call(null);
(statearr_30749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___30754);

return statearr_30749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___30754,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1473150051977