// Compiled by ClojureScript 1.9.227 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__24745__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__24745__auto__){
return or__24745__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__24745__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__30832_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__30832_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__30837 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__30838 = null;
var count__30839 = (0);
var i__30840 = (0);
while(true){
if((i__30840 < count__30839)){
var n = cljs.core._nth.call(null,chunk__30838,i__30840);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__30841 = seq__30837;
var G__30842 = chunk__30838;
var G__30843 = count__30839;
var G__30844 = (i__30840 + (1));
seq__30837 = G__30841;
chunk__30838 = G__30842;
count__30839 = G__30843;
i__30840 = G__30844;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__30837);
if(temp__4657__auto__){
var seq__30837__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30837__$1)){
var c__25556__auto__ = cljs.core.chunk_first.call(null,seq__30837__$1);
var G__30845 = cljs.core.chunk_rest.call(null,seq__30837__$1);
var G__30846 = c__25556__auto__;
var G__30847 = cljs.core.count.call(null,c__25556__auto__);
var G__30848 = (0);
seq__30837 = G__30845;
chunk__30838 = G__30846;
count__30839 = G__30847;
i__30840 = G__30848;
continue;
} else {
var n = cljs.core.first.call(null,seq__30837__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__30849 = cljs.core.next.call(null,seq__30837__$1);
var G__30850 = null;
var G__30851 = (0);
var G__30852 = (0);
seq__30837 = G__30849;
chunk__30838 = G__30850;
count__30839 = G__30851;
i__30840 = G__30852;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__30903_30914 = cljs.core.seq.call(null,deps);
var chunk__30904_30915 = null;
var count__30905_30916 = (0);
var i__30906_30917 = (0);
while(true){
if((i__30906_30917 < count__30905_30916)){
var dep_30918 = cljs.core._nth.call(null,chunk__30904_30915,i__30906_30917);
topo_sort_helper_STAR_.call(null,dep_30918,(depth + (1)),state);

var G__30919 = seq__30903_30914;
var G__30920 = chunk__30904_30915;
var G__30921 = count__30905_30916;
var G__30922 = (i__30906_30917 + (1));
seq__30903_30914 = G__30919;
chunk__30904_30915 = G__30920;
count__30905_30916 = G__30921;
i__30906_30917 = G__30922;
continue;
} else {
var temp__4657__auto___30923 = cljs.core.seq.call(null,seq__30903_30914);
if(temp__4657__auto___30923){
var seq__30903_30924__$1 = temp__4657__auto___30923;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30903_30924__$1)){
var c__25556__auto___30925 = cljs.core.chunk_first.call(null,seq__30903_30924__$1);
var G__30926 = cljs.core.chunk_rest.call(null,seq__30903_30924__$1);
var G__30927 = c__25556__auto___30925;
var G__30928 = cljs.core.count.call(null,c__25556__auto___30925);
var G__30929 = (0);
seq__30903_30914 = G__30926;
chunk__30904_30915 = G__30927;
count__30905_30916 = G__30928;
i__30906_30917 = G__30929;
continue;
} else {
var dep_30930 = cljs.core.first.call(null,seq__30903_30924__$1);
topo_sort_helper_STAR_.call(null,dep_30930,(depth + (1)),state);

var G__30931 = cljs.core.next.call(null,seq__30903_30924__$1);
var G__30932 = null;
var G__30933 = (0);
var G__30934 = (0);
seq__30903_30914 = G__30931;
chunk__30904_30915 = G__30932;
count__30905_30916 = G__30933;
i__30906_30917 = G__30934;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__30907){
var vec__30911 = p__30907;
var seq__30912 = cljs.core.seq.call(null,vec__30911);
var first__30913 = cljs.core.first.call(null,seq__30912);
var seq__30912__$1 = cljs.core.next.call(null,seq__30912);
var x = first__30913;
var xs = seq__30912__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__30911,seq__30912,first__30913,seq__30912__$1,x,xs,get_deps__$1){
return (function (p1__30853_SHARP_){
return clojure.set.difference.call(null,p1__30853_SHARP_,x);
});})(vec__30911,seq__30912,first__30913,seq__30912__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__30947 = cljs.core.seq.call(null,provides);
var chunk__30948 = null;
var count__30949 = (0);
var i__30950 = (0);
while(true){
if((i__30950 < count__30949)){
var prov = cljs.core._nth.call(null,chunk__30948,i__30950);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30951_30959 = cljs.core.seq.call(null,requires);
var chunk__30952_30960 = null;
var count__30953_30961 = (0);
var i__30954_30962 = (0);
while(true){
if((i__30954_30962 < count__30953_30961)){
var req_30963 = cljs.core._nth.call(null,chunk__30952_30960,i__30954_30962);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30963,prov);

var G__30964 = seq__30951_30959;
var G__30965 = chunk__30952_30960;
var G__30966 = count__30953_30961;
var G__30967 = (i__30954_30962 + (1));
seq__30951_30959 = G__30964;
chunk__30952_30960 = G__30965;
count__30953_30961 = G__30966;
i__30954_30962 = G__30967;
continue;
} else {
var temp__4657__auto___30968 = cljs.core.seq.call(null,seq__30951_30959);
if(temp__4657__auto___30968){
var seq__30951_30969__$1 = temp__4657__auto___30968;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30951_30969__$1)){
var c__25556__auto___30970 = cljs.core.chunk_first.call(null,seq__30951_30969__$1);
var G__30971 = cljs.core.chunk_rest.call(null,seq__30951_30969__$1);
var G__30972 = c__25556__auto___30970;
var G__30973 = cljs.core.count.call(null,c__25556__auto___30970);
var G__30974 = (0);
seq__30951_30959 = G__30971;
chunk__30952_30960 = G__30972;
count__30953_30961 = G__30973;
i__30954_30962 = G__30974;
continue;
} else {
var req_30975 = cljs.core.first.call(null,seq__30951_30969__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30975,prov);

var G__30976 = cljs.core.next.call(null,seq__30951_30969__$1);
var G__30977 = null;
var G__30978 = (0);
var G__30979 = (0);
seq__30951_30959 = G__30976;
chunk__30952_30960 = G__30977;
count__30953_30961 = G__30978;
i__30954_30962 = G__30979;
continue;
}
} else {
}
}
break;
}

var G__30980 = seq__30947;
var G__30981 = chunk__30948;
var G__30982 = count__30949;
var G__30983 = (i__30950 + (1));
seq__30947 = G__30980;
chunk__30948 = G__30981;
count__30949 = G__30982;
i__30950 = G__30983;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__30947);
if(temp__4657__auto__){
var seq__30947__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30947__$1)){
var c__25556__auto__ = cljs.core.chunk_first.call(null,seq__30947__$1);
var G__30984 = cljs.core.chunk_rest.call(null,seq__30947__$1);
var G__30985 = c__25556__auto__;
var G__30986 = cljs.core.count.call(null,c__25556__auto__);
var G__30987 = (0);
seq__30947 = G__30984;
chunk__30948 = G__30985;
count__30949 = G__30986;
i__30950 = G__30987;
continue;
} else {
var prov = cljs.core.first.call(null,seq__30947__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30955_30988 = cljs.core.seq.call(null,requires);
var chunk__30956_30989 = null;
var count__30957_30990 = (0);
var i__30958_30991 = (0);
while(true){
if((i__30958_30991 < count__30957_30990)){
var req_30992 = cljs.core._nth.call(null,chunk__30956_30989,i__30958_30991);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30992,prov);

var G__30993 = seq__30955_30988;
var G__30994 = chunk__30956_30989;
var G__30995 = count__30957_30990;
var G__30996 = (i__30958_30991 + (1));
seq__30955_30988 = G__30993;
chunk__30956_30989 = G__30994;
count__30957_30990 = G__30995;
i__30958_30991 = G__30996;
continue;
} else {
var temp__4657__auto___30997__$1 = cljs.core.seq.call(null,seq__30955_30988);
if(temp__4657__auto___30997__$1){
var seq__30955_30998__$1 = temp__4657__auto___30997__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30955_30998__$1)){
var c__25556__auto___30999 = cljs.core.chunk_first.call(null,seq__30955_30998__$1);
var G__31000 = cljs.core.chunk_rest.call(null,seq__30955_30998__$1);
var G__31001 = c__25556__auto___30999;
var G__31002 = cljs.core.count.call(null,c__25556__auto___30999);
var G__31003 = (0);
seq__30955_30988 = G__31000;
chunk__30956_30989 = G__31001;
count__30957_30990 = G__31002;
i__30958_30991 = G__31003;
continue;
} else {
var req_31004 = cljs.core.first.call(null,seq__30955_30998__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_31004,prov);

var G__31005 = cljs.core.next.call(null,seq__30955_30998__$1);
var G__31006 = null;
var G__31007 = (0);
var G__31008 = (0);
seq__30955_30988 = G__31005;
chunk__30956_30989 = G__31006;
count__30957_30990 = G__31007;
i__30958_30991 = G__31008;
continue;
}
} else {
}
}
break;
}

var G__31009 = cljs.core.next.call(null,seq__30947__$1);
var G__31010 = null;
var G__31011 = (0);
var G__31012 = (0);
seq__30947 = G__31009;
chunk__30948 = G__31010;
count__30949 = G__31011;
i__30950 = G__31012;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__31017_31021 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__31018_31022 = null;
var count__31019_31023 = (0);
var i__31020_31024 = (0);
while(true){
if((i__31020_31024 < count__31019_31023)){
var ns_31025 = cljs.core._nth.call(null,chunk__31018_31022,i__31020_31024);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_31025);

var G__31026 = seq__31017_31021;
var G__31027 = chunk__31018_31022;
var G__31028 = count__31019_31023;
var G__31029 = (i__31020_31024 + (1));
seq__31017_31021 = G__31026;
chunk__31018_31022 = G__31027;
count__31019_31023 = G__31028;
i__31020_31024 = G__31029;
continue;
} else {
var temp__4657__auto___31030 = cljs.core.seq.call(null,seq__31017_31021);
if(temp__4657__auto___31030){
var seq__31017_31031__$1 = temp__4657__auto___31030;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31017_31031__$1)){
var c__25556__auto___31032 = cljs.core.chunk_first.call(null,seq__31017_31031__$1);
var G__31033 = cljs.core.chunk_rest.call(null,seq__31017_31031__$1);
var G__31034 = c__25556__auto___31032;
var G__31035 = cljs.core.count.call(null,c__25556__auto___31032);
var G__31036 = (0);
seq__31017_31021 = G__31033;
chunk__31018_31022 = G__31034;
count__31019_31023 = G__31035;
i__31020_31024 = G__31036;
continue;
} else {
var ns_31037 = cljs.core.first.call(null,seq__31017_31031__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_31037);

var G__31038 = cljs.core.next.call(null,seq__31017_31031__$1);
var G__31039 = null;
var G__31040 = (0);
var G__31041 = (0);
seq__31017_31021 = G__31038;
chunk__31018_31022 = G__31039;
count__31019_31023 = G__31040;
i__31020_31024 = G__31041;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__24745__auto__ = goog.require__;
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__31042__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__31042 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__31043__i = 0, G__31043__a = new Array(arguments.length -  0);
while (G__31043__i < G__31043__a.length) {G__31043__a[G__31043__i] = arguments[G__31043__i + 0]; ++G__31043__i;}
  args = new cljs.core.IndexedSeq(G__31043__a,0);
} 
return G__31042__delegate.call(this,args);};
G__31042.cljs$lang$maxFixedArity = 0;
G__31042.cljs$lang$applyTo = (function (arglist__31044){
var args = cljs.core.seq(arglist__31044);
return G__31042__delegate(args);
});
G__31042.cljs$core$IFn$_invoke$arity$variadic = G__31042__delegate;
return G__31042;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__31046 = cljs.core._EQ_;
var expr__31047 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__31046.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__31047))){
var path_parts = ((function (pred__31046,expr__31047){
return (function (p1__31045_SHARP_){
return clojure.string.split.call(null,p1__31045_SHARP_,/[\/\\]/);
});})(pred__31046,expr__31047))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__31046,expr__31047){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e31049){if((e31049 instanceof Error)){
var e = e31049;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e31049;

}
}})());
});
;})(path_parts,sep,root,pred__31046,expr__31047))
} else {
if(cljs.core.truth_(pred__31046.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__31047))){
return ((function (pred__31046,expr__31047){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__31046,expr__31047){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__31046,expr__31047))
);

return deferred.addErrback(((function (deferred,pred__31046,expr__31047){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__31046,expr__31047))
);
});
;})(pred__31046,expr__31047))
} else {
return ((function (pred__31046,expr__31047){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__31046,expr__31047))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__31050,callback){
var map__31053 = p__31050;
var map__31053__$1 = ((((!((map__31053 == null)))?((((map__31053.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31053.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31053):map__31053);
var file_msg = map__31053__$1;
var request_url = cljs.core.get.call(null,map__31053__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__31053,map__31053__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__31053,map__31053__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__){
return (function (state_31077){
var state_val_31078 = (state_31077[(1)]);
if((state_val_31078 === (7))){
var inst_31073 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
var statearr_31079_31099 = state_31077__$1;
(statearr_31079_31099[(2)] = inst_31073);

(statearr_31079_31099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (1))){
var state_31077__$1 = state_31077;
var statearr_31080_31100 = state_31077__$1;
(statearr_31080_31100[(2)] = null);

(statearr_31080_31100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (4))){
var inst_31057 = (state_31077[(7)]);
var inst_31057__$1 = (state_31077[(2)]);
var state_31077__$1 = (function (){var statearr_31081 = state_31077;
(statearr_31081[(7)] = inst_31057__$1);

return statearr_31081;
})();
if(cljs.core.truth_(inst_31057__$1)){
var statearr_31082_31101 = state_31077__$1;
(statearr_31082_31101[(1)] = (5));

} else {
var statearr_31083_31102 = state_31077__$1;
(statearr_31083_31102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (6))){
var state_31077__$1 = state_31077;
var statearr_31084_31103 = state_31077__$1;
(statearr_31084_31103[(2)] = null);

(statearr_31084_31103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (3))){
var inst_31075 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31077__$1,inst_31075);
} else {
if((state_val_31078 === (2))){
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31077__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_31078 === (11))){
var inst_31069 = (state_31077[(2)]);
var state_31077__$1 = (function (){var statearr_31085 = state_31077;
(statearr_31085[(8)] = inst_31069);

return statearr_31085;
})();
var statearr_31086_31104 = state_31077__$1;
(statearr_31086_31104[(2)] = null);

(statearr_31086_31104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (9))){
var inst_31061 = (state_31077[(9)]);
var inst_31063 = (state_31077[(10)]);
var inst_31065 = inst_31063.call(null,inst_31061);
var state_31077__$1 = state_31077;
var statearr_31087_31105 = state_31077__$1;
(statearr_31087_31105[(2)] = inst_31065);

(statearr_31087_31105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (5))){
var inst_31057 = (state_31077[(7)]);
var inst_31059 = figwheel.client.file_reloading.blocking_load.call(null,inst_31057);
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31077__$1,(8),inst_31059);
} else {
if((state_val_31078 === (10))){
var inst_31061 = (state_31077[(9)]);
var inst_31067 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_31061);
var state_31077__$1 = state_31077;
var statearr_31088_31106 = state_31077__$1;
(statearr_31088_31106[(2)] = inst_31067);

(statearr_31088_31106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (8))){
var inst_31057 = (state_31077[(7)]);
var inst_31063 = (state_31077[(10)]);
var inst_31061 = (state_31077[(2)]);
var inst_31062 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_31063__$1 = cljs.core.get.call(null,inst_31062,inst_31057);
var state_31077__$1 = (function (){var statearr_31089 = state_31077;
(statearr_31089[(9)] = inst_31061);

(statearr_31089[(10)] = inst_31063__$1);

return statearr_31089;
})();
if(cljs.core.truth_(inst_31063__$1)){
var statearr_31090_31107 = state_31077__$1;
(statearr_31090_31107[(1)] = (9));

} else {
var statearr_31091_31108 = state_31077__$1;
(statearr_31091_31108[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__))
;
return ((function (switch__27865__auto__,c__27977__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__27866__auto__ = null;
var figwheel$client$file_reloading$state_machine__27866__auto____0 = (function (){
var statearr_31095 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31095[(0)] = figwheel$client$file_reloading$state_machine__27866__auto__);

(statearr_31095[(1)] = (1));

return statearr_31095;
});
var figwheel$client$file_reloading$state_machine__27866__auto____1 = (function (state_31077){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_31077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e31096){if((e31096 instanceof Object)){
var ex__27869__auto__ = e31096;
var statearr_31097_31109 = state_31077;
(statearr_31097_31109[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31110 = state_31077;
state_31077 = G__31110;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__27866__auto__ = function(state_31077){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__27866__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__27866__auto____1.call(this,state_31077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__27866__auto____0;
figwheel$client$file_reloading$state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__27866__auto____1;
return figwheel$client$file_reloading$state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__))
})();
var state__27979__auto__ = (function (){var statearr_31098 = f__27978__auto__.call(null);
(statearr_31098[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_31098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__))
);

return c__27977__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__31111,callback){
var map__31114 = p__31111;
var map__31114__$1 = ((((!((map__31114 == null)))?((((map__31114.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31114.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31114):map__31114);
var file_msg = map__31114__$1;
var namespace = cljs.core.get.call(null,map__31114__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__31114,map__31114__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__31114,map__31114__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__31116){
var map__31119 = p__31116;
var map__31119__$1 = ((((!((map__31119 == null)))?((((map__31119.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31119.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31119):map__31119);
var file_msg = map__31119__$1;
var namespace = cljs.core.get.call(null,map__31119__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__24733__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__24733__auto__){
var or__24745__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
var or__24745__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__24745__auto____$1)){
return or__24745__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__24733__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__31121,callback){
var map__31124 = p__31121;
var map__31124__$1 = ((((!((map__31124 == null)))?((((map__31124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31124):map__31124);
var file_msg = map__31124__$1;
var request_url = cljs.core.get.call(null,map__31124__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__31124__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__27977__auto___31228 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto___31228,out){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto___31228,out){
return (function (state_31210){
var state_val_31211 = (state_31210[(1)]);
if((state_val_31211 === (1))){
var inst_31184 = cljs.core.seq.call(null,files);
var inst_31185 = cljs.core.first.call(null,inst_31184);
var inst_31186 = cljs.core.next.call(null,inst_31184);
var inst_31187 = files;
var state_31210__$1 = (function (){var statearr_31212 = state_31210;
(statearr_31212[(7)] = inst_31187);

(statearr_31212[(8)] = inst_31186);

(statearr_31212[(9)] = inst_31185);

return statearr_31212;
})();
var statearr_31213_31229 = state_31210__$1;
(statearr_31213_31229[(2)] = null);

(statearr_31213_31229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31211 === (2))){
var inst_31187 = (state_31210[(7)]);
var inst_31193 = (state_31210[(10)]);
var inst_31192 = cljs.core.seq.call(null,inst_31187);
var inst_31193__$1 = cljs.core.first.call(null,inst_31192);
var inst_31194 = cljs.core.next.call(null,inst_31192);
var inst_31195 = (inst_31193__$1 == null);
var inst_31196 = cljs.core.not.call(null,inst_31195);
var state_31210__$1 = (function (){var statearr_31214 = state_31210;
(statearr_31214[(11)] = inst_31194);

(statearr_31214[(10)] = inst_31193__$1);

return statearr_31214;
})();
if(inst_31196){
var statearr_31215_31230 = state_31210__$1;
(statearr_31215_31230[(1)] = (4));

} else {
var statearr_31216_31231 = state_31210__$1;
(statearr_31216_31231[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31211 === (3))){
var inst_31208 = (state_31210[(2)]);
var state_31210__$1 = state_31210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31210__$1,inst_31208);
} else {
if((state_val_31211 === (4))){
var inst_31193 = (state_31210[(10)]);
var inst_31198 = figwheel.client.file_reloading.reload_js_file.call(null,inst_31193);
var state_31210__$1 = state_31210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31210__$1,(7),inst_31198);
} else {
if((state_val_31211 === (5))){
var inst_31204 = cljs.core.async.close_BANG_.call(null,out);
var state_31210__$1 = state_31210;
var statearr_31217_31232 = state_31210__$1;
(statearr_31217_31232[(2)] = inst_31204);

(statearr_31217_31232[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31211 === (6))){
var inst_31206 = (state_31210[(2)]);
var state_31210__$1 = state_31210;
var statearr_31218_31233 = state_31210__$1;
(statearr_31218_31233[(2)] = inst_31206);

(statearr_31218_31233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31211 === (7))){
var inst_31194 = (state_31210[(11)]);
var inst_31200 = (state_31210[(2)]);
var inst_31201 = cljs.core.async.put_BANG_.call(null,out,inst_31200);
var inst_31187 = inst_31194;
var state_31210__$1 = (function (){var statearr_31219 = state_31210;
(statearr_31219[(7)] = inst_31187);

(statearr_31219[(12)] = inst_31201);

return statearr_31219;
})();
var statearr_31220_31234 = state_31210__$1;
(statearr_31220_31234[(2)] = null);

(statearr_31220_31234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__27977__auto___31228,out))
;
return ((function (switch__27865__auto__,c__27977__auto___31228,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____0 = (function (){
var statearr_31224 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31224[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__);

(statearr_31224[(1)] = (1));

return statearr_31224;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____1 = (function (state_31210){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_31210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e31225){if((e31225 instanceof Object)){
var ex__27869__auto__ = e31225;
var statearr_31226_31235 = state_31210;
(statearr_31226_31235[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31236 = state_31210;
state_31210 = G__31236;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__ = function(state_31210){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____1.call(this,state_31210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto___31228,out))
})();
var state__27979__auto__ = (function (){var statearr_31227 = f__27978__auto__.call(null);
(statearr_31227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto___31228);

return statearr_31227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto___31228,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__31237,opts){
var map__31241 = p__31237;
var map__31241__$1 = ((((!((map__31241 == null)))?((((map__31241.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31241.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31241):map__31241);
var eval_body__$1 = cljs.core.get.call(null,map__31241__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__31241__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__24733__auto__ = eval_body__$1;
if(cljs.core.truth_(and__24733__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__24733__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e31243){var e = e31243;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__31244_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31244_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__31253){
var vec__31254 = p__31253;
var k = cljs.core.nth.call(null,vec__31254,(0),null);
var v = cljs.core.nth.call(null,vec__31254,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__31257){
var vec__31258 = p__31257;
var k = cljs.core.nth.call(null,vec__31258,(0),null);
var v = cljs.core.nth.call(null,vec__31258,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__31264,p__31265){
var map__31512 = p__31264;
var map__31512__$1 = ((((!((map__31512 == null)))?((((map__31512.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31512.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31512):map__31512);
var opts = map__31512__$1;
var before_jsload = cljs.core.get.call(null,map__31512__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__31512__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__31512__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__31513 = p__31265;
var map__31513__$1 = ((((!((map__31513 == null)))?((((map__31513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31513):map__31513);
var msg = map__31513__$1;
var files = cljs.core.get.call(null,map__31513__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__31513__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__31513__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__27977__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__27978__auto__ = (function (){var switch__27865__auto__ = ((function (c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_31666){
var state_val_31667 = (state_31666[(1)]);
if((state_val_31667 === (7))){
var inst_31528 = (state_31666[(7)]);
var inst_31530 = (state_31666[(8)]);
var inst_31527 = (state_31666[(9)]);
var inst_31529 = (state_31666[(10)]);
var inst_31535 = cljs.core._nth.call(null,inst_31528,inst_31530);
var inst_31536 = figwheel.client.file_reloading.eval_body.call(null,inst_31535,opts);
var inst_31537 = (inst_31530 + (1));
var tmp31668 = inst_31528;
var tmp31669 = inst_31527;
var tmp31670 = inst_31529;
var inst_31527__$1 = tmp31669;
var inst_31528__$1 = tmp31668;
var inst_31529__$1 = tmp31670;
var inst_31530__$1 = inst_31537;
var state_31666__$1 = (function (){var statearr_31671 = state_31666;
(statearr_31671[(7)] = inst_31528__$1);

(statearr_31671[(8)] = inst_31530__$1);

(statearr_31671[(9)] = inst_31527__$1);

(statearr_31671[(10)] = inst_31529__$1);

(statearr_31671[(11)] = inst_31536);

return statearr_31671;
})();
var statearr_31672_31758 = state_31666__$1;
(statearr_31672_31758[(2)] = null);

(statearr_31672_31758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (20))){
var inst_31570 = (state_31666[(12)]);
var inst_31578 = figwheel.client.file_reloading.sort_files.call(null,inst_31570);
var state_31666__$1 = state_31666;
var statearr_31673_31759 = state_31666__$1;
(statearr_31673_31759[(2)] = inst_31578);

(statearr_31673_31759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (27))){
var state_31666__$1 = state_31666;
var statearr_31674_31760 = state_31666__$1;
(statearr_31674_31760[(2)] = null);

(statearr_31674_31760[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (1))){
var inst_31519 = (state_31666[(13)]);
var inst_31516 = before_jsload.call(null,files);
var inst_31517 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_31518 = (function (){return ((function (inst_31519,inst_31516,inst_31517,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31261_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31261_SHARP_);
});
;})(inst_31519,inst_31516,inst_31517,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31519__$1 = cljs.core.filter.call(null,inst_31518,files);
var inst_31520 = cljs.core.not_empty.call(null,inst_31519__$1);
var state_31666__$1 = (function (){var statearr_31675 = state_31666;
(statearr_31675[(14)] = inst_31516);

(statearr_31675[(15)] = inst_31517);

(statearr_31675[(13)] = inst_31519__$1);

return statearr_31675;
})();
if(cljs.core.truth_(inst_31520)){
var statearr_31676_31761 = state_31666__$1;
(statearr_31676_31761[(1)] = (2));

} else {
var statearr_31677_31762 = state_31666__$1;
(statearr_31677_31762[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (24))){
var state_31666__$1 = state_31666;
var statearr_31678_31763 = state_31666__$1;
(statearr_31678_31763[(2)] = null);

(statearr_31678_31763[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (39))){
var inst_31620 = (state_31666[(16)]);
var state_31666__$1 = state_31666;
var statearr_31679_31764 = state_31666__$1;
(statearr_31679_31764[(2)] = inst_31620);

(statearr_31679_31764[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (46))){
var inst_31661 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31680_31765 = state_31666__$1;
(statearr_31680_31765[(2)] = inst_31661);

(statearr_31680_31765[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (4))){
var inst_31564 = (state_31666[(2)]);
var inst_31565 = cljs.core.List.EMPTY;
var inst_31566 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_31565);
var inst_31567 = (function (){return ((function (inst_31564,inst_31565,inst_31566,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31262_SHARP_){
var and__24733__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31262_SHARP_);
if(cljs.core.truth_(and__24733__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31262_SHARP_));
} else {
return and__24733__auto__;
}
});
;})(inst_31564,inst_31565,inst_31566,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31568 = cljs.core.filter.call(null,inst_31567,files);
var inst_31569 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_31570 = cljs.core.concat.call(null,inst_31568,inst_31569);
var state_31666__$1 = (function (){var statearr_31681 = state_31666;
(statearr_31681[(12)] = inst_31570);

(statearr_31681[(17)] = inst_31566);

(statearr_31681[(18)] = inst_31564);

return statearr_31681;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_31682_31766 = state_31666__$1;
(statearr_31682_31766[(1)] = (16));

} else {
var statearr_31683_31767 = state_31666__$1;
(statearr_31683_31767[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (15))){
var inst_31554 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31684_31768 = state_31666__$1;
(statearr_31684_31768[(2)] = inst_31554);

(statearr_31684_31768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (21))){
var inst_31580 = (state_31666[(19)]);
var inst_31580__$1 = (state_31666[(2)]);
var inst_31581 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_31580__$1);
var state_31666__$1 = (function (){var statearr_31685 = state_31666;
(statearr_31685[(19)] = inst_31580__$1);

return statearr_31685;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31666__$1,(22),inst_31581);
} else {
if((state_val_31667 === (31))){
var inst_31664 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31666__$1,inst_31664);
} else {
if((state_val_31667 === (32))){
var inst_31620 = (state_31666[(16)]);
var inst_31625 = inst_31620.cljs$lang$protocol_mask$partition0$;
var inst_31626 = (inst_31625 & (64));
var inst_31627 = inst_31620.cljs$core$ISeq$;
var inst_31628 = (inst_31626) || (inst_31627);
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31628)){
var statearr_31686_31769 = state_31666__$1;
(statearr_31686_31769[(1)] = (35));

} else {
var statearr_31687_31770 = state_31666__$1;
(statearr_31687_31770[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (40))){
var inst_31641 = (state_31666[(20)]);
var inst_31640 = (state_31666[(2)]);
var inst_31641__$1 = cljs.core.get.call(null,inst_31640,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_31642 = cljs.core.get.call(null,inst_31640,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_31643 = cljs.core.not_empty.call(null,inst_31641__$1);
var state_31666__$1 = (function (){var statearr_31688 = state_31666;
(statearr_31688[(20)] = inst_31641__$1);

(statearr_31688[(21)] = inst_31642);

return statearr_31688;
})();
if(cljs.core.truth_(inst_31643)){
var statearr_31689_31771 = state_31666__$1;
(statearr_31689_31771[(1)] = (41));

} else {
var statearr_31690_31772 = state_31666__$1;
(statearr_31690_31772[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (33))){
var state_31666__$1 = state_31666;
var statearr_31691_31773 = state_31666__$1;
(statearr_31691_31773[(2)] = false);

(statearr_31691_31773[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (13))){
var inst_31540 = (state_31666[(22)]);
var inst_31544 = cljs.core.chunk_first.call(null,inst_31540);
var inst_31545 = cljs.core.chunk_rest.call(null,inst_31540);
var inst_31546 = cljs.core.count.call(null,inst_31544);
var inst_31527 = inst_31545;
var inst_31528 = inst_31544;
var inst_31529 = inst_31546;
var inst_31530 = (0);
var state_31666__$1 = (function (){var statearr_31692 = state_31666;
(statearr_31692[(7)] = inst_31528);

(statearr_31692[(8)] = inst_31530);

(statearr_31692[(9)] = inst_31527);

(statearr_31692[(10)] = inst_31529);

return statearr_31692;
})();
var statearr_31693_31774 = state_31666__$1;
(statearr_31693_31774[(2)] = null);

(statearr_31693_31774[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (22))){
var inst_31580 = (state_31666[(19)]);
var inst_31584 = (state_31666[(23)]);
var inst_31588 = (state_31666[(24)]);
var inst_31583 = (state_31666[(25)]);
var inst_31583__$1 = (state_31666[(2)]);
var inst_31584__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31583__$1);
var inst_31585 = (function (){var all_files = inst_31580;
var res_SINGLEQUOTE_ = inst_31583__$1;
var res = inst_31584__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_31580,inst_31584,inst_31588,inst_31583,inst_31583__$1,inst_31584__$1,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31263_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__31263_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_31580,inst_31584,inst_31588,inst_31583,inst_31583__$1,inst_31584__$1,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31586 = cljs.core.filter.call(null,inst_31585,inst_31583__$1);
var inst_31587 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_31588__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31587);
var inst_31589 = cljs.core.not_empty.call(null,inst_31588__$1);
var state_31666__$1 = (function (){var statearr_31694 = state_31666;
(statearr_31694[(26)] = inst_31586);

(statearr_31694[(23)] = inst_31584__$1);

(statearr_31694[(24)] = inst_31588__$1);

(statearr_31694[(25)] = inst_31583__$1);

return statearr_31694;
})();
if(cljs.core.truth_(inst_31589)){
var statearr_31695_31775 = state_31666__$1;
(statearr_31695_31775[(1)] = (23));

} else {
var statearr_31696_31776 = state_31666__$1;
(statearr_31696_31776[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (36))){
var state_31666__$1 = state_31666;
var statearr_31697_31777 = state_31666__$1;
(statearr_31697_31777[(2)] = false);

(statearr_31697_31777[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (41))){
var inst_31641 = (state_31666[(20)]);
var inst_31645 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_31646 = cljs.core.map.call(null,inst_31645,inst_31641);
var inst_31647 = cljs.core.pr_str.call(null,inst_31646);
var inst_31648 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_31647)].join('');
var inst_31649 = figwheel.client.utils.log.call(null,inst_31648);
var state_31666__$1 = state_31666;
var statearr_31698_31778 = state_31666__$1;
(statearr_31698_31778[(2)] = inst_31649);

(statearr_31698_31778[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (43))){
var inst_31642 = (state_31666[(21)]);
var inst_31652 = (state_31666[(2)]);
var inst_31653 = cljs.core.not_empty.call(null,inst_31642);
var state_31666__$1 = (function (){var statearr_31699 = state_31666;
(statearr_31699[(27)] = inst_31652);

return statearr_31699;
})();
if(cljs.core.truth_(inst_31653)){
var statearr_31700_31779 = state_31666__$1;
(statearr_31700_31779[(1)] = (44));

} else {
var statearr_31701_31780 = state_31666__$1;
(statearr_31701_31780[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (29))){
var inst_31586 = (state_31666[(26)]);
var inst_31580 = (state_31666[(19)]);
var inst_31584 = (state_31666[(23)]);
var inst_31588 = (state_31666[(24)]);
var inst_31620 = (state_31666[(16)]);
var inst_31583 = (state_31666[(25)]);
var inst_31616 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_31619 = (function (){var all_files = inst_31580;
var res_SINGLEQUOTE_ = inst_31583;
var res = inst_31584;
var files_not_loaded = inst_31586;
var dependencies_that_loaded = inst_31588;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31620,inst_31583,inst_31616,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31618){
var map__31702 = p__31618;
var map__31702__$1 = ((((!((map__31702 == null)))?((((map__31702.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31702.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31702):map__31702);
var namespace = cljs.core.get.call(null,map__31702__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31620,inst_31583,inst_31616,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31620__$1 = cljs.core.group_by.call(null,inst_31619,inst_31586);
var inst_31622 = (inst_31620__$1 == null);
var inst_31623 = cljs.core.not.call(null,inst_31622);
var state_31666__$1 = (function (){var statearr_31704 = state_31666;
(statearr_31704[(28)] = inst_31616);

(statearr_31704[(16)] = inst_31620__$1);

return statearr_31704;
})();
if(inst_31623){
var statearr_31705_31781 = state_31666__$1;
(statearr_31705_31781[(1)] = (32));

} else {
var statearr_31706_31782 = state_31666__$1;
(statearr_31706_31782[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (44))){
var inst_31642 = (state_31666[(21)]);
var inst_31655 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_31642);
var inst_31656 = cljs.core.pr_str.call(null,inst_31655);
var inst_31657 = [cljs.core.str("not required: "),cljs.core.str(inst_31656)].join('');
var inst_31658 = figwheel.client.utils.log.call(null,inst_31657);
var state_31666__$1 = state_31666;
var statearr_31707_31783 = state_31666__$1;
(statearr_31707_31783[(2)] = inst_31658);

(statearr_31707_31783[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (6))){
var inst_31561 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31708_31784 = state_31666__$1;
(statearr_31708_31784[(2)] = inst_31561);

(statearr_31708_31784[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (28))){
var inst_31586 = (state_31666[(26)]);
var inst_31613 = (state_31666[(2)]);
var inst_31614 = cljs.core.not_empty.call(null,inst_31586);
var state_31666__$1 = (function (){var statearr_31709 = state_31666;
(statearr_31709[(29)] = inst_31613);

return statearr_31709;
})();
if(cljs.core.truth_(inst_31614)){
var statearr_31710_31785 = state_31666__$1;
(statearr_31710_31785[(1)] = (29));

} else {
var statearr_31711_31786 = state_31666__$1;
(statearr_31711_31786[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (25))){
var inst_31584 = (state_31666[(23)]);
var inst_31600 = (state_31666[(2)]);
var inst_31601 = cljs.core.not_empty.call(null,inst_31584);
var state_31666__$1 = (function (){var statearr_31712 = state_31666;
(statearr_31712[(30)] = inst_31600);

return statearr_31712;
})();
if(cljs.core.truth_(inst_31601)){
var statearr_31713_31787 = state_31666__$1;
(statearr_31713_31787[(1)] = (26));

} else {
var statearr_31714_31788 = state_31666__$1;
(statearr_31714_31788[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (34))){
var inst_31635 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31635)){
var statearr_31715_31789 = state_31666__$1;
(statearr_31715_31789[(1)] = (38));

} else {
var statearr_31716_31790 = state_31666__$1;
(statearr_31716_31790[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (17))){
var state_31666__$1 = state_31666;
var statearr_31717_31791 = state_31666__$1;
(statearr_31717_31791[(2)] = recompile_dependents);

(statearr_31717_31791[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (3))){
var state_31666__$1 = state_31666;
var statearr_31718_31792 = state_31666__$1;
(statearr_31718_31792[(2)] = null);

(statearr_31718_31792[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (12))){
var inst_31557 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31719_31793 = state_31666__$1;
(statearr_31719_31793[(2)] = inst_31557);

(statearr_31719_31793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (2))){
var inst_31519 = (state_31666[(13)]);
var inst_31526 = cljs.core.seq.call(null,inst_31519);
var inst_31527 = inst_31526;
var inst_31528 = null;
var inst_31529 = (0);
var inst_31530 = (0);
var state_31666__$1 = (function (){var statearr_31720 = state_31666;
(statearr_31720[(7)] = inst_31528);

(statearr_31720[(8)] = inst_31530);

(statearr_31720[(9)] = inst_31527);

(statearr_31720[(10)] = inst_31529);

return statearr_31720;
})();
var statearr_31721_31794 = state_31666__$1;
(statearr_31721_31794[(2)] = null);

(statearr_31721_31794[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (23))){
var inst_31586 = (state_31666[(26)]);
var inst_31580 = (state_31666[(19)]);
var inst_31584 = (state_31666[(23)]);
var inst_31588 = (state_31666[(24)]);
var inst_31583 = (state_31666[(25)]);
var inst_31591 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_31593 = (function (){var all_files = inst_31580;
var res_SINGLEQUOTE_ = inst_31583;
var res = inst_31584;
var files_not_loaded = inst_31586;
var dependencies_that_loaded = inst_31588;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31591,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31592){
var map__31722 = p__31592;
var map__31722__$1 = ((((!((map__31722 == null)))?((((map__31722.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31722.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31722):map__31722);
var request_url = cljs.core.get.call(null,map__31722__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31591,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31594 = cljs.core.reverse.call(null,inst_31588);
var inst_31595 = cljs.core.map.call(null,inst_31593,inst_31594);
var inst_31596 = cljs.core.pr_str.call(null,inst_31595);
var inst_31597 = figwheel.client.utils.log.call(null,inst_31596);
var state_31666__$1 = (function (){var statearr_31724 = state_31666;
(statearr_31724[(31)] = inst_31591);

return statearr_31724;
})();
var statearr_31725_31795 = state_31666__$1;
(statearr_31725_31795[(2)] = inst_31597);

(statearr_31725_31795[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (35))){
var state_31666__$1 = state_31666;
var statearr_31726_31796 = state_31666__$1;
(statearr_31726_31796[(2)] = true);

(statearr_31726_31796[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (19))){
var inst_31570 = (state_31666[(12)]);
var inst_31576 = figwheel.client.file_reloading.expand_files.call(null,inst_31570);
var state_31666__$1 = state_31666;
var statearr_31727_31797 = state_31666__$1;
(statearr_31727_31797[(2)] = inst_31576);

(statearr_31727_31797[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (11))){
var state_31666__$1 = state_31666;
var statearr_31728_31798 = state_31666__$1;
(statearr_31728_31798[(2)] = null);

(statearr_31728_31798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (9))){
var inst_31559 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31729_31799 = state_31666__$1;
(statearr_31729_31799[(2)] = inst_31559);

(statearr_31729_31799[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (5))){
var inst_31530 = (state_31666[(8)]);
var inst_31529 = (state_31666[(10)]);
var inst_31532 = (inst_31530 < inst_31529);
var inst_31533 = inst_31532;
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31533)){
var statearr_31730_31800 = state_31666__$1;
(statearr_31730_31800[(1)] = (7));

} else {
var statearr_31731_31801 = state_31666__$1;
(statearr_31731_31801[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (14))){
var inst_31540 = (state_31666[(22)]);
var inst_31549 = cljs.core.first.call(null,inst_31540);
var inst_31550 = figwheel.client.file_reloading.eval_body.call(null,inst_31549,opts);
var inst_31551 = cljs.core.next.call(null,inst_31540);
var inst_31527 = inst_31551;
var inst_31528 = null;
var inst_31529 = (0);
var inst_31530 = (0);
var state_31666__$1 = (function (){var statearr_31732 = state_31666;
(statearr_31732[(7)] = inst_31528);

(statearr_31732[(8)] = inst_31530);

(statearr_31732[(9)] = inst_31527);

(statearr_31732[(10)] = inst_31529);

(statearr_31732[(32)] = inst_31550);

return statearr_31732;
})();
var statearr_31733_31802 = state_31666__$1;
(statearr_31733_31802[(2)] = null);

(statearr_31733_31802[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (45))){
var state_31666__$1 = state_31666;
var statearr_31734_31803 = state_31666__$1;
(statearr_31734_31803[(2)] = null);

(statearr_31734_31803[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (26))){
var inst_31586 = (state_31666[(26)]);
var inst_31580 = (state_31666[(19)]);
var inst_31584 = (state_31666[(23)]);
var inst_31588 = (state_31666[(24)]);
var inst_31583 = (state_31666[(25)]);
var inst_31603 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_31605 = (function (){var all_files = inst_31580;
var res_SINGLEQUOTE_ = inst_31583;
var res = inst_31584;
var files_not_loaded = inst_31586;
var dependencies_that_loaded = inst_31588;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31603,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31604){
var map__31735 = p__31604;
var map__31735__$1 = ((((!((map__31735 == null)))?((((map__31735.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31735.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31735):map__31735);
var namespace = cljs.core.get.call(null,map__31735__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__31735__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31603,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31606 = cljs.core.map.call(null,inst_31605,inst_31584);
var inst_31607 = cljs.core.pr_str.call(null,inst_31606);
var inst_31608 = figwheel.client.utils.log.call(null,inst_31607);
var inst_31609 = (function (){var all_files = inst_31580;
var res_SINGLEQUOTE_ = inst_31583;
var res = inst_31584;
var files_not_loaded = inst_31586;
var dependencies_that_loaded = inst_31588;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31603,inst_31605,inst_31606,inst_31607,inst_31608,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31586,inst_31580,inst_31584,inst_31588,inst_31583,inst_31603,inst_31605,inst_31606,inst_31607,inst_31608,state_val_31667,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31610 = setTimeout(inst_31609,(10));
var state_31666__$1 = (function (){var statearr_31737 = state_31666;
(statearr_31737[(33)] = inst_31603);

(statearr_31737[(34)] = inst_31608);

return statearr_31737;
})();
var statearr_31738_31804 = state_31666__$1;
(statearr_31738_31804[(2)] = inst_31610);

(statearr_31738_31804[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (16))){
var state_31666__$1 = state_31666;
var statearr_31739_31805 = state_31666__$1;
(statearr_31739_31805[(2)] = reload_dependents);

(statearr_31739_31805[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (38))){
var inst_31620 = (state_31666[(16)]);
var inst_31637 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31620);
var state_31666__$1 = state_31666;
var statearr_31740_31806 = state_31666__$1;
(statearr_31740_31806[(2)] = inst_31637);

(statearr_31740_31806[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (30))){
var state_31666__$1 = state_31666;
var statearr_31741_31807 = state_31666__$1;
(statearr_31741_31807[(2)] = null);

(statearr_31741_31807[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (10))){
var inst_31540 = (state_31666[(22)]);
var inst_31542 = cljs.core.chunked_seq_QMARK_.call(null,inst_31540);
var state_31666__$1 = state_31666;
if(inst_31542){
var statearr_31742_31808 = state_31666__$1;
(statearr_31742_31808[(1)] = (13));

} else {
var statearr_31743_31809 = state_31666__$1;
(statearr_31743_31809[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (18))){
var inst_31574 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31574)){
var statearr_31744_31810 = state_31666__$1;
(statearr_31744_31810[(1)] = (19));

} else {
var statearr_31745_31811 = state_31666__$1;
(statearr_31745_31811[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (42))){
var state_31666__$1 = state_31666;
var statearr_31746_31812 = state_31666__$1;
(statearr_31746_31812[(2)] = null);

(statearr_31746_31812[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (37))){
var inst_31632 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31747_31813 = state_31666__$1;
(statearr_31747_31813[(2)] = inst_31632);

(statearr_31747_31813[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (8))){
var inst_31540 = (state_31666[(22)]);
var inst_31527 = (state_31666[(9)]);
var inst_31540__$1 = cljs.core.seq.call(null,inst_31527);
var state_31666__$1 = (function (){var statearr_31748 = state_31666;
(statearr_31748[(22)] = inst_31540__$1);

return statearr_31748;
})();
if(inst_31540__$1){
var statearr_31749_31814 = state_31666__$1;
(statearr_31749_31814[(1)] = (10));

} else {
var statearr_31750_31815 = state_31666__$1;
(statearr_31750_31815[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__27865__auto__,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____0 = (function (){
var statearr_31754 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31754[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__);

(statearr_31754[(1)] = (1));

return statearr_31754;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____1 = (function (state_31666){
while(true){
var ret_value__27867__auto__ = (function (){try{while(true){
var result__27868__auto__ = switch__27865__auto__.call(null,state_31666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__27868__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27868__auto__;
}
break;
}
}catch (e31755){if((e31755 instanceof Object)){
var ex__27869__auto__ = e31755;
var statearr_31756_31816 = state_31666;
(statearr_31756_31816[(5)] = ex__27869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__27867__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31817 = state_31666;
state_31666 = G__31817;
continue;
} else {
return ret_value__27867__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__ = function(state_31666){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____1.call(this,state_31666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__27866__auto__;
})()
;})(switch__27865__auto__,c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__27979__auto__ = (function (){var statearr_31757 = f__27978__auto__.call(null);
(statearr_31757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__27977__auto__);

return statearr_31757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__27979__auto__);
});})(c__27977__auto__,map__31512,map__31512__$1,opts,before_jsload,on_jsload,reload_dependents,map__31513,map__31513__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__27977__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__31820,link){
var map__31823 = p__31820;
var map__31823__$1 = ((((!((map__31823 == null)))?((((map__31823.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31823.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31823):map__31823);
var file = cljs.core.get.call(null,map__31823__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__31823,map__31823__$1,file){
return (function (p1__31818_SHARP_,p2__31819_SHARP_){
if(cljs.core._EQ_.call(null,p1__31818_SHARP_,p2__31819_SHARP_)){
return p1__31818_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__31823,map__31823__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__31829){
var map__31830 = p__31829;
var map__31830__$1 = ((((!((map__31830 == null)))?((((map__31830.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31830.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31830):map__31830);
var match_length = cljs.core.get.call(null,map__31830__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__31830__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__31825_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__31825_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args31832 = [];
var len__25820__auto___31835 = arguments.length;
var i__25821__auto___31836 = (0);
while(true){
if((i__25821__auto___31836 < len__25820__auto___31835)){
args31832.push((arguments[i__25821__auto___31836]));

var G__31837 = (i__25821__auto___31836 + (1));
i__25821__auto___31836 = G__31837;
continue;
} else {
}
break;
}

var G__31834 = args31832.length;
switch (G__31834) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31832.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__31839_SHARP_,p2__31840_SHARP_){
return cljs.core.assoc.call(null,p1__31839_SHARP_,cljs.core.get.call(null,p2__31840_SHARP_,key),p2__31840_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__31841){
var map__31844 = p__31841;
var map__31844__$1 = ((((!((map__31844 == null)))?((((map__31844.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31844.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31844):map__31844);
var f_data = map__31844__$1;
var file = cljs.core.get.call(null,map__31844__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__31846,p__31847){
var map__31856 = p__31846;
var map__31856__$1 = ((((!((map__31856 == null)))?((((map__31856.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31856.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31856):map__31856);
var opts = map__31856__$1;
var on_cssload = cljs.core.get.call(null,map__31856__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__31857 = p__31847;
var map__31857__$1 = ((((!((map__31857 == null)))?((((map__31857.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31857.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31857):map__31857);
var files_msg = map__31857__$1;
var files = cljs.core.get.call(null,map__31857__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__31860_31864 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__31861_31865 = null;
var count__31862_31866 = (0);
var i__31863_31867 = (0);
while(true){
if((i__31863_31867 < count__31862_31866)){
var f_31868 = cljs.core._nth.call(null,chunk__31861_31865,i__31863_31867);
figwheel.client.file_reloading.reload_css_file.call(null,f_31868);

var G__31869 = seq__31860_31864;
var G__31870 = chunk__31861_31865;
var G__31871 = count__31862_31866;
var G__31872 = (i__31863_31867 + (1));
seq__31860_31864 = G__31869;
chunk__31861_31865 = G__31870;
count__31862_31866 = G__31871;
i__31863_31867 = G__31872;
continue;
} else {
var temp__4657__auto___31873 = cljs.core.seq.call(null,seq__31860_31864);
if(temp__4657__auto___31873){
var seq__31860_31874__$1 = temp__4657__auto___31873;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31860_31874__$1)){
var c__25556__auto___31875 = cljs.core.chunk_first.call(null,seq__31860_31874__$1);
var G__31876 = cljs.core.chunk_rest.call(null,seq__31860_31874__$1);
var G__31877 = c__25556__auto___31875;
var G__31878 = cljs.core.count.call(null,c__25556__auto___31875);
var G__31879 = (0);
seq__31860_31864 = G__31876;
chunk__31861_31865 = G__31877;
count__31862_31866 = G__31878;
i__31863_31867 = G__31879;
continue;
} else {
var f_31880 = cljs.core.first.call(null,seq__31860_31874__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_31880);

var G__31881 = cljs.core.next.call(null,seq__31860_31874__$1);
var G__31882 = null;
var G__31883 = (0);
var G__31884 = (0);
seq__31860_31864 = G__31881;
chunk__31861_31865 = G__31882;
count__31862_31866 = G__31883;
i__31863_31867 = G__31884;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__31856,map__31856__$1,opts,on_cssload,map__31857,map__31857__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__31856,map__31856__$1,opts,on_cssload,map__31857,map__31857__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1473150052926