(ns klipse-clj.repl
  (:require
    [cljs.analyzer :as ana]
    [cljs.js :as cljs]))

(defonce ^:public current-ns-eval (atom 'cljs.user))
(defonce ^:public current-ns-compile (atom 'cljs.user))

(defn reset-ns-eval! []
  (reset! current-ns-eval 'cljs.user))

(defn reset-ns-compile! []
  (reset! current-ns-compile 'cljs.user))

(defonce st (atom nil))

(defn reset-state-eval! []
  (reset! st nil))

(def st-compile (atom nil))

(defn create-state-compile []
  (when (nil? @st-compile)
    (reset! st-compile (cljs/empty-state)))
  @st-compile)

(defn reset-state-compile! []
  (reset! st-compile nil))

(defn eval-form
  ([form]
   (eval-form form (.-name *ns*)))
  ([form ns]
   (let [result (atom nil)]
     (cljs/eval @st form
                {:ns            ns
                 :context       :expr
                 :eval          cljs/js-eval
                 :def-emits-var true}
                (fn [{:keys [value error]}]
                  (if error
                    error
                    (reset! result value))))
     @result)))

(defn def-a-var
  ([ns name]
   (when-let [the-ns (find-ns (cond-> ns (instance? Namespace ns) ns-name))]
     (eval-form `(def ~name) (ns-name the-ns))))
  ([ns name val]
   (when-let [the-ns (find-ns (cond-> ns (instance? Namespace ns) ns-name))]
     (eval-form `(def ~name ~val) (ns-name the-ns)))))

(defn current-alias-map
  ([] (current-alias-map @current-ns-eval @st))
  ([ns state]
   (->> (merge (get-in @state [::ana/namespaces ns :requires])
               (get-in @state [::ana/namespaces ns :require-macros]))
        (remove (fn [[k v]] (= k v)))
        (into {}))))
