(ns usermedia.core
	(:require [cljs.core.async :refer [chan put! <!]])
 	(:use-macros [purnam.core :only [!>]]
 				 [cljs.core.async.macros :only [go]]))

(defn find-label? [part label]
	(not (nil? (re-find part label))))

(defn find-source-info [label source-infos]
	(first (filter #(find-label? label (:label %)) source-infos)))

(defn constraints-with-source [constraints id]
	(assoc-in constraints [:audio :optional] [{:sourceId id}]))

(defn get-user-media [constraints]
	(let [c (chan)]
		(!> js/navigator.webkitGetUserMedia
			(clj->js constraints)
	      #(put! c [:ok %])
	      #(put! c [:error %]))
		c))

(defn get-user-media-id-by-label [label]
	(let [c (chan)]
		(!> js/MediaStreamTrack.getSources (fn [sourceInfos] 
			(let [source-infos (js->clj sourceInfos :keywordize-keys true)
				  	source-info-selected (find-source-info label source-infos)]
				(if (nil? source-info-selected)
					(put! c [:error "NOT_FOUND"])
					(put! c [:ok (:id source-info-selected)])))))
		c))

(defn reget-user-media-by-label [label constraints]
	(go
		(let [[status data] (<! (get-user-media-id-by-label label))]
			(case status
				:error [status data]
				:ok (<! (get-user-media (constraints-with-source constraints data)))))))

(defn get-user-media-by-label [label constraints]
	(go
		(let [[status data] (<! (get-user-media constraints))]
			(case status
				:error [status data]
				:ok (<! (reget-user-media-by-label label constraints))))))
