/*
 * Decompiled with CFR 0.152.
 */
package vimclojure.nailgun;

import vimclojure.nailgun.NGServer;
import vimclojure.nailgun.NGSession;

class NGSessionPool {
    int poolSize = 0;
    NGSession[] pool = null;
    int poolEntries = 0;
    NGServer server = null;
    boolean done = false;
    private Object lock = new Object();

    NGSessionPool(NGServer server, int maxIdle) {
        this.server = server;
        this.poolSize = maxIdle - 1;
        this.pool = new NGSession[this.poolSize];
        this.poolEntries = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        NGSession result;
        Object object = this.lock;
        synchronized (object) {
            if (this.poolEntries == 0) {
                result = new NGSession(this, this.server);
                result.start();
            } else {
                --this.poolEntries;
                result = this.pool[this.poolEntries];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession session) {
        if (this.done || this.poolEntries == this.poolSize) {
            session.shutdown();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.pool[this.poolEntries] = session;
                ++this.poolEntries;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.done = true;
        Object object = this.lock;
        synchronized (object) {
            while (this.poolEntries > 0) {
                this.take().shutdown();
            }
        }
    }
}

