/*
 * Decompiled with CFR 0.152.
 */
package vimclojure.nailgun;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import vimclojure.nailgun.LongUtils;

class NGInputStream
extends FilterInputStream {
    private byte[] header = new byte[5];
    private boolean eof = false;
    private long remaining = 0L;

    public NGInputStream(InputStream in) {
        super(in);
    }

    private void readHeader() throws IOException {
        if (this.eof) {
            return;
        }
        int thisPass = 0;
        for (int bytesRead = this.in.read(this.header); bytesRead < 5; bytesRead += thisPass) {
            thisPass = this.in.read(this.header, bytesRead, 5 - bytesRead);
            if (thisPass >= 0) continue;
            this.eof = true;
            return;
        }
        switch (this.header[4]) {
            case 48: {
                this.remaining = LongUtils.fromArray(this.header, 0);
                break;
            }
            case 46: {
                this.eof = true;
                break;
            }
            default: {
                throw new IOException("Unknown stream type: " + (char)this.header[4]);
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.remaining > 0L) {
            return this.in.available();
        }
        return Math.max(0, this.in.available() - 5);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.header, 0, 1) == -1 ? -1 : this.header[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.remaining == 0L) {
            this.readHeader();
        }
        if (this.eof) {
            return -1;
        }
        int bytesToRead = Math.min((int)this.remaining, length);
        int result = this.in.read(b, offset, bytesToRead);
        this.remaining -= (long)result;
        return result;
    }
}

