# multistub [![pipeline status](https://gitlab.com/vise890/multistub/badges/master/pipeline.svg)](https://gitlab.com/vise890/multistub/commits/master)

A set of utilities for stubbing Clojure multi-methods.

## [API Docs](https://vise890.gitlab.io/multistub/)

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/vise890/multistub.svg)](https://clojars.org/vise890/multistub)

```clojure
;;; project.clj
[vise890/multistub "0.1.1"]
```

```clojure
(require '[vise890.multistub.core :refer :all])

(defmulti my-multi-1 identity)
(defmulti my-multi-2 identity)

(defmethod my-multi-1 :default [x] :original-val-1)
(defmethod my-multi-2 :default [x] :original-val-2)

;; stub a single multimethod
(with-multi-stub
  my-multi-1 :x (fn [_] :my-stub-val)
  (fn [] (my-multi-1 :x)))
;; => :my-stub-val


;; stub multiple multimethods:
(with-multi-stubs
  [my-multi-1 :x (fn [_] :stub-val-x1)
   my-multi-2 :y (fn [_] :stub-val-y2)]
  (fn []
    [(my-multi-1 :x)
     (my-multi-2 :x)
     (my-multi-2 :y)]))
;; => [:stub-val-x1 :original-val-2 :stub-val-y2]


;; stub multiple multimethods for the same dispatch value:
(with-dispatch-value-multi-stubs :x
  [my-multi-1 (fn [_] :stub-val-x1)
   my-multi-2 (fn [_] :stub-val-x2)]
  (fn []
    [(my-multi-1 :x)
     (my-multi-2 :x)
     (my-multi-2 :y)]))
;; => [:stub-val-x1 :stub-val-x2 :original-val-2]


;; BONUS fn!
(with-around-fns [with-zookeeper-fn with-kafka-fn]
                 produce-stuff-on-kafka-fn)
```

## License

Copyright © 2018 Martino Visintin

Distributed under the Eclipse Public License either version 1.0 or (at your
option) any later version.
