(ns scribe.specs
  "Clojure spec definitions for scribe specs."
  (:require [clojure.spec.alpha :as s]))

(s/def :scribe/type keyword?)

(defn- type= [t m]
  (= t (:scribe/type m)))

(defn- ->type [type]
  (s/and (s/keys :req [:scribe/type])
         (partial type= type)))

(s/def ::string (->type :string))

(s/def :scribe/precision integer?)
(s/def :scribe/scale integer?)
(s/def ::decimal
  (s/and (->type :decimal)
         (s/keys :req [:scribe/precision
                       :scribe/scale])))

(s/def ::date (->type :date))
(s/def ::timestamp-micros (->type :timestamp-micros))
(s/def ::timestamp-millis (->type :timestamp-millis))
(s/def ::time-millis (->type :time-millis))
(s/def ::time-micros (->type :time-micros))

(s/def :scribe/coll-of
  (s/or :spec-ref keyword?
        :scribe/spec :scribe/spec))
(s/def ::coll-of
  (s/keys :req [:scribe/coll-of]))

(s/def ::keys-coll (s/coll-of keyword?))
(s/def :scribe.keys/req ::keys-coll)
(s/def :scribe.keys/req-un ::keys-coll)
(s/def :scribe.keys/opt ::keys-coll)
(s/def :scribe.keys/opt-un ::keys-coll)
(s/def :scribe/keys
  (s/keys ::opt [:scribe.keys/req
                 :scribe.keys/req-un
                 :scribe.keys/opt
                 :scribe.keys/opt-un]))

(s/def :scribe/spec
  (s/or :string ::string
        :decimal ::decimal
        :date ::date
        :timestamp-millis ::timestamp-millis
        :timestamp-micros ::timestamp-micros
        :time-millis ::time-millis
        :time-micros ::time-micros
        :coll-of ::coll-of))
(s/def ::spec :scribe/spec)

(defn variant
  "Returns the variant of the given scribe spec

  (e.g. :string, :decimal, :time-millis, :coll-of, etc.)"
  [x]
  (first (s/conform ::spec x)))
