(ns scribe.spec.core
  "Scribe spec to Clojure Spec conversions."
  (:require [clojure.spec.alpha :as s]
            scribe.specs))

(defmulti ->clj-spec scribe.specs/variant)

(defmethod ->clj-spec :string [_] string?)
(defmethod ->clj-spec :boolean [_] boolean?)

;; TODO actually check precision and scale
(defmethod ->clj-spec :decimal [_] decimal?)

;; TODO implement me
(defmethod ->clj-spec :coll-of [scribe-spec]
  (s/coll-of (:scribe/coll-of scribe-spec)))

;;,---------------
;;| Here be macros
;;`---------------
(defmacro defspec [spec-name scribe-spec]
  (let [clj-spec (->clj-spec scribe-spec)]
    `(s/def ~spec-name ~clj-spec)))

(defmacro defspecs [registry]
  `(do ~@(for [[spec-name scribe-spec] registry
               :let [clj-spec (->clj-spec scribe-spec)]]
           `(s/def ~spec-name ~clj-spec))))
