(ns scribe.utils
  (:require [medley.core :refer [map-keys]]))

(defn disqualify-key [k] (-> k name keyword))
(defn disqualify-keys [m] (map-keys disqualify-key m))
(defn qualify-key [ns k] (keyword (name ns) (name k)))
(defn qualify-keys [m ns] (map-keys (partial qualify-key ns) m))

(defn ns= [ns k] (= (name ns) (namespace k)))

(defn update-some
  "Updates a key with a fn in a map, if and only if the value in the map is
  present."
  ([m k f]
   (if-not (find m k) m (update m k f)))
  ([m k f & kfs]
   (reduce (fn [m [k f]] (update-some m k f))
           (update-some m k f)
           (partition 2 kfs))))

(defn kwargs->m
  [kwargs]
  ;; TODO nicer impl
  (->> kwargs
       (partition 2)
       (map vec)
       (into {})))
