(ns chronos.joda-time
  (:require [chronos.specs :as cs])
  (:import [org.joda.time DateTime DateTimeZone Instant LocalDate LocalTime]))

(def utc ^DateTimeZone (DateTimeZone/UTC))

;;,--------
;;| Instant
;;`--------
(defmethod cs/instant? org.joda.time.Instant [_] true)

(defmethod cs/to-epoch-milli org.joda.time.Instant
  [^Instant i]
  (.getMillis i))

(defmethod cs/of-epoch-milli org.joda.time.Instant
  [_ ^long ms]
  (Instant. ms))

;;,---------
;;| DateTime
;;`---------
(defmethod cs/instant? org.joda.time.DateTime [_] true)

(defmethod cs/to-epoch-milli org.joda.time.DateTime
  [^DateTime dt]
  (-> dt (.toDateTime utc) .toInstant .getMillis))

(defmethod cs/of-epoch-milli org.joda.time.DateTime
  [_ ^long ms]
  (-> ms Instant. (DateTime. utc)))

;;,----------
;;| LocalDate
;;`----------
(defmethod cs/local-date? org.joda.time.LocalDate [_] true)

(defmethod cs/to-epoch-day org.joda.time.LocalDate
  [^LocalDate ld]
  (.toEpochDay ld))

(defmethod cs/of-epoch-day org.joda.time.LocalDate
  [_ days]
  (-> (LocalDate. (int 0) (int 0) (int 0))
      (.plusDays (int days))))

;;,----------
;;| LocalTime
;;`----------
(defmethod cs/local-time? org.joda.time.LocalTime [_] true)

(defmethod cs/to-milli-of-day org.joda.time.LocalTime
  [^LocalTime lt]
  (.getMillisOfDay lt))

(defmethod cs/of-milli-of-day org.joda.time.LocalTime
  [_ ms]
  (-> (LocalTime. (int 0) (int 0))
      (.plusMillis ms)))

;;,-------
;;| Period
;;`-------

;; ??? org.joda.time.Period doesn't match Avro period?
