(ns scribe.time.java8-time

  "Implementation of scribe.time.core conversions and predicates for java 8
  java.time classes."

  (:require [scribe.time.core :as cs]
            [scribe.time.utils :as u])
  (:import [java.time Instant LocalDate LocalTime]))

;;,--------
;;| Instant
;;`--------
(defmethod cs/instant? java.time.Instant [_] true)

(defmethod cs/to-epoch-milli java.time.Instant
  [^Instant i]
  (.toEpochMilli i))

(defmethod cs/of-epoch-milli java.time.Instant
  [_ ms]
  (Instant/ofEpochMilli ms))

(defmethod cs/to-epoch-micro java.time.Instant
  [^Instant i]
  ;; TODO ??? something like this?
  #_(+ (secons->micros (.getLong i))
       (nanos->micros! (.getNano i)))
  (u/not-implemented!))

(defmethod cs/of-epoch-micro java.time.Instant
  [_ µs]
  (u/not-implemented!))

;;,----------
;;| LocalDate
;;`----------
(defmethod cs/local-date? java.time.LocalDate [_] true)

(defmethod cs/to-epoch-day java.time.LocalDate
  [^LocalDate ld]
  (.toEpochDay ld))

(defmethod cs/of-epoch-day java.time.LocalDate
  [_ days]
  (LocalDate/ofEpochDay days))

;;,----------
;;| LocalTime
;;`----------
(defmethod cs/local-time? java.time.LocalTime [_] true)

(defmethod cs/to-milli-of-day java.time.LocalTime
  [^LocalTime lt]
  (-> lt .toNanoOfDay u/nanos->millis!))

(defmethod cs/of-milli-of-day java.time.LocalTime
  [_ ms]
  (LocalTime/ofNanoOfDay (u/millis->nanos ms)))

(defmethod cs/to-micro-of-day java.time.LocalTime
  [^LocalTime lt]
  (-> lt .toNanoOfDay u/nanos->micros!))

(defmethod cs/of-micro-of-day java.time.LocalTime
  [_ µs]
  (LocalTime/ofNanoOfDay (u/micros->nanos µs)))

;;,-------
;;| Period
;;`-------

;; ??? java.time.Period doesn't match Avro period?
