(ns scribe.time.joda.instant
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as cs])
  (:import org.joda.time.Instant))

(defn ^Instant now [] (Instant/now))

(defmethod cs/instant? org.joda.time.Instant [_] true)

(defmethod cs/to-epoch-milli org.joda.time.Instant
  [^Instant i]
  (.getMillis i))

(defmethod cs/of-epoch-milli org.joda.time.Instant
  [_ ^long ms]
  (Instant. ms))
