(ns scribe.time.joda.local-date
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as cs])
  (:import java.time.chrono.ChronoLocalDate
           org.joda.time.LocalDate))

(defn now ^LocalDate [] (LocalDate/now))

(defmethod cs/local-date? org.joda.time.LocalDate [_] true)

(defmethod cs/to-epoch-day org.joda.time.LocalDate
  [^ChronoLocalDate ld]
  (.toEpochDay ld))

(defmethod cs/of-epoch-day org.joda.time.LocalDate
  [_ days]
  (-> (LocalDate. (int 0) (int 0) (int 0))
      (.plusDays (int days))))
