(ns scribe.time.joda.instant
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as t])
  (:import org.joda.time.Instant))

(defmethod t/instant? org.joda.time.Instant [_] true)

(defmethod t/to-epoch-milli org.joda.time.Instant
  [^Instant i]
  (.getMillis i))

(defmethod t/of-epoch-milli org.joda.time.Instant
  [_ ^long ms]
  (Instant. ms))
