(ns scribe.time.java8.instant
  "Utilities and implementations of `scribe.time.core` conversions for Java 8
  `java.time.Instant`."
  (:require [scribe.time.core :as t]
            [scribe.time.utils :as u])
  (:import java.time.Instant))

(defmethod t/instant? java.time.Instant [_] true)

(defmethod t/to-epoch-milli java.time.Instant
  [^Instant i]
  (.toEpochMilli i))

(defmethod t/of-epoch-milli java.time.Instant
  [_ ms]
  (Instant/ofEpochMilli ms))

(defmethod t/to-epoch-micro java.time.Instant
  [^Instant i]
  ;; TODO implement me
  #_(+ (secons->micros (.getLong i))
       (nanos->micros! (.getNano i)))
  (u/not-implemented!))

(defmethod t/of-epoch-micro java.time.Instant
  [_ µs]
  (u/not-implemented!))
