(ns scribe.time.java8.local-date
  "Utilities and implementations of `scribe.time.core` conversions for Java 8
  `java.timeLocalDate`."
  (:require [scribe.time.core :as t])
  (:import java.time.LocalDate))

(defmethod t/local-date? java.time.LocalDate [_] true)

(defmethod t/to-epoch-day java.time.LocalDate
  [^LocalDate ld]
  (.toEpochDay ld))

(defmethod t/of-epoch-day java.time.LocalDate
  [_ days]
  (LocalDate/ofEpochDay days))
