(ns scribe.time.joda.local-date
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalDate`."
  (:require [scribe.time.core :as t])
  (:import org.joda.time.LocalDate))

(defmethod t/local-date? org.joda.time.LocalDate [_] true)

(defmethod t/to-epoch-day org.joda.time.LocalDate
  [^LocalDate ld]
  (let [ld (java.time.LocalDate/of (.getYear ld)
                                   (.getMonthOfYear ld)
                                   (.getDayOfMonth ld))]
    (.toEpochDay ld)))

(defmethod t/of-epoch-day org.joda.time.LocalDate
  [_ days]
  (let [ld (java.time.LocalDate/ofEpochDay days)]
    (LocalDate. (.getYear ld) (.getMonthValue ld) (.getDayOfMonth ld))))
