(ns scribe.time.joda.local-time
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as t])
  (:import org.joda.time.LocalTime))

(defmethod t/local-time? org.joda.time.LocalTime [_] true)

(defmethod t/to-milli-of-day org.joda.time.LocalTime
  [^LocalTime lt]
  (.getMillisOfDay lt))

(defmethod t/of-milli-of-day org.joda.time.LocalTime
  [_ ms]
  (-> (LocalTime. (int 0) (int 0))
      (.plusMillis ms)))
