/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.collection.List;
import io.vavr.collection.Map;
import java.io.File;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.objectweb.asm.ClassReader;
import vivid.cherimoya.maven.AsmClassReaders;
import vivid.cherimoya.maven.Mojo;
import vivid.cherimoya.maven.SneakyMojoException;
import vivid.cherimoya.maven.Static;

class MavenArtifactResolution {
    private MavenArtifactResolution() {
    }

    static Map<String, java.util.List<ClassReader>> mapVersionsToClassReaders(Mojo mojo, List<String> resolvableVersions) {
        return resolvableVersions.toMap(v -> v, v -> MavenArtifactResolution.classReaderForResolvableVersion(mojo, mojo.getMavenProject().getGroupId(), mojo.getMavenProject().getArtifactId(), v)).put((Object)mojo.getMavenProject().getVersion(), AsmClassReaders.fromFile(mojo, new File(mojo.getMavenProject().getBuild().getOutputDirectory())));
    }

    private static java.util.List<ClassReader> classReaderForResolvableVersion(Mojo mojo, String groupId, String artifactId, String version) {
        ArtifactResult artifactResult = MavenArtifactResolution.resolveArtifact(mojo, groupId, artifactId, version);
        return AsmClassReaders.fromJarFile(mojo, artifactResult.getArtifact().getFile());
    }

    private static ArtifactResult resolveArtifact(Mojo mojo, String groupId, String artifactId, String version) {
        String gav = Static.mavenGAVOf(groupId, artifactId, version);
        DefaultArtifact artifact = new DefaultArtifact(gav);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(mojo.getRemoteRepositories());
        try {
            return mojo.getRepositorySystem().resolveArtifact(mojo.getRepositorySystemSession(), artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new SneakyMojoException(mojo.getI18nContext().getText("vivid.cherimoya.error.ce-3-artifact-resolution-failure", gav), e);
        }
    }
}

