/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import vivid.cherimoya.maven.CE1InternalError;
import vivid.cherimoya.maven.ConstancyViolation;
import vivid.cherimoya.maven.Mojo;
import vivid.cherimoya.maven.SimpleVersionRange;
import vivid.cherimoya.maven.SneakyMojoException;
import vivid.cherimoya.maven.Static;
import vivid.cherimoya.maven.VerifyConstantsMojo;

class MavenLogReporting {
    private static final int ABBREVIATED_VALUE_LENGTH_STRING_FORMAT = 80;

    private MavenLogReporting() {
    }

    static void report(Mojo mojo, List<ConstancyViolation> constancyViolations) {
        mojo.getLog().info((CharSequence)"");
        Consumer<String> log = MavenLogReporting.logLine(mojo);
        constancyViolations.forEach(v -> MavenLogReporting.report(mojo, log, v));
    }

    private static void report(Mojo mojo, Consumer<String> log, ConstancyViolation constancyViolation) {
        Option versionRangeColumnWidth = constancyViolation.fieldValueByVersionRange.map(x -> (SimpleVersionRange)x._1).map(SimpleVersionRange::toString).map(String::length).max();
        if (versionRangeColumnWidth.isEmpty()) {
            throw new SneakyMojoException((Throwable)new MojoExecutionException(CE1InternalError.message("Could not calculate the width of the version range column").render(mojo)));
        }
        log.accept(mojo.getI18nContext().getText("vivid.cherimoya.report.field-value-constancy-violation", constancyViolation.fieldName));
        constancyViolation.fieldValueByVersionRange.forEach(v -> log.accept("  " + MavenLogReporting.fieldValue(mojo, (SimpleVersionRange)v._1, (Integer)versionRangeColumnWidth.get(), (Option<Object>)((Option)v._2))));
        log.accept("");
    }

    private static String fieldValue(Mojo mojo, SimpleVersionRange versionRange, int versionRangeColumnWidth, Option<Object> fieldValue) {
        String versionDescription = String.format(String.format("%%-%ds", versionRangeColumnWidth), versionRange);
        if (fieldValue.isDefined()) {
            return mojo.getI18nContext().getText("vivid.cherimoya.report.field-value-constancy-violation-field-value", versionDescription, Static.objectValueAsAbbreviatedString(fieldValue.get(), 80));
        }
        return mojo.getI18nContext().getText("vivid.cherimoya.report.field-value-constancy-violation-field-absent", versionDescription);
    }

    private static Consumer<String> logLine(Mojo mojo) {
        if (mojo.getReportingLevel() == VerifyConstantsMojo.ReportingLevel.ERROR) {
            return arg_0 -> ((Log)mojo.getLog()).error(arg_0);
        }
        if (mojo.getReportingLevel() == VerifyConstantsMojo.ReportingLevel.WARNING) {
            return arg_0 -> ((Log)mojo.getLog()).warn(arg_0);
        }
        throw new SneakyMojoException((Throwable)new MojoExecutionException(CE1InternalError.message(String.format("Unexpected ReportingLevel value: %s", new Object[]{mojo.getReportingLevel()})).render(mojo)));
    }
}

