/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.components;

import io.vavr.collection.Stream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoExecutionException;
import vivid.cmp.mojo.AbstractCMPMojo;

public class SubProcess {
    private SubProcess() {
    }

    public static void executeSubProcess(AbstractCMPMojo mojo, String clojureExecutable, String args, Stream<String> classPath, Map<String, String> env) throws MojoExecutionException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler());
        executor.setWorkingDirectory(mojo.mavenSession().getCurrentProject().getBasedir());
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        CommandLine commandLine = new CommandLine(clojureExecutable);
        commandLine.addArgument("-Scp");
        commandLine.addArgument(Stream.ofAll(classPath).mkString((CharSequence)":"));
        if (args != null) {
            commandLine.addArguments(args);
        }
        SubProcess.exec(mojo, (Executor)executor, commandLine, env);
    }

    private static void exec(AbstractCMPMojo mojo, Executor exec, CommandLine commandLine, Map<String, String> environment) throws MojoExecutionException {
        int exitValue;
        mojo.getLog().debug((CharSequence)String.format("Command line: %s", String.join((CharSequence)" ", commandLine.toStrings())));
        Throwable failureException = null;
        try {
            exitValue = exec.execute(commandLine, environment);
        }
        catch (ExecuteException e) {
            exitValue = e.getExitValue();
            failureException = e;
        }
        catch (IOException e) {
            exitValue = 1;
            failureException = e;
        }
        if (exitValue != 0) {
            throw new MojoExecutionException(mojo.i18nContext().getText("vivid.clojure-maven-plugin.error.vcmpe-2-command-exit-value", commandLine.getExecutable(), exitValue), (Exception)failureException);
        }
    }
}

