/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.function.Consumer;
import vivid.cherimoya.annotation.Constant;
import vivid.cmp.classpath.ClasspathScopes;

public class ClojureMojoState {
    @Constant
    static final Option<String> CLOJURE_ARGS_PROPERTY_DEFAULT_VALUE = Option.none();
    @Constant(rationale={"The 'clojure' executable provided by the Clojure distribution is and may always be hardcoded as 'clojure'."})
    static final String CLOJURE_EXECUTABLE_PROPERTY_DEFAULT_VALUE = "clojure";
    @Constant
    static final ClasspathScopes CLOJURE_CLASSPATHSCOPE_PROPERTY_DEFAULT_VALUE = ClasspathScopes.COMPILE;
    @Constant(rationale={"Fixed at the conventional Maven directory path for Clojure source code"})
    static final List<String> CLOJURE_SOURCEPATHS_PROPERTY_DEFAULT_VALUE = List.of((Object)"src/main/clojure");
    @Constant(rationale={"Fixed at the conventional Maven directory path for Clojure test code"})
    static final List<String> CLOJURE_TESTPATHS_PROPERTY_DEFAULT_VALUE = List.of((Object)"src/test/clojure");
    public final Option<String> args;
    public final String executable;
    public final ClasspathScopes classpathScope;
    public final List<String> sourcePaths;
    public final List<String> testPaths;
    public static final ClojureMojoState DEFAULT_STATE = new ClojureMojoState(CLOJURE_ARGS_PROPERTY_DEFAULT_VALUE, "clojure", CLOJURE_CLASSPATHSCOPE_PROPERTY_DEFAULT_VALUE, CLOJURE_SOURCEPATHS_PROPERTY_DEFAULT_VALUE, CLOJURE_TESTPATHS_PROPERTY_DEFAULT_VALUE);

    ClojureMojoState(Option<String> args, String executable, ClasspathScopes classpathScope, List<String> sourcePaths, List<String> testPaths) {
        this.args = args;
        this.executable = executable;
        this.classpathScope = classpathScope;
        this.sourcePaths = sourcePaths;
        this.testPaths = testPaths;
    }

    private static ClojureMojoState mutate(ClojureMojoState original, Consumer<State> func) {
        State state = new State(original);
        func.accept(state);
        return new ClojureMojoState((Option<String>)state.args, state.executable, state.classpathScope, (List<String>)state.sourcePaths, (List<String>)state.testPaths);
    }

    ClojureMojoState setArgs(Option<String> args) {
        return ClojureMojoState.mutate(this, s -> ((State)s).args = args);
    }

    ClojureMojoState setExecutable(String executable) {
        return ClojureMojoState.mutate(this, s -> ((State)s).executable = executable);
    }

    ClojureMojoState setClasspathScope(ClasspathScopes classpathScope) {
        return ClojureMojoState.mutate(this, s -> ((State)s).classpathScope = classpathScope);
    }

    ClojureMojoState setSourcePaths(List<String> sourcePaths) {
        return ClojureMojoState.mutate(this, s -> ((State)s).sourcePaths = sourcePaths);
    }

    ClojureMojoState setTestPaths(List<String> testPaths) {
        return ClojureMojoState.mutate(this, s -> ((State)s).testPaths = testPaths);
    }

    private static class State {
        private Option<String> args;
        private String executable;
        private ClasspathScopes classpathScope;
        private List<String> sourcePaths;
        private List<String> testPaths;

        State(ClojureMojoState original) {
            this.args = original.args;
            this.executable = original.executable;
            this.classpathScope = original.classpathScope;
            this.sourcePaths = original.sourcePaths;
            this.testPaths = original.testPaths;
        }
    }
}

