/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.function.Predicate;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;
import vivid.cmp.classpath.ClasspathScopes;
import vivid.cmp.components.DepsEdnDataStructure;
import vivid.cmp.components.Resolution;
import vivid.cmp.components.Static;
import vivid.cmp.messages.SneakyMojoException;
import vivid.cmp.messages.VCMPE1InternalError;
import vivid.cmp.mojo.AbstractCMPMojo;
import vivid.cmp.mojo.ClojureMojoState;

@Mojo(name="write-deps-edn")
public class WriteDepsEdnMojo
extends AbstractCMPMojo {
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="deps.edn")
    private String filename;
    private static Function1<Xpp3Dom, List<String>> getChildrenValues = (Function1 & Serializable)dom -> Stream.of((Object[])dom.getChildren()).map(Xpp3Dom::getValue).toList();
    private static Function2<ClojureMojoState, Xpp3Dom, ClojureMojoState> updateInPlaceClojureMojoState = (Function2 & Serializable)(state, dom) -> {
        String key;
        switch (key = dom.getName()) {
            case "args": {
                return state.setArgs((Option<String>)Option.of((Object)dom.getValue()));
            }
            case "executable": {
                return state.setExecutable(dom.getValue());
            }
            case "classpathScope": {
                return state.setClasspathScope(ClasspathScopes.valueOf(dom.getValue()));
            }
            case "sourcePaths": {
                return state.setSourcePaths((List<String>)((List)getChildrenValues.apply(dom)));
            }
            case "testPaths": {
                return state.setTestPaths((List<String>)((List)getChildrenValues.apply(dom)));
            }
        }
        throw new SneakyMojoException((Throwable)VCMPE1InternalError.asNewMojoExecutionException(null, "Unknown " + ClojureMojoState.class.getName() + " field name: " + key));
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.initialize();
        try {
            Map<String, ClojureMojoState> states = this.myPluginExecutionConfigurations(this);
            java.util.Map<Keyword, Object> ednValue = DepsEdnDataStructure.create(WriteDepsEdnMojo.paths(this, (ClojureMojoState)((Tuple2)states.get())._2), Resolution.getResolvedDependencies(this, (ClojureMojoState)((Tuple2)states.get())._2));
            String deps_edn = Printers.printString((Protocol)Printers.prettyPrinterProtocol(), ednValue);
            Static.writeFile(Paths.get(this.filename, new String[0]), StandardCharsets.UTF_8, deps_edn + '\n');
            this.getLog().info((CharSequence)this.i18nContext.getText("vivid.clojure-maven-plugin.action.wrote-deps-edn", this.filename));
        }
        catch (SneakyMojoException ex) {
            throw SneakyMojoException.unwrap(ex);
        }
        catch (Exception ex) {
            throw VCMPE1InternalError.asNewMojoExecutionException(this, "Unexpected exception", ex);
        }
    }

    private Map<String, ClojureMojoState> myPluginExecutionConfigurations(AbstractCMPMojo mojo) {
        Plugin myself = this.mavenSession.getCurrentProject().getPlugin(this.pluginDescriptor.getPluginLookupKey());
        Predicate<PluginExecution> hasClojureGoal = e -> List.ofAll((Iterable)e.getGoals()).find("clojure"::equalsIgnoreCase).isDefined();
        return Stream.ofAll((Iterable)myself.getExecutions()).filter(hasClojureGoal).toMap(PluginExecution::getId, x -> WriteDepsEdnMojo.asClojureMojoState(mojo, x));
    }

    private static ClojureMojoState asClojureMojoState(AbstractCMPMojo mojo, PluginExecution pluginExecution) {
        Object untyped = pluginExecution.getConfiguration();
        if (!(untyped instanceof Xpp3Dom)) {
            throw new SneakyMojoException((Throwable)VCMPE1InternalError.asNewMojoExecutionException(mojo, "pluginExecution.getConfiguration() returned an object of an unknown type: " + untyped.getClass()));
        }
        return (ClojureMojoState)Stream.of((Object[])((Xpp3Dom)untyped).getChildren()).foldLeft((Object)ClojureMojoState.DEFAULT_STATE, updateInPlaceClojureMojoState);
    }

    private static Stream<String> paths(AbstractCMPMojo mojo, ClojureMojoState state) {
        return Stream.ofAll(state.sourcePaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getOutputDirectory()).appendAll((Iterable)(state.classpathScope == ClasspathScopes.TEST ? Stream.ofAll(state.testPaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getOutputDirectory()) : Stream.empty()));
    }
}

