/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.datatypes;

import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.function.Consumer;
import vivid.cherimoya.annotation.Constant;
import vivid.cmp.datatypes.ClasspathScope;

public class ClojureMojoState {
    @Constant
    public static final String CLOJURE_ARGS_PARAMETER_KEY = "args";
    @Constant
    static final Option<String> CLOJURE_ARGS_PROPERTY_DEFAULT_VALUE = Option.none();
    @Constant
    public static final String CLOJURE_EXECUTABLE_PARAMETER_KEY = "executable";
    @Constant(rationale={"The 'clojure' executable provided by the Clojure distribution is and may always be hardcoded as 'clojure'."})
    static final String CLOJURE_EXECUTABLE_PROPERTY_DEFAULT_VALUE = "clojure";
    @Constant
    public static final String CLOJURE_CLASSPATHSCOPE_PARAMETER_KEY = "classpathScope";
    @Constant
    static final ClasspathScope CLOJURE_CLASSPATHSCOPE_PROPERTY_DEFAULT_VALUE = ClasspathScope.COMPILE;
    @Constant
    public static final String CLOJURE_SOURCEPATHS_PARAMETER_KEY = "sourcePaths";
    @Constant(rationale={"Fixed at the conventional Maven directory path for Clojure source code"})
    public static final String CLOJURE_SOURCEPATHS_PROPERTY_DEFAULT_VALUE = "src/main/clojure";
    @Constant
    public static final String CLOJURE_SOURCEPATH_PARAMETER_CHILDNAME_KEY = "sourcePath";
    @Constant
    public static final String CLOJURE_TESTPATHS_PARAMETER_KEY = "testPaths";
    @Constant(rationale={"Fixed at the conventional Maven directory path for Clojure test code"})
    public static final String CLOJURE_TESTPATHS_PROPERTY_DEFAULT_VALUE = "src/test/clojure";
    @Constant
    public static final String CLOJURE_TESTPATH_PARAMETER_CHILDNAME_KEY = "testPath";
    public final Option<String> args;
    public final String executable;
    public final ClasspathScope classpathScope;
    public final List<String> sourcePaths;
    public final List<String> testPaths;
    public static final ClojureMojoState DEFAULT_STATE = new ClojureMojoState(CLOJURE_ARGS_PROPERTY_DEFAULT_VALUE, "clojure", CLOJURE_CLASSPATHSCOPE_PROPERTY_DEFAULT_VALUE, (List<String>)List.of((Object)"src/main/clojure"), (List<String>)List.of((Object)"src/test/clojure"));

    public ClojureMojoState(Option<String> args, String executable, ClasspathScope classpathScope, List<String> sourcePaths, List<String> testPaths) {
        this.args = args;
        this.executable = executable;
        this.classpathScope = classpathScope;
        this.sourcePaths = sourcePaths;
        this.testPaths = testPaths;
    }

    private static ClojureMojoState mutate(ClojureMojoState original, Consumer<State> func) {
        State state = new State(original);
        func.accept(state);
        return new ClojureMojoState((Option<String>)state.args, state.executable, state.classpathScope, (List<String>)state.sourcePaths, (List<String>)state.testPaths);
    }

    public ClojureMojoState setArgs(Option<String> args) {
        return ClojureMojoState.mutate(this, s -> ((State)s).args = args);
    }

    public ClojureMojoState setExecutable(String executable) {
        return ClojureMojoState.mutate(this, s -> ((State)s).executable = executable);
    }

    public ClojureMojoState setClasspathScope(ClasspathScope classpathScope) {
        return ClojureMojoState.mutate(this, s -> ((State)s).classpathScope = classpathScope);
    }

    public ClojureMojoState setSourcePaths(List<String> sourcePaths) {
        return ClojureMojoState.mutate(this, s -> ((State)s).sourcePaths = sourcePaths);
    }

    public ClojureMojoState setTestPaths(List<String> testPaths) {
        return ClojureMojoState.mutate(this, s -> ((State)s).testPaths = testPaths);
    }

    private static class State {
        private Option<String> args;
        private String executable;
        private ClasspathScope classpathScope;
        private List<String> sourcePaths;
        private List<String> testPaths;

        State(ClojureMojoState original) {
            this.args = original.args;
            this.executable = original.executable;
            this.classpathScope = original.classpathScope;
            this.sourcePaths = original.sourcePaths;
            this.testPaths = original.testPaths;
        }
    }
}

