/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.collection.Stream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Function;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import vivid.cmp.datatypes.ClasspathScope;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.fns.MavenDependencyFns;
import vivid.cmp.mojo.AbstractCMPMojo;

public class ClassPathology {
    private ClassPathology() {
    }

    public static void addToClassLoader(AbstractCMPMojo mojo, org.eclipse.aether.resolution.ArtifactResult artifact, Iterable<ArtifactResult> artifacts) throws DuplicateRealmException, MalformedURLException {
        ClassWorld world = new ClassWorld();
        ClassRealm realm = world.newRealm("vivid.clojure-maven-plugin-with-leiningen", Thread.currentThread().getContextClassLoader());
        realm.addURL(artifact.getArtifact().getFile().toURI().toURL());
        for (ArtifactResult a : artifacts) {
            URL url = a.getArtifact().getFile().toURI().toURL();
            realm.addURL(url);
            mojo.getLog().debug((CharSequence)String.format("Adding to new ClassRealm: %s", url));
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
    }

    public static Stream<String> getClassPathForScope(AbstractCMPMojo mojo, ClojureMojoState state, boolean includeTransitiveDependencies) {
        return Stream.ofAll(state.sourcePaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getOutputDirectory()).appendAll((Iterable)(state.classpathScope == ClasspathScope.TEST ? Stream.ofAll(state.testPaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getOutputDirectory()) : Stream.empty())).appendAll((Iterable)(includeTransitiveDependencies ? MavenDependencyFns.getResolvedDependencies(mojo, state).map(d -> d.getFile().getPath()) : Stream.empty())).map(ClassPathology.relativePath(mojo.mavenSession().getCurrentProject().getBasedir().toPath()));
    }

    private static Function<String, String> relativePath(Path base) {
        return fileStr -> base.toAbsolutePath().relativize(new File((String)fileStr).toPath().toAbsolutePath()).toString();
    }
}

