/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import vivid.cmp.datatypes.ClasspathScope;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.mojo.AbstractCMPMojo;

public class MavenDependencyFns {
    private MavenDependencyFns() {
    }

    public static Set<org.apache.maven.artifact.Artifact> getResolvedDependencies(AbstractCMPMojo mojo, ClojureMojoState state) {
        try {
            Iterable dependencies = mojo.dependencyResolver().resolveDependencies(mojo.mavenSession().getProjectBuildingRequest(), (Collection)mojo.mavenSession().getCurrentProject().getDependencies(), (Collection)mojo.mavenSession().getCurrentProject().getDependencies(), (TransformableFilter)ScopeFilter.including((String[])state.classpathScope.effectiveScopesAsJavaArray()));
            return (Set)Stream.ofAll((Iterable)dependencies).map(org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult::getArtifact).collect(HashSet.collector());
        }
        catch (DependencyResolverException e) {
            System.out.println(e.getLocalizedMessage());
            System.exit(1);
            return null;
        }
    }

    public static Dependency newDependency(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return dependency;
    }

    public static ProjectBuildingRequest newProjectBuildingRequest(ProjectBuildingRequest projectBuildingRequest, List<ArtifactRepository> remoteRepositories) {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(projectBuildingRequest);
        request.setRemoteRepositories(remoteRepositories);
        return request;
    }

    public static ArtifactResult resolveArtifact(AbstractCMPMojo mojo, Dependency dependency) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)MavenDependencyFns.toArtifact(dependency));
        artifactRequest.setRepositories(RepositoryUtils.toRepos(mojo.remoteRepositories));
        return mojo.repositorySystem.resolveArtifact(mojo.repositorySystemSession, artifactRequest);
    }

    public static Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(AbstractCMPMojo mojo, Dependency dependency) throws DependencyResolverException, MojoFailureException {
        mojo.getLog().debug((CharSequence)("Resolving dependencies for: " + dependency));
        Iterable dependencyArtifacts = mojo.dependencyResolver.resolveDependencies(MavenDependencyFns.newProjectBuildingRequest(mojo.mavenSession.getProjectBuildingRequest(), mojo.remoteRepositories), Collections.singletonList(dependency), Collections.singletonList(dependency), (TransformableFilter)ScopeFilter.including((String[])ClasspathScope.COMPILE.effectiveScopesAsJavaArray()));
        if (dependencyArtifacts == null || !dependencyArtifacts.iterator().hasNext()) {
            throw new MojoFailureException("No dependencies were resolved for: " + dependency);
        }
        for (org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult artifactResult : dependencyArtifacts) {
            mojo.getLog().debug((CharSequence)String.format("Resolved dependency artifact: %s", artifactResult.getArtifact().getFile().toString()));
        }
        return dependencyArtifacts;
    }

    public static DefaultArtifact toArtifact(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency is null");
        return new DefaultArtifact(String.format("%s:%s:%s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
    }

    public static Predicate<Dependency> inScopeP(ClasspathScope classpathScope) {
        return dependency -> classpathScope.effectiveScopes.contains((Object)dependency.getScope());
    }
}

