/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.collection.TreeMap;
import io.vavr.control.Either;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiFunction;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;
import vivid.cherimoya.annotation.Constant;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.datatypes.DepsEdn;
import vivid.cmp.fns.ClojureMojoConfigurationFns;
import vivid.cmp.fns.FileFns;
import vivid.cmp.fns.MojoFns;
import vivid.cmp.messages.Message;
import vivid.cmp.mojo.AbstractCMPMojo;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_RESOURCES, name="deps.edn")
public class DepsEdnMojo
extends AbstractCMPMojo {
    @Constant
    private static final String DEPS_EDN_GOAL_PROPERTY_KEY_PREFIX = "deps.edn.";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PARAMETER_KEY = "pathname";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PROPERTY_KEY = "deps.edn.pathname";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PROPERTY_DEFAULT_VALUE = "deps.edn";
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="deps.edn.pathname")
    private String pathname = "deps.edn";

    public void execute() throws MojoExecutionException {
        super.initialize();
        Either result = this.myPluginExecutionConfigurations().map(x -> DepsEdn.create(this, (Map<String, ClojureMojoState>)x)).map(edn -> Printers.printString((Protocol)Printers.prettyPrinterProtocol(), (Object)edn)).map(depsEdn -> FileFns.writeFile(DepsEdnMojo.depsEdnPath(this.pathname), StandardCharsets.UTF_8, depsEdn + '\n'));
        if (!result.isRight()) {
            throw new MojoExecutionException(((Message)result.getLeft()).render(this));
        }
        this.getLog().info((CharSequence)this.i18nContext.getText("vivid.clojure-maven-plugin.action.wrote-deps-edn", this.pathname));
    }

    private static Path depsEdnPath(String pathname) {
        Path p = Paths.get(pathname, new String[0]);
        return p.toFile().isDirectory() ? p.resolve(DEPS_EDN_PATHNAME_PROPERTY_DEFAULT_VALUE) : p;
    }

    private Either<Message, Map<String, ClojureMojoState>> myPluginExecutionConfigurations() {
        Plugin myself = this.mavenSession.getCurrentProject().getPlugin(this.pluginDescriptor.getPluginLookupKey());
        return (Either)Stream.ofAll((Iterable)myself.getExecutions()).filter(MojoFns.hasGoalOfName("clojure")).foldLeft((Object)Either.right((Object)TreeMap.empty()), DepsEdnMojo.mappedPluginExecutionStateCombinator());
    }

    private static BiFunction<Either<Message, Map<String, ClojureMojoState>>, PluginExecution, Either<Message, Map<String, ClojureMojoState>>> mappedPluginExecutionStateCombinator() {
        return (m, pluginExecution) -> {
            if (m.isLeft()) {
                return m;
            }
            Either<Message, ClojureMojoState> state = ClojureMojoConfigurationFns.asClojureMojoState(pluginExecution);
            if (state.isLeft()) {
                return Either.left((Object)state.getLeft());
            }
            return Either.right((Object)((Map)m.get()).put((Object)pluginExecution.getId(), state.get()));
        };
    }
}

