/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.Function1;
import io.vavr.Function3;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Function;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import vivid.cmp.datatypes.ClasspathScope;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.fns.MavenDependencyFns;
import vivid.cmp.mojo.AbstractCMPMojo;

public class ClassPathology {
    private static final Function3<AbstractCMPMojo, ClassRealm, URL, Void> addURLToRealm = (Function3 & Serializable)(mojo, realm, url) -> {
        realm.addURL(url);
        mojo.getLog().debug((CharSequence)String.format("Added to ClassRealm: %s", url));
        return null;
    };

    private ClassPathology() {
    }

    public static void addToClassLoader(AbstractCMPMojo mojo, List<File> files) throws DuplicateRealmException, MalformedURLException {
        ClassWorld world = new ClassWorld();
        ClassRealm realm = world.newRealm("vivid.clojure-maven-plugin-with-leiningen", Thread.currentThread().getContextClassLoader());
        Function1 add = addURLToRealm.apply((Object)mojo, (Object)realm);
        for (File f : files) {
            add.apply((Object)f.toURI().toURL());
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
    }

    public static Stream<String> getClassPathForScope(AbstractCMPMojo mojo, ClojureMojoState state, boolean includeTransitiveDependencies, PathStyle pathStyle) {
        return Stream.ofAll(state.sourcePaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getOutputDirectory()).appendAll((Iterable)(state.classpathScope == ClasspathScope.TEST ? Stream.ofAll(state.testPaths).append((Object)mojo.mavenSession().getCurrentProject().getBuild().getTestOutputDirectory()) : Stream.empty())).appendAll((Iterable)(includeTransitiveDependencies ? MavenDependencyFns.getResolvedDependencies(mojo, state).map(d -> d.getFile().getPath()) : Stream.empty())).map(ClassPathology.pathInStyle(mojo.mavenSession().getCurrentProject().getBasedir().toPath(), pathStyle));
    }

    private static Function<String, String> pathInStyle(Path base, PathStyle pathStyle) {
        return fileStr -> {
            Path path = new File((String)fileStr).toPath().toAbsolutePath();
            return pathStyle == PathStyle.RELATIVE ? base.toAbsolutePath().relativize(path).toString() : path.toString();
        };
    }

    public static enum PathStyle {
        ABSOLUTE,
        RELATIVE;

    }
}

