/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.Function2;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import vivid.cmp.datatypes.ClasspathScope;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.messages.Message;
import vivid.cmp.messages.VCMPE1InternalError;

public class ClojureMojoConfigurationFns {
    private static final Function2<String, Xpp3Dom, List<String>> getChildrenValues = (Function2 & Serializable)(childName, dom) -> Stream.of((Object[])dom.getChildren()).filter(child -> childName.equalsIgnoreCase(child.getName())).map(Xpp3Dom::getValue).toList();
    private static final Function2<Either<Message, Option<ClojureMojoState>>, Xpp3Dom, Either<Message, Option<ClojureMojoState>>> updateInPlaceClojureMojoState = (Function2 & Serializable)(stateOption, dom) -> {
        if (stateOption.isLeft()) {
            return stateOption;
        }
        if (((Option)stateOption.get()).isEmpty()) {
            return Either.right((Object)Option.none());
        }
        String key = dom.getName();
        ClojureMojoState state = (ClojureMojoState)((Option)stateOption.get()).get();
        switch (key) {
            case "args": {
                return Either.right((Object)Option.of((Object)state.setArgs((Option<String>)Option.of((Object)dom.getValue()))));
            }
            case "executable": {
                return Either.right((Object)Option.of((Object)state.setExecutable(dom.getValue())));
            }
            case "classpathScope": {
                return Either.right((Object)Option.of((Object)state.setClasspathScope(ClasspathScope.valueOf(dom.getValue()))));
            }
            case "sourcePaths": {
                return Either.right((Object)Option.of((Object)state.setSourcePaths((List<String>)((List)getChildrenValues.apply((Object)"sourcePath", dom)))));
            }
            case "testPaths": {
                return Either.right((Object)Option.of((Object)state.setTestPaths((List<String>)((List)getChildrenValues.apply((Object)"testPath", dom)))));
            }
        }
        return stateOption;
    };

    private ClojureMojoConfigurationFns() {
    }

    public static Either<Message, Option<ClojureMojoState>> asClojureMojoState(PluginExecution pluginExecution) {
        if (pluginExecution == null) {
            return Either.right((Object)Option.none());
        }
        Object untyped = pluginExecution.getConfiguration();
        if (untyped == null) {
            return Either.right((Object)Option.of((Object)ClojureMojoState.DEFAULT_STATE));
        }
        if (!(untyped instanceof Xpp3Dom)) {
            return Either.left((Object)VCMPE1InternalError.message("PluginExecution.getConfiguration() returned an object of an unhandled type: " + untyped.getClass()));
        }
        return (Either)Stream.of((Object[])((Xpp3Dom)untyped).getChildren()).foldLeft((Object)Either.right((Object)Option.of((Object)ClojureMojoState.DEFAULT_STATE)), updateInPlaceClojureMojoState);
    }
}

