/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.control.Either;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import vivid.cmp.messages.Message;
import vivid.cmp.messages.VCMPE1InternalError;
import vivid.cmp.mojo.AbstractCMPMojo;

public class FileFns {
    private FileFns() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Either<Message, Void> writeFile(Path path, Charset charset, String content) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, charset, new OpenOption[0]);){
            writer.write(content);
            Either either = Either.right(null);
            return either;
        }
        catch (IOException e) {
            return Either.left((Object)VCMPE1InternalError.message("Could not write file: " + path, e));
        }
    }

    public static class UserDirSystemPropertyOverride
    implements Closeable {
        private static final String USER_DIR_SYSTEM_PROPERTY_KEY = "user.dir";
        private final String priorValue;
        private final AbstractCMPMojo mojo;

        public UserDirSystemPropertyOverride(AbstractCMPMojo mojo, String cwd) {
            this.mojo = mojo;
            this.priorValue = System.getProperty(USER_DIR_SYSTEM_PROPERTY_KEY);
            System.setProperty(USER_DIR_SYSTEM_PROPERTY_KEY, cwd);
            mojo.getLog().debug((CharSequence)String.format("Set system property %s to a new cwd: %s", USER_DIR_SYSTEM_PROPERTY_KEY, cwd));
        }

        @Override
        public void close() {
            System.setProperty(USER_DIR_SYSTEM_PROPERTY_KEY, this.priorValue);
            this.mojo.getLog().debug((CharSequence)String.format("Restored system property %s to its prior value: %s", USER_DIR_SYSTEM_PROPERTY_KEY, this.priorValue));
        }
    }
}

