/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.fns;

import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.collection.TreeMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.fns.ClojureMojoConfigurationFns;
import vivid.cmp.messages.Message;
import vivid.cmp.mojo.AbstractCMPMojo;

public class MojoFns {
    private MojoFns() {
    }

    public static Predicate<PluginExecution> hasGoalOfName(String goalName) {
        return e -> List.ofAll((Iterable)e.getGoals()).find(goalName::equalsIgnoreCase).isDefined();
    }

    private static BiFunction<Either<Message, Map<String, ClojureMojoState>>, PluginExecution, Either<Message, Map<String, ClojureMojoState>>> mappedPluginExecutionStateCombinator() {
        return (m, pluginExecution) -> {
            if (m.isLeft()) {
                return m;
            }
            Either<Message, Option<ClojureMojoState>> state = ClojureMojoConfigurationFns.asClojureMojoState(pluginExecution);
            if (state.isLeft()) {
                return Either.left((Object)state.getLeft());
            }
            if (((Option)state.get()).isEmpty()) {
                return m;
            }
            return Either.right((Object)((Map)m.get()).put((Object)pluginExecution.getId(), ((Option)state.get()).get()));
        };
    }

    public static Either<Message, Map<String, ClojureMojoState>> myPluginExecutionConfigurations(AbstractCMPMojo mojo, String pluginLookupKey, String goalName) {
        Plugin myself = mojo.mavenSession.getCurrentProject().getPlugin(pluginLookupKey);
        return (Either)Stream.ofAll((Iterable)myself.getExecutions()).filter(MojoFns.hasGoalOfName(goalName)).foldLeft((Object)Either.right((Object)TreeMap.empty()), MojoFns.mappedPluginExecutionStateCombinator());
    }
}

