/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import clojure.java.api.Clojure;
import clojure.lang.RT;
import clojure.lang.Symbol;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import vivid.cmp.datatypes.ClasspathScope;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.fns.ClassPathology;
import vivid.cmp.fns.MavenDependencyFns;
import vivid.cmp.fns.MojoFns;
import vivid.cmp.messages.Message;
import vivid.cmp.messages.VCMPE1InternalError;
import vivid.cmp.messages.VCMPE3ItemNotFound;
import vivid.cmp.messages.VCMPE4IndeterminateExecutionId;
import vivid.cmp.mojo.AbstractCMPMojo;
import vivid.polypara.annotation.Constant;

@Mojo(name="clojure.test", defaultPhase=LifecyclePhase.TEST)
public class ClojureTestMojo
extends AbstractCMPMojo {
    @Constant
    private static final String CLOJURE_TEST_GOAL_PROPERTY_KEY_PREFIX = "clojure-maven-plugin.clojure.test.";
    @Constant
    private static final String CLOJURE_TEST_CLOJUREGOALEXECUTIONID_PARAMETER_KEY = "clojureGoalExecutionId";
    @Constant
    private static final String CLOJURE_TEST_CLOJUREGOALEXECUTIONID_PROPERTY_KEY = "clojure-maven-plugin.clojure.test.clojureGoalExecutionId";
    @Constant
    private static final String CLOJURE_TEST_MULTITHREAD_PARAMETER_KEY = "multithread";
    @Constant
    private static final String CLOJURE_TEST_MULTITHREAD_PROPERTY_KEY = "clojure-maven-plugin.clojure.test.multithread";
    @Constant
    private static final String CLOJURE_TEST_SKIP_PARAMETER_KEY = "skip";
    @Constant
    private static final String CLOJURE_TEST_SKIP_PROPERTY_KEY = "clojure-maven-plugin.clojure.test.skip";
    @Constant
    private static final String CLOJURE_TEST_TESTFAILUREIGNORE_PARAMETER_KEY = "testFailureIgnore";
    @Constant
    private static final String CLOJURE_TEST_TESTFAILUREIGNORE_PROPERTY_KEY = "clojure-maven-plugin.clojure.test.testFailureIgnore";
    @Parameter(property="clojure-maven-plugin.clojure.test.clojureGoalExecutionId")
    private String clojureGoalExecutionId;
    @Parameter(defaultValue="false", property="clojure-maven-plugin.clojure.test.multithread")
    private boolean multithread;
    @Parameter(defaultValue="${maven.test.skip}", property="clojure-maven-plugin.clojure.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${maven.test.failure.ignore}", property="clojure-maven-plugin.clojure.test.testFailureIgnore")
    private boolean testFailureIgnore;
    private static final Dependency eftestDependency = MavenDependencyFns.newDependency("eftest", "eftest", "0.5.9");

    private static Either<Message, ClojureMojoState> selectClojureMojoConfig(Map<String, ClojureMojoState> configs, String executionId) {
        if (executionId != null) {
            Option a = configs.get((Object)executionId);
            return a.toEither((Object)VCMPE3ItemNotFound.message(String.format("'%s' goal execution ID '%s'", "clojure", executionId)));
        }
        if (configs.isEmpty()) {
            return Either.right((Object)ClojureMojoState.DEFAULT_STATE);
        }
        if (configs.size() == 1) {
            return Either.right((Object)((Tuple2)configs.get())._2);
        }
        return Either.left((Object)VCMPE4IndeterminateExecutionId.message(CLOJURE_TEST_CLOJUREGOALEXECUTIONID_PARAMETER_KEY, "clojure.test", "clojure", (Set<String>)configs.keySet()));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.initialize();
        if (this.skip) {
            this.getLog().info((CharSequence)this.i18nContext.getText("vivid.clojure-maven-plugin.action.skipping-execution-via-configuration", CLOJURE_TEST_SKIP_PROPERTY_KEY));
            return;
        }
        Either selectedConfig = MojoFns.myPluginExecutionConfigurations(this, this.pluginDescriptor.getPluginLookupKey(), "clojure").flatMap(configs -> ClojureTestMojo.selectClojureMojoConfig((Map<String, ClojureMojoState>)configs, this.clojureGoalExecutionId));
        if (selectedConfig.isLeft()) {
            throw new MojoFailureException(((Message)selectedConfig.getLeft()).render(this));
        }
        ClojureMojoState clojureMojoState = ((ClojureMojoState)selectedConfig.get()).setClasspathScope(ClasspathScope.TEST);
        HashMap testRunnerOptions = HashMap.of((Object)"junit-report-filename", (Object)(this.mavenSession.getCurrentProject().getBuild().getDirectory() + "/clojure-test-reports/all-tests.xml"), (Object)CLOJURE_TEST_MULTITHREAD_PARAMETER_KEY, (Object)this.multithread);
        try {
            ClassPathology.addToClassLoader(this, (List<File>)List.ofAll(ClassPathology.getClassPathForScope(this, clojureMojoState, true, ClassPathology.PathStyle.ABSOLUTE)).map(File::new).appendAll(MavenDependencyFns.resolveToFiles(this, eftestDependency)));
        }
        catch (Exception e) {
            throw new MojoExecutionException(VCMPE1InternalError.message("Unexpected exception while adding to classloader path").render(this), e);
        }
        Either<Message, Object> res = ClojureTestMojo.clojureDotTestRunner(this, (Map<String, Object>)testRunnerOptions);
        ClojureTestMojo.translateTestResultToMaven(this, res, this.testFailureIgnore, (Map<String, Object>)testRunnerOptions);
    }

    private static Either<Message, Object> clojureDotTestRunner(AbstractCMPMojo mojo, Map<String, Object> eftestOptions) {
        mojo.getLog().debug((CharSequence)String.format("Running Clojure tests with options: %s", eftestOptions));
        try {
            RT.loadResourceScript((String)"vivid/cmp/clojure_dot_test_runner.clj");
            Clojure.var((Object)"clojure.core", (Object)"require").invoke((Object)Symbol.intern((String)"vivid.cmp.clojure-dot-test-runner"));
            Object response = Clojure.var((Object)"vivid.cmp.clojure-dot-test-runner", (Object)"run-tests").invoke((Object)mojo, (Object)eftestOptions.toJavaMap());
            return Either.right((Object)response);
        }
        catch (IOException e) {
            return Either.left((Object)VCMPE1InternalError.message("Could not run test runner", e));
        }
    }

    private static void translateTestResultToMaven(ClojureTestMojo mojo, Either<Message, Object> testResult, boolean testFailureIgnore, Map<String, Object> testRunnerOptions) throws MojoExecutionException, MojoFailureException {
        if (testResult.isLeft()) {
            throw new MojoFailureException(((Message)testResult.getLeft()).render(mojo), (Throwable)((Message)testResult.getLeft()).getCause().get());
        }
        Object r = testResult.get();
        if (!(r instanceof Boolean)) {
            throw new MojoExecutionException(VCMPE1InternalError.message("Unexpected result type returned from vivid/cmp/clojure_dot_test_runner.clj").render(mojo));
        }
        boolean allTestsPassed = (Boolean)r;
        if (!allTestsPassed) {
            if (testFailureIgnore) {
                mojo.getLog().debug((CharSequence)"clojure-maven-plugin.clojure.test.testFailureIgnore = true; ignoring negative test result");
            } else {
                throw new MojoFailureException(mojo.i18nContext.getText("vivid.clojure-maven-plugin.action.test-failures", testRunnerOptions.getOrElse((Object)"junit-report-filename", (Object)"the build output directory")));
            }
        }
    }
}

