/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import io.vavr.collection.Map;
import io.vavr.control.Either;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;
import vivid.cmp.datatypes.ClojureMojoState;
import vivid.cmp.datatypes.DepsEdn;
import vivid.cmp.fns.FileFns;
import vivid.cmp.fns.MojoFns;
import vivid.cmp.messages.Message;
import vivid.cmp.mojo.AbstractCMPMojo;
import vivid.polypara.annotation.Constant;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_RESOURCES, name="deps.edn")
public class DepsEdnMojo
extends AbstractCMPMojo {
    @Constant
    private static final String DEPS_EDN_GOAL_PROPERTY_KEY_PREFIX = "clojure-maven-plugin.deps.edn.";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PARAMETER_KEY = "pathname";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PROPERTY_KEY = "clojure-maven-plugin.deps.edn.pathname";
    @Constant
    private static final String DEPS_EDN_PATHNAME_PROPERTY_DEFAULT_VALUE = "deps.edn";
    @Parameter(defaultValue="deps.edn", property="clojure-maven-plugin.deps.edn.pathname")
    private String pathname;

    public void execute() throws MojoExecutionException {
        super.initialize();
        Either result = MojoFns.myPluginExecutionConfigurations(this, this.pluginDescriptor.getPluginLookupKey(), "clojure").map(configs -> DepsEdn.create(this, (Map<String, ClojureMojoState>)configs)).map(edn -> Printers.printString((Protocol)Printers.prettyPrinterProtocol(), (Object)edn)).map(depsEdn -> FileFns.writeFile(DepsEdnMojo.depsEdnPath(this.pathname), StandardCharsets.UTF_8, depsEdn + '\n'));
        if (!result.isRight()) {
            throw new MojoExecutionException(((Message)result.getLeft()).render(this));
        }
        this.getLog().info((CharSequence)this.i18nContext.getText("vivid.clojure-maven-plugin.action.wrote", this.pathname));
    }

    private static Path depsEdnPath(String pathname) {
        Path p = Paths.get(pathname, new String[0]);
        return p.toFile().isDirectory() ? p.resolve(DEPS_EDN_PATHNAME_PROPERTY_DEFAULT_VALUE) : p;
    }
}

