/*
 * Decompiled with CFR 0.152.
 */
package vivid.cmp.mojo;

import clojure.java.api.Clojure;
import clojure.lang.RT;
import clojure.lang.Symbol;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import java.io.IOException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import vivid.cmp.fns.ClassPathology;
import vivid.cmp.fns.FileFns;
import vivid.cmp.fns.MavenDependencyFns;
import vivid.cmp.mojo.AbstractCMPMojo;
import vivid.polypara.annotation.Constant;

@Mojo(name="leiningen")
public class LeiningenMojo
extends AbstractCMPMojo {
    private static final String LEININGEN_LIB_DEPENDENCY_MAVEN_G_A = "leiningen";
    private static final String VIVID_CMP_LEININGEN_NS = "vivid.cmp.leiningen";
    private static final String LEIN_MAIN_FN = "lein-main";
    @Constant
    private static final String CLOJURE_GOAL_PROPERTY_KEY_PREFIX = "clojure-maven-plugin.leiningen.";
    @Constant
    private static final String LEININGEN_GOAL_ARGS_PROPERTY_KEY = "clojure-maven-plugin.leiningen.args";
    @Constant
    private static final String LEININGEN_GOAL_VERSION_PROPERTY_KEY = "clojure-maven-plugin.leiningen.version";
    @Parameter(property="clojure-maven-plugin.leiningen.args")
    private String args;
    @Parameter(property="clojure-maven-plugin.leiningen.args", defaultValue="false")
    private boolean debug;
    @Parameter(required=true, property="clojure-maven-plugin.leiningen.version")
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.initialize();
        String cwd = this.mavenSession.getCurrentProject().getBasedir().getAbsolutePath();
        Dependency dependency = MavenDependencyFns.newDependency(LEININGEN_LIB_DEPENDENCY_MAVEN_G_A, LEININGEN_LIB_DEPENDENCY_MAVEN_G_A, this.version);
        try {
            ClassPathology.addToClassLoader(this, MavenDependencyFns.resolveToFiles(this, dependency));
            this.getLog().debug((CharSequence)"Invoking Leiningen:");
            List.of((Object[])new Tuple2[]{Tuple.of((Object)"version", (Object)this.version), Tuple.of((Object)"cwd", (Object)cwd), Tuple.of((Object)"args", (Object)this.args)}).forEach(t -> this.getLog().debug((CharSequence)String.format("  %s = %s", t._1, t._2)));
            try (FileFns.UserDirSystemPropertyOverride ignored = new FileFns.UserDirSystemPropertyOverride(this, cwd);){
                LeiningenMojo.lein(this.debug, this.args);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    private static void lein(boolean debug, String args) throws IOException {
        RT.loadResourceScript((String)"vivid/cmp/leiningen.clj");
        Clojure.var((Object)"clojure.core", (Object)"require").invoke((Object)Symbol.intern((String)VIVID_CMP_LEININGEN_NS));
        Clojure.var((Object)VIVID_CMP_LEININGEN_NS, (Object)LEIN_MAIN_FN).invoke((Object)debug, (Object)args);
    }
}

