/*
 * Decompiled with CFR 0.152.
 */
package vivid.polypara.maven;

import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.objectweb.asm.ClassReader;
import vivid.polypara.maven.JavaClasses;
import vivid.polypara.maven.Message;
import vivid.polypara.maven.Mojo;
import vivid.polypara.maven.Static;
import vivid.polypara.maven.VPE4ClassReadFailure;

class AsmClassReaders {
    private AsmClassReaders() {
    }

    private static Either<Message, Option<ClassReader>> classReaderOf(Mojo mojo, Path path) {
        try {
            if (!JavaClasses.isJavaClassFilename(path.toString())) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java class file name extension: " + path));
                return Either.right((Object)Option.none());
            }
            byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(path.toFile()));
            if (!JavaClasses.hasJavaClassFileMagic(bytes)) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java .class file header magic: " + path));
                return Either.right((Object)Option.none());
            }
            return Either.right((Object)Option.of((Object)new ClassReader(bytes)));
        }
        catch (IOException e) {
            return Either.left((Object)VPE4ClassReadFailure.message(path.toString(), e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Either<Message, Option<ClassReader>> classReaderOf(Mojo mojo, File file, JarFile jarFile, JarEntry jarEntry) {
        if (!JavaClasses.isJavaClassFilename(jarEntry.getName())) {
            mojo.getLog().debug((CharSequence)("Ignoring re Java class file name extension: " + Static.pathInJarFile(file, jarEntry.getName())));
            return Either.right((Object)Option.none());
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (!JavaClasses.hasJavaClassFileMagic(bytes)) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java .class file header magic: " + jarEntry.getName()));
                Either either2 = Either.right((Object)Option.none());
                return either2;
            }
            mojo.getLog().debug((CharSequence)("Queueing Java class file: " + Static.pathInJarFile(file, jarEntry.getName())));
            Either either = Either.right((Object)Option.of((Object)new ClassReader(bytes)));
            return either;
        }
        catch (IOException e) {
            return Either.left((Object)VPE4ClassReadFailure.message(jarFile.toString(), e));
        }
    }

    private static Either<Message, List<JarEntry>> streamOfJarEntries(JarFile jarFile) {
        return Either.right((Object)List.ofAll(Static.enumerationAsStream(jarFile.entries())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Either<Message, List<ClassReader>> fromJarFile(Mojo mojo, File file) {
        mojo.getLog().debug((CharSequence)("Examining Jar file " + file.getAbsolutePath()));
        try (JarFile jarFile = new JarFile(file);){
            Either either = AsmClassReaders.streamOfJarEntries(jarFile).map(val -> val.flatMap(entry -> AsmClassReaders.classReaderOf(mojo, file, jarFile, entry)).flatMap(Function.identity()));
            return either;
        }
        catch (IOException e) {
            return Either.left((Object)VPE4ClassReadFailure.message(file.getAbsolutePath(), e));
        }
    }

    private static Either<Message, List<Path>> streamOfPaths(File file) {
        try {
            return Either.right((Object)List.ofAll(Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))));
        }
        catch (IOException e) {
            return Either.left((Object)VPE4ClassReadFailure.message(file.getAbsolutePath(), e));
        }
    }

    static Either<Message, List<ClassReader>> fromFile(Mojo mojo, File file) {
        mojo.getLog().debug((CharSequence)("Examining file " + file.getAbsolutePath()));
        return AsmClassReaders.streamOfPaths(file).map(val -> val.flatMap(path -> AsmClassReaders.classReaderOf(mojo, path)).flatMap(Function.identity()));
    }
}

