/*
 * Decompiled with CFR 0.152.
 */
package vivid.polypara.maven;

import io.vavr.Tuple2;
import io.vavr.collection.List;
import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import vivid.polypara.maven.AsmClassVisitorAdapter;
import vivid.polypara.maven.Mojo;
import vivid.polypara.maven.Static;

class AsmFieldAnnotationScanner
extends AsmClassVisitorAdapter<List<Tuple2<String, Object>>> {
    private final ArrayList<Tuple2<String, Object>> accumulator;
    private Mojo mojo;
    private final Class<?> annotationClass;
    private String clazzName;

    AsmFieldAnnotationScanner(Mojo mojo, Class<?> annotationClass) {
        super(458752);
        this.mojo = mojo;
        this.annotationClass = annotationClass;
        this.accumulator = new ArrayList();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.clazzName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String typeDescriptor, String signature, Object value) {
        return new FieldAnnotationScanner(name, value);
    }

    @Override
    void logStart() {
        this.mojo.getLog().debug((CharSequence)("Scanning for class fields annotated with: " + this.annotationClass));
    }

    @Override
    List<Tuple2<String, Object>> accumulateResult() {
        return List.ofAll(this.accumulator);
    }

    private class FieldAnnotationScanner
    extends FieldVisitor {
        private final String annotationDescriptor;
        private final String fieldName;
        private Object fieldValue;

        private boolean isTargetAnnotation(String fieldTypeDescriptor) {
            return this.annotationDescriptor.equals(fieldTypeDescriptor);
        }

        private FieldAnnotationScanner(String fieldName, Object fieldValue) {
            super(327680);
            this.annotationDescriptor = Type.getType((Class)AsmFieldAnnotationScanner.this.annotationClass).getDescriptor();
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.isTargetAnnotation(descriptor)) {
                AsmFieldAnnotationScanner.this.accumulator.add(new Tuple2((Object)Static.fieldFullyQualifiedName(Type.getObjectType((String)AsmFieldAnnotationScanner.this.clazzName).getClassName(), this.fieldName), this.fieldValue));
            }
            return super.visitAnnotation(descriptor, visible);
        }
    }
}

