/*
 * Decompiled with CFR 0.152.
 */
package vivid.polypara.maven;

import java.util.Objects;

class JavaClasses {
    private static final String JAVA_CLASS_FILENAME_SUFFIX = ".class";
    private static final String JAVA_CLASS_FILE_MAGIC_HEADER = "cafebabe";

    private JavaClasses() {
    }

    static boolean isJavaClassFilename(String filename) {
        return filename.endsWith(JAVA_CLASS_FILENAME_SUFFIX);
    }

    static boolean hasJavaClassFileMagic(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes is null");
        if (bytes.length < 4) {
            return false;
        }
        String magic = String.format("%02X%02X%02X%02X", bytes[0], bytes[1], bytes[2], bytes[3]);
        return JAVA_CLASS_FILE_MAGIC_HEADER.equalsIgnoreCase(magic);
    }
}

