(ns dossier.api.photo-upload
  (:require [cheshire.core :refer [generate-string]]
            [noir.io :refer [create-path upload-file]]
            [dossier.api.api :refer [gen-response]]
            [dossier.validation :refer [invalid-image?]]
            [dossier.utils :as d-utils]
            [dossier.utils :refer [file-exists? file-extension]]))

(def upload-path "resources/public/upload/photo-upload/")
(def public-uri "/upload/photo-upload/")

(defn find-photo [user-id]
  (cond
   (file-exists? (str upload-path user-id ".jpg"))  (str user-id ".jpg")
   (file-exists? (str upload-path user-id ".jpeg")) (str user-id ".jpeg")
   (file-exists? (str upload-path user-id ".png"))  (str user-id ".png")
   (file-exists? (str upload-path user-id ".gif"))  (str user-id ".gif")
   :else false))

(defn photo-url [base-url user-id]
  (if-let [filename (find-photo user-id)]
    (str base-url public-uri filename)
    (str "http://placehold.it/760x240")))

(defn handle-upload [ctx]
  (let [user-id (d-utils/user-id ctx)
        photo (get-in ctx [:request :multipart-params "photo"])
        filename (:filename photo)]
    (cond
     (or (= (:size photo) 0) (nil? photo)) (gen-response "Whoa! The whole point of this form is to upload an image. You didn't even choose one...")
     (invalid-image? photo) (gen-response "Whoa! We only accept png/jpg/jpeg/gif images!")
     :else (try
             (upload-file upload-path (assoc-in photo [:filename] (str user-id "." (file-extension filename))) :create-path? true)
             (gen-response)))))
