(ns dossier.auth.routes
  (:require [compojure.core :refer [ANY defroutes]]
            [liberator.core :refer [resource]]))

(def login-resource
  (resource
    :available-media-types ["text/html"]
    :handle-ok (str "Login!")))

(def logout-resource
  (resource
    :available-media-types ["text/html"]
    :handle-ok (str "Logout!")))

(def auth-routes
  [[:any "login" login-resource]
   [:any "logout" logout-resource]])

