(ns dossier.core
  (:require [clojure.pprint :refer [pprint]]
            [compojure.core :refer [ANY defroutes routes]]
            [compojure.handler :refer [site]]
            [compojure.route :refer [not-found resources]]
            [liberator.core :refer [resource]]
            [liberator.dev :refer [wrap-trace]]
            [ring.middleware.file-info :refer [wrap-file-info]]
            [ring.middleware.params :refer [wrap-params]]
            [ring.middleware.multipart-params :refer [wrap-multipart-params]]
            [dossier.admin.routes :refer [admin-routes]]
            [dossier.api.routes :refer [api-routes]]
            [dossier.auth.routes :refer [auth-routes]]
            [dossier.templates :as tmpl]
            [dossier.web.http :refer [wrap-host-urls ignore-trailing-slash]]
            [helmsman :refer [compile-routes]]))

(def liberator-resources
  {:default (resource
              :allowed-methods [:get]
              :available-media-types ["text/html"]
              :handle-ok (fn [ctx] (tmpl/render (tmpl/view-main ctx))))
   :view (resource
           :allowed-methods [:get]
           :available-media-types ["text/html"]
           :handle-ok (str "View your dossier!")) 
   :update (resource
             :allowed-methods [:get]
             :available-media-types ["text/html"]
             :handle-ok (str "Update your dossier!")) 
   :create (resource
             :allowed-methods [:get]
             :available-media-types ["text/html"]
             :handle-ok (fn [ctx] (tmpl/render (tmpl/view-create-edit ctx))))})

(def helmsman-definition
  [[:resources "/"]
   ^{:name "Dossier"
     :main-menu true}
   [:any "/" (:default liberator-resources)
    ^{:name "View your dossier"}
    [:any "view" (:view liberator-resources)]
    ^{:name "Update your dossier"}
    [:any "update" (:update liberator-resources)]
    ^{:name "Create your dossier"}
    [:any "create/:user-id" (:create liberator-resources)]]
   (into [:context "/admin"] admin-routes)
   (into [:context "/api"] api-routes)
   (into [:context "/auth"] auth-routes)

   ;;; And middleware.
   [wrap-trace :header :ui]
   [wrap-params]
   [wrap-multipart-params]
   [wrap-file-info]
   [wrap-host-urls] ;;; Helmsman is going to handle this.
   ])

(def app (compile-routes helmsman-definition))

