(ns dossier.system
  (:require [org.httpkit.server :refer :all]
            [datomic.api :as d]
            [datomic-schematode.core :as ds-core]
            [dossier.conf :as d-conf]
            [dossier.core :as d-core]
            [dossier.schema :as d-schema]))

(defn system []
  d-conf/load-config)

(defonce server (atom nil))

(defn start-http [system]
  (reset! server (run-server d-core/app {:port (get-in (system) [:web :port])})))

(defn stop-http []
  (when-not (nil? @server)
    ;;Wait 100ms for existing requests to be finished
    (@server :timeout 100)
    (reset! server nil)))

(defn start-datomic [system]
  (if (= (get-in (system) [:db :type]) "datomic")
    (let [d-ss (get-in (system) [:db :storage-service])
          d-name (get-in (system) [:db :db-name])
          d-uri (str "datomic:" d-ss "://" d-name)]
    (d/create-database d-uri)
    (ds-core/load-schema! (d/connect d-uri) d-schema/dossier-schema))))

(defn start [system]
  (start-http system)
  (start-datomic system)
  :done)

(defn stop [system]
  (stop-http))

(defn -main [&args]
  (start system))
