(ns dossier.templates
  (:require [net.cgrand.enlive-html :as html]
            [dossier.api.photo-upload :refer [photo-url]]
            [dossier.utils :as d-utils]
            [dossier.utils :refer [maybe-content
                                                  maybe-substitute]]))

(defn replace-asset-path [base-url]
  (html/transform-content (html/replace-vars {:ASSET_PATH (str base-url "/static/")})))

(defn render [template]
  (reduce str template))

;; base template

(html/deftemplate base "templates/base.html"
  [{:keys [title nav content footer base-url error]}]
  [:#title]        (maybe-content title)
  [:#nav]          (maybe-substitute nav)
  [:#content]      (maybe-substitute content)
  [:#footer]       (maybe-substitute footer)
  [#{:head :body}] (replace-asset-path base-url)
  [:#error]        (maybe-substitute error))

;;snippets

(html/defsnippet nav "templates/snippets/nav.html" [:div#nav]
  [{:keys [brand nav-items]}]
  [:a.navbar-brand] (maybe-content brand))

(html/defsnippet footer "templates/snippets/footer.html" [:footer#footer]
  [])

(html/defsnippet error "templates/snippets/error.html" [:div#error]
  [error]
  [:div#error-msg] (html/transform-content (html/replace-vars {:ERROR_MSG error})))

(html/defsnippet error-hidden "templates/snippets/error-hidden.html" [:div#error]
  [])

;;pages

(html/defsnippet pg-main "templates/pages/main.html" [:div#content]
  [])

(html/defsnippet pg-create-edit "templates/pages/create-edit.html" [:div#content]
  [ctx]
  [:form#photo-upload] (html/set-attr :action (str (d-utils/base-url ctx) "/api/photo-upload/" (d-utils/user-id ctx)))
  [:img#photo] (html/set-attr :src (photo-url (d-utils/base-url ctx) (d-utils/user-id ctx))))

;;navbars
(defn nav-main []
  (nav {:brand "VLACS Dossier"}))

;;layouts

(defn layout-main [title content ctx]
  (base {:title title
         :nav (nav-main)
         :content content
         :footer (footer)
         :base-url (d-utils/base-url ctx)
         :error (if-let [c-error (d-utils/error ctx)] (error c-error) (error-hidden))}))

;;views

(defn view-main [ctx]
  (layout-main "VLACS Dossier" (pg-main) ctx))

(defn view-create-edit [ctx]
  (layout-main "VLACS Dossier - Create / Edit" (pg-create-edit ctx) ctx))
