(ns leiningen.new.vom
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]))

(def render (renderer "vom"))

(defn vom [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
      ["project.clj" (render "project.clj" data)]
      ["resources/public/index.html" (render "index.html" data)]
      ["resources/public/css/style.css" (render "style.css" data)]
      ["src/{{sanitized}}/core.cljs" (render "core.cljs" data)]
      ["src/figwheel/{{sanitized}}_figwheel.cljs" (render "figwheel_watcher.cljs" data)]
      [".gitignore" (render "gitignore" data)])))
