(ns vonrosen.boot-cucumber
  {:boot/export-tasks true}
  ;(:require   [adzerk.boot-test :refer [test] :rename {test test*}])
  ;(:refer-clojure :exclude [test])  
  (:require [boot.pod  :as pod]
            ;[boot.task.built-in :refer [target]]
            [boot.core :as core]
            [adzerk.boot-test :refer [test] :rename {test test*}])
  (:import [cucumber.api.cli Main])
  (:use clojure.test))

(def task-args (atom nil))

#_(deftest cucumber-tests   
   (. cucumber.api.cli.Main (main (into-array @task-args))))

(defn cucumber-tests []   
   (. cucumber.api.cli.Main (main (into-array @task-args))))

(core/deftask cukes
  "Run cucumber tests."
  [g glue VALUE str "Where glue code (step definitions, hooks and plugins) are loaded from." 
   p plugin VALUE str "Register a plugin. Built-in formatter PLUGIN types: junit,
                                         html, pretty, progress, json, usage, rerun,
                                         testng. Built-in summary PLUGIN types:
                                         default_summary, null_summary. PLUGIN can
                                         also be a fully qualified class name, allowing
                                         registration of 3rd party plugins." 
   t tags VALUE str "Only run scenarios tagged with tags matching
                                         TAG_EXPRESSION."
   n name VALUE str "Only run scenarios whose names match REGEXP."
   d dry-run bool "Skip execution of glue code."
   m monochrome bool "Don't colour terminal output."
   s strict bool "Treat undefined and pending steps as errors."
   v version bool "Print version."
   i i18n VALUE str " List keywords for in a particular language. Run with \"--i18n help\" to see all languages"]
  (let [args (vec (flatten 
                     (remove nil? (conj [] 
                                        (if glue
                                          ["--glue" glue]
                                          ["--glue" "features"])
                                        (if plugin
                                          ["--plugin" plugin])
                                        (if tags
                                          ["--tags" tags])
                                        (if name
                                          ["--name" name])
                                        (if dry-run
                                          ["-d"])
                                        (if monochrome
                                          ["-m"])
                                        (if strict
                                          ["-s"])
                                        (if version
                                          ["--version"])
                                        (if i18n
                                          ["--i18n" i18n])))))]    
    (reset! task-args args)    
    ;(merge-env! :source-paths #{"features/step_definitions"})
    ;(merge-env! :resource-paths #{"features/step_definitions"})
    #_(test* :include #".*boot-cucumber.*$")
    (test* :include #".*ui-tests.*$" :shutdown '#{vonrosen.boot-cucumber/cucumber-tests})    
    #_(run-tests (symbol "vonrosen.boot-cucumber"))    
    #_(test* :include #"^.*src.*$")    
    #_(test* :namespaces #{(symbol "vonrosen.boot-cucumber")})
    #_(test* :include #".*ui-tests.*$")))