(ns vonrosen.boot-cucumber
  {:boot/export-tasks true}
  ;(:require   [adzerk.boot-test :refer [test] :rename {test test*}])
  ;(:refer-clojure :exclude [test])  
  (:require [boot.pod  :as pod]
            ;[boot.task.built-in :refer [target]]
            [boot.core :as core]
            [adzerk.boot-test :refer [test] :rename {test test*}]
            [clojure.java.io :as io]
            [clojure.tools.namespace.find :refer [find-namespaces-in-dir]])
  (:import [cucumber.api.cli Main])
  (:use clojure.test))

(def task-args (atom nil))

(def base-pod-deps
  '[[org.clojure/tools.namespace "0.2.11" :exclusions [org.clojure/clojure]]
    [pjstadig/humane-test-output "0.6.0"  :exclusions [org.clojure/clojure]]])

#_(deftest cucumber-tests   
   (. cucumber.api.cli.Main (main (into-array @task-args))))


(defn all-ns* [& dirs]
       (distinct (mapcat #(find-namespaces-in-dir (io/file %)) dirs)))

(core/deftask cukes
  "Run cucumber tests."
  [g glue VALUE str "Where glue code (step definitions, hooks and plugins) are loaded from." 
   p plugin VALUE str "Register a plugin. Built-in formatter PLUGIN types: junit,
                                         html, pretty, progress, json, usage, rerun,
                                         testng. Built-in summary PLUGIN types:
                                         default_summary, null_summary. PLUGIN can
                                         also be a fully qualified class name, allowing
                                         registration of 3rd party plugins." 
   t tags VALUE str "Only run scenarios tagged with tags matching
                                         TAG_EXPRESSION."
   n name VALUE str "Only run scenarios whose names match REGEXP."
   d dry-run bool "Skip execution of glue code."
   m monochrome bool "Don't colour terminal output."
   s strict bool "Treat undefined and pending steps as errors."
   v version bool "Print version."
   i i18n VALUE str " List keywords for in a particular language. Run with \"--i18n help\" to see all languages"]
  (let [args (vec (flatten 
                     (remove nil? (conj [] 
                                        (if glue
                                          ["--glue" glue]
                                          ["--glue" "features"])
                                        (if plugin
                                          ["--plugin" plugin])
                                        (if tags
                                          ["--tags" tags])
                                        (if name
                                          ["--name" name])
                                        (if dry-run
                                          ["-d"])
                                        (if monochrome
                                          ["-m"])
                                        (if strict
                                          ["-s"])
                                        (if version
                                          ["--version"])
                                        (if i18n
                                          ["--i18n" i18n])))))]

    (let [pod-deps (core/get-env)
            worker-pods (pod/pod-pool pod-deps)]  
        (core/with-pre-wrap fileset
          #_(prn ~@(->> fileset
                                     core/input-dirs
                                     (map (memfn getPath))))
          #_(prn        
             (pod/with-eval-in (worker-pods :refresh)
               (distinct (mapcat #(find-namespaces-in-dir (io/file %)) 
                                 ~@(->> fileset
                                     core/input-dirs
                                     (map (memfn getPath)))))
              
               #_(all-ns* ~@(->> fileset
                                                             core/input-dirs
                                                             (map (memfn getPath))))))
          (reset! task-args args)
          (prn @task-args)
          (core/merge-env! :source-paths #{"ui_tests/clj" "features/step_definitions"})
          (core/merge-env! :resource-paths #{"features/step_definitions"})
          ;(test* :include #".*vonrosen.*$")
          (run-tests (symbol "vonrosen.boot-cucumber"))
          
          (core/commit! fileset)
    
        ;(test* :include #".*ui-tests.*$" :startup '#{vonrosen.boot-cucumber/cucumber-tests})    
        #_(run-tests (symbol "vonrosen.boot-cucumber"))    
        #_(test* :include #"^.*src.*$")    
        #_(test* :namespaces #{(symbol "vonrosen.boot-cucumber")})
        #_(test* :include #".*ui-tests.*$")))))

(deftest cucumber-tests
  (prn "do it")
  (prn @task-args)
  (. cucumber.api.cli.Main (main (into-array @task-args))))